-- class.lua
-- Compatible with Lua 5.1 (not 5.0).

function class(base, init)
   local c = {}    -- a new class instance

   if not init and type(base) == 'function' then
      init = base
      base = nil
   elseif type(base) == 'table' then
      -- our new class is a shallow copy of the base class!
      for i,v in pairs(base) do
         c[i] = v
      end
      c._base = base
   end

   -- the class will be the metatable for all its objects,
   -- and they will look up their methods in it.

   c.__index = c
   -- expose a constructor which can be called by <classname>(<args>)
   local mt = {}
   mt.__call = function(class_tbl, ...)
      local obj = {}
      setmetatable(obj, c)

      if class_tbl.__init then
	 class_tbl.__init(obj,...)
      else 
	 -- make sure that any stuff from the base class is initialized!
	 if class_tbl._base and class_tbl._base.__init then
	    class_tbl._base.__init(obj, ...)
	 end
      end
      return obj
   end

   c.__init = init

   c.__is_a = function(self, klass)
      local m = getmetatable(self)
      while m do 
         if m == klass then return true end
         m = m._base
      end
      return false
   end

   c.__copy = function(self)
      local copy, i, v;
      copy = { } 
      setmetatable(copy, getmetatable(self))
      for i,v in pairs(self) do
         copy[i] = v
      end	 
      return copy
   end
   
   setmetatable(c, mt)
   return c
end


function NEW(name, ...)
   return require(name)(...)
end