                       Руководство пользователя aptitude

Версия 0.6.11

  Daniel Burrows

   <dburrows@debian.org>

   Авторские права © 2004-2008 Daniel Burrows

   Это руководство является свободным программным обеспечением; вы можете
   распространять его и/или модифицировать в соответствии с условиями GNU
   General Public License, как она опубликована Free Software Foundation;
   либо версии 2 этой лицензии, либо (по вашему выбору) любой более поздней
   версии.

   Это руководство распространяется в надежде, что оно будет полезно, но БЕЗ
   КАКОЙ-ЛИБО ГАРАНТИИ; даже без предполагаемой гарантии ТОВАРНОЙ ПРИГОДНОСТИ
   или пригодности для КОНКРЕТНОГО ПРИМЕНЕНИЯ. Подробности см. в GNU General
   Public License.

   Вы должны были получить копию GNU General Public License вместе с этим
   руководством. Если вы её не получили, напишите в Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

   --------------------------------------------------------------------------

   Содержание

   Введение

                Что же такое этот aptitude?

                Что такое менеджер пакетов?

                Что такое система apt?

                Как я могу получить aptitude?

                             Собранные пакеты aptitude или то, «что должны
                             сделать 99% пользователей»

                             Сборка aptitude из исходного кода

                             Отслеживание развития aptitude и участие в нем

   1. Приступая к работе

                Использование aptitude

                             Основы aptitude

                             Перемещение по списку пакетов aptitude

                             Поиск пакета по имени

                             Управление пакетами

                             Обновление списка пакетов и установка пакетов

                Использование aptitude из командной строки

   2. Справочное руководство aptitude

                Терминальный пользовательский интерфейс aptitude

                             Использование меню

                             Меню команд

                             Работа с несколькими окнами

                             Становимся root

                Управление пакетами

                             Управление списком пакетов

                             Доступ к информации о пакете

                             Изменение состояний пакета

                             Загрузка, установка и удаление пакетов

                             Понимание и управление надёжностью пакетов

                             Управление пакетами, установленными
                             автоматически

                Разрешение зависимостей пакетов

                             Разрешение зависимостей в aptitude

                             Непосредственное разрешение зависимостей

                             Интерактивное разрешение зависимостей

                             Стоимость в интерактивном решателе зависимостей

                             Настройка интерактивного решателя зависимостей

                Поисковые шаблоны

                             Поиск строк

                             Сокращения для поисковых терминов

                             Поиск и версии

                             Явные цели поиска

                             Руководство по поисковым терминам

                Настройка aptitude

                             Настройка списка пакетов

                             Настройка привязки клавиш

                             Настройка цветов и стилей текста

                             Настройка разметки экрана

                             Руководство по файлу настроек

                             Темы

                Играем в Сапёра

   3. Часто задаваемые вопросы aptitude

   4. Список разработчиков

   I. Руководство по командной строке

                aptitude — высокоуровневый интерфейс для менеджера пакетов

                aptitude-create-state-bundle — связать текущее состояние
                aptitude

                aptitude-run-state-bundle — распаковать пакет состояния
                aptitude и передать его aptitude

   Список иллюстраций

   2.1. Команды, доступные в меню Действия

   2.2. Команды, доступные в меню Откат

   2.3. Команды, доступные в меню Пакет

   2.4. Команды, доступные в меню Решатель

   2.5. Команды, доступные в меню Поиск

   2.6. Команды, доступные в меню Параметры

   2.7. Команды, доступные в меню Окна

   2.8. Команды, доступные в меню Справка

   2.9. Значения флага «текущее состояние»

   2.10. Значения флага «действие»

   2.11. Синтаксис составных стоимостных компонент

   2.12. Уровни стоимости безопасности

   2.13. Синтаксис термина ?for

   2.14. Настраиваемые стили aptitude

   Список таблиц

   2.1. Базовые стоимостные компоненты

   2.2. Уровни стоимости безопасности по-умолчанию

   2.3. Краткое руководство по поисковым терминам

   Список примеров

   2.1. Примеры стоимости решателя

   2.2. Использование термина ?=

   2.3. Использование термина ?bind

   2.4. Использование термина ?exact-name

   2.5. Использование термина ?for

   2.6. Использование термина ?term-prefix

   2.7. Использование pattern для группировки пакетов по сопровождающему

   2.8. Использование pattern с некоторыми пакетами, помещенными на верхний
   уровень

   2.9. Использование политики группировки pattern с подполитиками

   10. Использование --show-summary

                                    Введение

   Содержание

   Что же такое этот aptitude?

   Что такое менеджер пакетов?

   Что такое система apt?

   Как я могу получить aptitude?

                Собранные пакеты aptitude или то, «что должны сделать 99%
                пользователей»

                Сборка aptitude из исходного кода

                Отслеживание развития aptitude и участие в нем

     «Учитель, обладает ли Emacs природой Будды?» спросил ученик.            

     «Почему бы и нет,» ответил учитель. «В нем, черт возьми, есть все.»
     Через несколько лет ученик неожиданно достиг просветления.
                                                                -- John Fouhy

   Привет, и добро пожаловать в руководство пользователя aptitude! В этом
   вводном разделе объясняется то, чем является aptitude и как его получить.
   Для информации о том, как его использовать, см. Глава 1, Приступая к
   работе.

Что же такое этот aptitude?

   aptitude — это менеджер пакетов для систем Debian GNU/Linux с множеством
   функций. Он основан на знаменитой инфраструктуре управления пакетами apt.
   aptitude предоставляет функциональность dselect и apt-get, а также многие
   другие функции, которых нет ни в той, ни в другой программе.

Что такое менеджер пакетов?

   Менеджер пакетов следит за тем, какие программы установлены на вашем
   компьютере, и позволяет вам легко устанавливать новые программы, обновлять
   программы до более новых версий или удалять те программы, которые вы ранее
   установили. Как предполагает само название, менеджеры пакетов имеют дело с
   пакетами — наборами файлов, которые упакованы вместе и могут быть
   установлены или удалены группой.

   Зачастую, пакет представляет собой просто отдельную программу. Например,
   клиент мгновенных сообщений gaim находится в пакете Debian с таким же
   именем. С другой стороны, для программ вполне нормально состоять из
   нескольких взаимосвязанных пакетов. Например, графический редактор gimp
   состоит не только из пакета gimp, но и из пакета gimp-data; так же
   доступны необязательные пакеты с дополнениями (содержащими эзотерические
   данные, документацию и т.д.). Несколько небольших связанных программ могут
   входить в один пакет, например, пакет fileutils содержит несколько общих
   команд Unix, таких как ls, cp и т.д.

   Некоторым пакетам для работы требуются другие пакеты. В Debian пакеты
   могут зависеть от других пакетов, рекомендовать, предлагать, ломать их или
   конфликтовать с ними.

     * Если пакет A зависит от другого пакета B, то B требуется для
       правильной работы A. Например, пакет gimp зависит от пакета gimp-data,
       поскольку необходимо гарантировать, что графическому редактору GIMP
       доступны необходимые файлы данных.

     * Если пакет A рекомендует другой пакет B, то пакет B предоставляет
       важную дополнительную функциональность пакету A, которая желательна в
       большинстве случаев. Например, пакет mozilla-browser рекомендует пакет
       mozilla-psm, который добавляет поддержку безопасной передачи данных
       веб-браузеру Mozilla. В то время как пакет mozilla-psm не строго
       требуется для работы Mozilla, большинство пользователей хотят, чтобы
       Mozilla поддерживал безопасную передачу конфиденциальных данных (таких
       как номера кредитных карт).

     * Если пакет A предлагает другой пакет B, то пакет B предоставляет
       функциональность, которая может улучшить пакет A, но не является
       необходимой в большинстве случаев. Например, пакет kmail предлагает
       пакет gnupg, содержащий программу для шифрования, которая может
       использоваться KMail.

     * Если пакет A конфликтует с другим пакетом B, то эти два пакета не
       могут быть установлены одновременно. Например, пакет fb-music-hi
       конфликтует с пакетом fb-music-low, поскольку они предоставляют
       альтернативные наборы музыки для игры Frozen Bubble.

   Работа менеджера пакетов заключается в предоставлении интерфейса, который
   помогает пользователю в управлении набором пакетов, установленных в его
   или её системе. aptitude предоставляет такой интерфейс на основе системы
   управления пакетами apt.

Что такое система apt?

   Очень хорошо иметь возможность устанавливать и удалять пакеты, и базовая
   программа для этого (известная как dpkg) делает именно это и ничего
   больше. Это не затрудняет, если вы скачали один или два пакета вручную, но
   становится слишком обременительным, когда вы пытаетесь управлять большим
   числом пакетов. Более того, если ваш превосходный новый пакет требует
   такие программы, которые у вас ещё не установлены, то вам придётся скачать
   и это требуемое программное обеспечение вручную. И если вы позже решите
   удалить этот не такой уж и превосходный пакет, то эти дополнительные
   пакеты сохранятся установленными в вашей системе, потребляя место на
   жёстком диске, пока вы вручную не удалите их.

   Очевидно, такой ручной труд является утомительной работой. Поэтому
   большинство систем управления пакетами содержат программы, которые
   заботятся об этом вместо вас. apt представляет собой базу, на которой
   строятся такие программы. Помимо aptitude, apt используется в программах
   synaptic и apt-watch.

   apt работает, сохраняя на вашем компьютере список пакетов, который может
   быть скачан из архива Debian. Этот список используется для поиска пакетов,
   которые следует обновить, и для установки новых пакетов. apt также может
   автоматически разрешать многие проблемы с зависимостями, например, когда
   вы выбираете пакет к установке, он найдёт все дополнительные требуемые
   пакеты и также установит их.

   Работая с менеджером пакетов, основанным на apt, таким как aptitude, вы
   обычно будете выполнять три простых задачи: обновлять список доступных
   пакетов, скачивая новые списки пакетов с серверов Debian, выбирать, какие
   пакеты следует установить, обновить или удалить, и, наконец, вы будете
   совершать ваш выбор, фактически выполняя установку, удаление и т.д.

   Менеджеры пактов, основанные на apt считывают список «источников» —
   репозиториев пакетов Debian — из файла /etc/apt/sources.list. Формат и
   содержание этого файла выходят за рамки настоящего документа, но описаны
   на странице руководства sources.list(5).

Как я могу получить aptitude?

   В случае если вы читаете это руководство, но aptitude ещё не установлен в
   вашей системе, в этом разделе вы найдёте объяснение того, как исправить
   эту прискорбную ситуацию. Большинству людей следует перейти прямо к
   разделу о двоичных пакетах.

  Собранные пакеты aptitude или то, «что должны сделать 99% пользователей»

   Собранные, или «двоичные» пакеты являются наиболее простым и наиболее
   распространённым способом установки aptitude. Установку из исходных
   текстов следует выполнять только в том случае, если двоичные пакеты по
   какой-то причине не доступны, или если у вас имеется какая-либо
   исключительная необходимость, которая не может быть удовлетворена
   двоичными пакетами.

   Если вы используете систему Debian, выполните следующую команду от имени
   root: apt-get install aptitude. Если вы не используете систему Debian,
   поставщик вашей системы, возможно, создал собранный пакет aptitude; если
   вы не уверены в этом, то можете связаться с ним для дальнейших указаний.

  Сборка aptitude из исходного кода

   Также вы можете собрать aptitude из исходных текстов; однако это,
   вероятно, не такое уж полезное занятие, если в вашей системе уже имеется
   apt. Если же это вам необходимо, вы можете установить aptitude из исходных
   текстов, выполняя следующие шаги:

    1. Установите следующие компоненты:

          * Компилятор C++, такой как g++.

          * Файлы разработки для apt, обычно они доступны в пакете с именем
            вида libapt-pkg-dev.

          * Библиотека libsigc++-2.0, доступная в пакете libsigc++-2.0-dev
            или здесь: http://libsigc.sourceforge.net.

          * Библиотека cwidget, доступная в пакете libcwidget-dev или здесь:
            http://cwidget.alioth.debian.org.

          * Программа gettext, которая должна быть включена в ваш дистрибутив
            Linux.

          * Инструмент make, такой как GNU make.

    2. И последнее, но не менее важное, скачайте наиболее свежую версию
       исходного кода aptitude, доступную здесь:
       http://packages.debian.org/unstable/admin/aptitude. (перейдите вниз
       страницы и скачайте файл «.orig.tar.gz» )

   Когда все требуемые компоненты будут доступны, откройте терминал и
   выполните команду tar zxf aptitude-0.6.11.tar.gz для того, чтобы
   распаковать исходный код. Когда исходный код будет распакован, введите cd
   aptitude-0.6.11 && ./configure && make для того, чтобы скомпилировать
   aptitude. Если это удалось, убедитесь, что вы являетесь пользователем root
   (используя, например, команду su), затем введите make install, чтобы
   установить aptitude на ваш компьютер. Когда aptitude будет успешно
   установлен, команда aptitude в командной строке должна запустить
   программу.

  Отслеживание развития aptitude и участие в нем

    Получение дерева разрабатываемого исходного кода aptitude

   Если вы хотите протестировать наиболее последний и передовой исходный код
   aptitude, вы можете скачать невыпущенный исходный код aptitude, используя
   Git. Установите Git (доступен здесь: http://git-scm.com/) и выполните
   команду git clone git://anonscm.debian.org/aptitude/aptitude.git для
   получения наиболее свежего исходного кода.

   [Preduprezhdenie] Предупреждение
                     Git репозиторий aptitude является активным деревом
                     разработки; оно изменяется при исправлении ошибок и
                     добавлении новых возможностей, нет абсолютно никакой
                     гарантии, что код даже будет компилироваться, и уж тем
                     более корректно работать! Отчеты об ошибках
                     приветствуются, но помните, что вы используете
                     разрабатываемый код всецело на ваш собственный страх и
                     риск!^[1]

    Список рассылки

   Основной список рассылки для разработки aptitude здесь:
   <aptitude-devel@lists.alioth.debian.org>. Архивы списка рассылки
   расположены здесь:
   http://lists.alioth.debian.org/pipermail/aptitude-devel/. Чтобы
   подписаться на список рассылки, посетите веб страницу
   http://lists.alioth.debian.org/mailman/listinfo/aptitude-devel.

    Представление заплат

   В идеале, заплаты следует отправлять в список рассылки aptitude,
   <aptitude-devel@lists.alioth.debian.org>. Но если вы предпочитаете
   отправлять их на частный email, то вы можете отправить их по адресу
   <aptitude@packages.debian.org> или <dburrows@debian.org>. Высоко ценится
   наличие небольшого описания мотивации вашей заплаты и объяснение того, как
   она работает.

    Отслеживание изменений в дереве исходного кода aptitude

   Дерево исходного кода aptitude регулярно обновляется: добавляются новые
   функции, исправления ошибок и новые ошибки. Когда исходный код будет
   доступен на вашем компьютере (см. предыдущий раздел), вы сможете перейти
   (cd) в него и ввести git pull для того, чтобы обновить исходный код и
   получить все изменения из основного репозитория.

   Для того, чтобы автоматически получать уведомления о том, когда в кодовую
   базу aptitude вносятся изменения, подпишитесь на Atom-канал, доступный по
   адресу http://anonscm.debian.org/gitweb/?p=aptitude/aptitude.git;a=atom
   или RSS-канал, доступный по адресу
   http://anonscm.debian.org/gitweb/?p=aptitude/aptitude.git;a=rss.

    Сборка aptitude из дерева разработки

   Чтобы собрать aptitude из репозитория Git, вы должны установить программы
   autoconf и automake. Введите sh ./autogen.sh && ./configure, чтобы создать
   необходимые для компиляции aptitude файлы, затем выполните make и make
   install.

   --------------------------------------------------------------------------

   ^[1] Конечно, все свободное программное обеспечение вы используете на ваш
   собственный страх и риск, но риск использования активно разрабатываемого
   дерева исходного кода еще более высок.

                          Глава 1. Приступая к работе

   Содержание

   Использование aptitude

                Основы aptitude

                Перемещение по списку пакетов aptitude

                Поиск пакета по имени

                Управление пакетами

                Обновление списка пакетов и установка пакетов

   Использование aptitude из командной строки

           Путешествие в тысячу ли начинается с одного шага.           
                                                                   -- Лао Цзы

   aptitude является довольно большой программой с множеством функций, и
   знакомство с ней может оказаться чрезвычайно сложным для новых
   пользователей. Эта глава не призвана дать исчерпывающее описание всех
   возможностей aptitude (для этого см. Глава 2, Справочное руководство
   aptitude), она представляет собой пошаговое руководство по базовым и
   наиболее часто используемым функциям программы.

Использование aptitude

   Этот раздел описывает то, как использовать визуальный интерфейс aptitude.
   Информацию об использовании aptitude в интерфейсе командной строки см. в
   «Использование aptitude из командной строки».

  Основы aptitude

   Чтобы запустить aptitude, откройте ваш любимый текстовый терминал и
   введите в командной строке (foobar$ — это приглашение командной строки,
   вводить его не надо):

 foobar$ aptitude

   Когда будет загружен кэш (это может занять некоторое время на более
   медленных машинах), должно будет появиться основное окно aptitude:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --- Установленные пакеты
 --- Неустановленные пакеты
 --- Устаревшие и пакеты, созданные локально
 --- Виртуальные пакеты
 --- Задачи






 Эти пакеты уже установлены на вашем компьютере.









   Как вы можете видеть, основное окно aptitude разделено на несколько
   областей. Голубая линия в верхней части терминала — строка меню, а голубые
   линии под ней — информационные сообщения, описывающие некоторые важные
   команды. Чёрное пространство, расположенное далее — список всех доступных
   пакетов, в котором приведены некоторые группы пакетов. Выбранная в
   настоящий момент группа («Установленные пакеты») подсвечена, и её описание
   показано в нижнем чёрном пространстве.

   Как предполагается верхней линией окна, вы можете получить доступ к меню
   aptitude, нажав Control+t; вы также можете кликнуть мышью на нужном пункте
   меню, если ваша система это поддерживает. Нажатие Control+t откроет меню
   Действий:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 +-------------------------+  u: Обновление  g: Загр/Устан/Удал пакетов
 |Установить/удалить пакеты g|
 |Обновить список пакетов     u|
 |Забыть о новых пакетах     f|
 |Очистить кэш пакетов      |нные локально
 |Очистить устаревшие файлы     |
 |Пометить обновляемые         U|
 |Играть в сапёра         |
 |Стать суперпользователем              |
 +-------------------------+
 |Выход                    Q|
 +-------------------------+
 Эти пакеты уже установлены на вашем компьютере.









 Выполнить все незаконченные установки и удаления

   Используйте клавиши со стрелками и Enter для того, чтобы выбирать пункты
   меню (или, если ваша система поддерживает это, используйте мышь); чтобы
   закрыть меню, не выбирая ничего, снова нажмите Control+t. Подсвеченный в
   настоящее время пункт меню объясняется в нижней части окна. Если пункт
   меню может быть активирован при помощи горячей клавиши, соответствующая
   горячая клавиша отображается в меню: например, команда «Обновить список
   пакетов» может быть активирована нажатием u.

   В любое время вы можете нажать ?, чтобы отобразить интерактивный
   справочник доступных горячих клавиш.

  Перемещение по списку пакетов aptitude

   Список пакетов является основным интерфейсом aptitude. Когда запускается
   aptitude, список организуется в ряд групп, как это можно видеть на
   следующем снимке экрана:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --- Установленные пакеты
 --- Неустановленные пакеты
 --- Устаревшие и пакеты, созданные локально
 --- Виртуальные пакеты
 --- Задачи






 Эти пакеты уже установлены на вашем компьютере.









   [Primechanie] Примечание
                 Пустые группы автоматически скрываются aptitude, поэтому вы
                 можете видеть больше или меньше групп, чем на приведённом
                 снимке экрана.

   На снимке экрана выше первая группа («Установленные пакеты») подсвечена,
   что показывает, что она выбрана в настоящий момент. Вы можете переместить
   выбор вверх или вниз при помощи клавиш со стрелками; заметьте, описание
   под списком пакетов меняется при изменении выбора. Чтобы «раскрыть»
   группу, выберите её и нажмите Enter:

  Действия  Откат  Пакет  Поиск  Опции  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --\ Установленные пакеты
   --- admin - Утилиты администрирования (установка ПО, управление пользователями и т.д.)
   --- base - The Debian base system
   --- devel - Утилиты и программы для разработки ПО
   --- doc - Документация и специальные программы просмотра документации
   --- editors - Текстовые редакторы и текстовые процессоры
   --- electronics - Программы для работы со схемами и электроникой
   --- games - Игры, развлечения и забавные программы
   --- gnome - Настольная система GNOME
   --- graphics - Утилиты для создания, просмотра и редактирования графических файлов

 Эти пакеты уже установлены на вашем компьютере.









   Как вы можете видеть, раскрыта группа «Установленные пакеты», последнее
   демонстрирует её содержание: она содержит ряд подгрупп, неточно
   определённых типами программ, содержащихся в них. Раскрыв раздел «admin»
   путём выбора его и нажатия Enter, мы увидим:

  Действия  Откат  Пакет  Поиск  Опции  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --\ Установленные пакеты
   --\ admin - Утилиты администрирования (установка ПО, управление пользователями и т.д.)
     --- main - Главный архив Debian
   --- base - The Debian base system
   --- devel - Утилиты и программы для разработки ПО
   --- doc - Документация и специальные программы просмотра документации
   --- editors - Текстовые редакторы и текстовые процессоры
   --- electronics - Программы для работы со схемами и электроникой
   --- games - Игры, развлечения и забавные программы
   --- gnome - Настольная система GNOME

 Пакеты в разделе 'admin' позволяют вам выполнять административные задачи, такие
 как установка программ, управление пользователями, настройка и мониторинг вашей системы,
 анализ сетевого трафика и так далее.







   Группа «admin» содержит одну подгруппу, «main» архив Debian. Раскрыв эту
   группу, мы обнаруживаем пакеты!

   [Podskazka] Подсказка
               Для сохранения времени, вы можете использовать клавишу [,
               чтобы раскрыть все подгруппы некоторой группы за раз. Выбор «
               Установленные пакеты» и нажатие клавиши [ немедленно открыло
               бы пакеты, которые можно видеть ниже на снимке экрана.

  Действия  Откат  Пакет  Поиск  Опции  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --\ Установленные пакеты
   --\ admin - Утилиты администрирования (установка ПО, управление пользователями и т.д.)

     --\ main - Главный архив Debian

 i     acpid                                                1.0.3-19   1.0.3-19
 i     alien                                                8.44       8.44
 i     anacron                                              2.3-9      2.3-9
 i     apt-show-versions                                    0.07       0.07
 i A   apt-utils                                            0.5.25     0.5.25
 i     apt-watch                                            0.3.2-2    0.3.2-2
 i     aptitude                                             0.2.14.1-2 0.2.14.1-2

 Дистрибутив Debian состоит из пакетов раздела 'main'. Каждый
 пакет в 'main' является Свободным ПО.

 Более подробно о том, по каким критериям в Debian решают, является ПО свободным или нет, см. здесь:
 http://www.debian.org/social_contract#guidelines





   В дополнение к клавишам со стрелками, вы можете перемещать выбор по списку
   пакетов сразу на целую страницу информации, используя клавиши Page Up и
   Page Down.

   [Podskazka] Подсказка
               Когда имеется большее количество информации, чем то, что
               вмещается на нижней части экрана, нажатие клавиш a и z может
               использоваться для её прокручивания.

  Поиск пакета по имени

   Чтобы быстро найти пакет, имя которого вам известно, нажмите клавишу / для
   открытия диалога поиска:

  Действия  Откат  Пакет  Поиск  Опции  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 i     frozen-bubble                                        1.0.0-5    1.0.0-5
 i A   frozen-bubble-data                                   1.0.0-5    1.0.0-5
 i     geekcode                                             1.7.3-1    1.7.3-1
 i     gfpoken                                              0.25-3     0.25-3
 i     ggz-gnome-client                                     0.0.7-2    0.0.7-2
 i     ggz-gtk-client                                       0.0.7-1    0.0.7-1
 i     ggz-gtk-game-data                                    0.0.7-2    0.0.7-2
 i +--------------------------------------------------------------------------+
 i |Поиск:                                                               |
 i |froz                                                                      |
 Po|                             [ Ok ]                             [ Отменить ]|
 Fr+--------------------------------------------------------------------------+
 их лопнуть. Содержит 100 уровней однопользовательской игры, режим для двух игроков, музыку и замечательную графику


 По слухам, эта игра привела к задержке выпуска Woody.

 URL: http://www.frozen-bubble.org/


   Как вы можете видеть на снимке экрана выше, поиск по froz находит пакет
   frozen-bubble. Использование мощного поискового языка aptitude описано в
   «Поисковые шаблоны», пакеты можно искать по очень многим сложным
   критериям.

   [Podskazka] Подсказка
               Вы можете проводить поиск в обратном направлении по списку
               пакетов, нажав \, и вы можете повторить последний поисковый
               запрос, нажав n после закрытия окна поиска.

   Иногда полезно скрыть все пакеты за исключением тех, которые удовлетворяют
   некоторому специальному условию. Чтобы сделать это, нажмите l:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --- Установленные пакеты
 --- Неустановленные пакеты
 --- Устаревшие и пакеты, созданные локально
 --- Виртуальные пакеты
 --- Задачи


   +--------------------------------------------------------------------------+
   |Введите новый лимит для дерева пакетов:                                         |
   |apti                                                                      |
   |                             [ Ok ]                             [ Отменить ]|
 Th+--------------------------------------------------------------------------+ a









   Это диалоговое окно работает в точности также как окно поиска, но вместо
   подсвечивания следующего пакета, удовлетворяющего тому, что вы ввели, оно
   скрывает все пакеты, не удовлетворяющие тому, что вы ввели. Например, ввод
   apti в это диалоговое окно и нажатие клавиши Enter скроет все пакеты за
   исключением тех, чьи имена содержат «apti»:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --\ Установленные пакеты
   --\ admin - Утилиты администрирования (установка ПО, управление пользователями и т.д.)

     --\ main - Главный архив Debian
 i     aptitude                                             0.2.14.1-2 0.2.14.1-2
 i A   synaptic                                             0.51-1     0.51-1
   --\ x11 - X window system и ПО для нее
     --\ main - Главный архив Debian
 i     xfree86-driver-synaptics                             0.13.3-1   0.13.3-1
 --- Неустановленные пакеты
 --- Виртуальные пакеты

 Эти пакеты уже установлены на вашем компьютере.









  Управление пакетами

   Теперь, когда вы можете перемещаться по списку пакетов, пора начать
   использовать aptitude для того, чтобы устанавливать и удалять пакеты. В
   этом разделе вы узнаете как отмечать пакеты для установки, удаления или
   обновления.

   [Podskazka] Подсказка
               Вы можете изменять настройки вашей системы лишь будучи
               пользователем root. Если вы хотите поэкспериментировать с
               aptitude, вы можете безопасно запустить её от имени любого
               пользователя, отличного от root не повредив никоим образом
               вашу систему. aptitude сообщит вам, когда вы попытаетесь
               сделать что-то, что может сделать только root, и если вы
               захотите продолжить, вам необходимо будет ввести пароль
               пользователя root.

   Все изменения состояния пакета осуществляются путём его выделения в списке
   пактов, и затем нажатием клавиши, соответствующей выполняемому действию.
   Базовыми клавишами действий ^[2] являются + для установки или обновления
   пакета, - для удаления пакета, и = для предотвращения автоматического
   обновления пакета (это действие известно как фиксация пакета). Указанные
   действия не выполняются тотчас же; aptitude лишь обновит список пакетов,
   чтобы показать запрошенное изменение.

   Например, на снимке экрана ниже, был выбран пакет kaffeine-mozilla и
   нажата клавиша +. Пакет в настоящий момент подсвечен зелёным, а слева от
   его имени появилась буква «i», что означает, что этот пакет будет
   установлен; дополнительно отображается оценка пространства на диске,
   которое будет использоваться этим пакетом.

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1                  Будет использовано 2925kB дис  DL размер: 1375kB
   --\ kde - Настольная система KDE
     --\ main - Главный архив Debian
 p     bibletime-i18n                                        <none>     1.4.1-1
 p     education-desktop-kde                                 <none>     0.771
 p     junior-kde                                            <none>     1.4
 piA   kaffeine                                      +2843kB <none>     0.4.3-1
 pi    kaffeine-mozilla                              +81.9kB <none>     0.4.3-1
 p     karamba                                               <none>     0.17-5
 p     kde-devel                                             <none>     4:3.1.2
 p     kde-devel-extras                                      <none>     4:3.1.2
 Окружение рабочего стола K (файлы разработка)
 Метапакет, содержащий зависимости для базового набора разработчика KDE,
 включая kdesdk, qt3-designer и все базовые KDE -dev пакеты.








   [Podskazka] Подсказка
               В любое время вы можете использовать Откат → Откат
               (Control+u), чтобы «откатить» любое изменение одного или
               нескольких пакетов. Это очень полезно, если действие имеет
               непредвиденные последствия, и вы хотите «вернуть все назад».

   В дополнение к действиям, которые затрагивают отдельные пакеты, доступно
   другое важное действие: ввод U приведёт к попытке обновить все пакеты,
   которые могут быть обновлены в настоящий момент. Вы должны регулярно
   использовать эту команду, чтобы поддерживать свою систему в актуальном
   состоянии.

    Управление сломанными пакетами

   Иногда изменение состояния пакета приводит к тому, что зависимости
   оказываются неудовлетворенными; пакеты с неудовлетворенными зависимостями
   называются сломанными. aptitude оповестит вас, когда такое произойдет, и
   объяснит, почему это произошло. Например, вот что произойдет, если я
   попытаюсь удалить пакет libreoffice-base:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.6.8.2       #Сломано: 2   Освободится на диске 9 297 кБ
 id   libreoffice-base                                    -9 297 kB 1:3.5.4+dfsg-4  1:3.5.4+dfsg-4
 i     mysql-common                                   5.5.30+dfsg-1 5.5.30+dfsg-1
 i   sqlitebrowser                                        2.0.0~beta1+ds   2.0.0~beta1+ds
 i     unixdbc                                             2.2.14p2-5   2.2.14p2-5
 i    virtuoso-minimal                                                  6.1.4+dfsg1-6   6.1.4+dfsg1-6
 i     virtuoso-opensource-6.1-bin                                        6.1.4+dfsg1-6  6.1.4+dfsg1-6
 i     virtuoso-opensource-6.1-common                                            6.1.4+dfsg1-6   6.1.4+dfsg1-6
    --- devel - Утилиты и программы для разработки ПО (57)
    --- doc - Документация и специальные программы для просмотра документации (51)
 office-productivity suit — database
 libreoffice-base будет удалён.


 Следующие пакеты зависят от libreoffice-base и будут испорчены
 удалением:


   * libreoffice зависит от libreoffice-base
   * libreoffice-report-builder-bin зависит от libreoffice-base

 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Как вы можете видеть, aptitude отображает три индикатора о том, что что-то
   пошло не так: во-первых, количество сломанных пакетов отображается в
   верхней синей области; во-вторых, нижняя половина окна меняется на
   описание сломанных пакетов, связанных с выбранным в данный момент пакетом;
   в-третьих, внизу экрана появляется полоса с предложением того, как
   разрешить проблему. Чтобы быстро найти сломанные пакеты в списке пакетов,
   вы можете нажать клавишу b или ввести поисковой запрос ?broken.

   [Primechanie] Примечание
                 Текст [1(1)/...] показывает прогресс решателя зависимостей
                 aptitude. Первое число — решение, выбранное вами в данный
                 момент, а второе — количество уже сгенерированных
                 решенийaptitude. Наличие текста «...» обозначает, что могут
                 иметься дополнительные решения помимо тех, что уже
                 сгенерированы; если aptitude точно известно, что было
                 сгенерировано единственное возможное решение, этот индикатор
                 бы выглядел так: [1/1].

   Чтобы увидеть больше информации о том, как aptitude предлагает вам
   разрешить эту проблему, нажмите клавишу e. Появится окно похожее на
   следующее:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Разрешить зависимости
   --\ Удалить следующие пакеты:
     libreoffice-report-builder-bin                           [1:3.5.4+dfsg-4 (now, testing)]
     libreoffice                                                [1:3.5.4+dfsg-4 (now, testing)]
















 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   В этом окне вы можете увидеть больше решений, нажимая клавишу . или
   возвратиться к решениям, которые вы ранее рассмотрели, нажимая ,. Чтобы
   применить текущее решение и вернуться к списку пакетов, нажмите !.
   Например, нажатие . на снимке экрана, расположенном выше, приведёт к тому,
   что будет представлено следующее решение:

   Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Resolve Dependencies
   --\ Сохранить для следующих пакетов их текущие версии:
     libreoffice-base                                      [1:3.5.4+dfsg-4 (now, testing)]

















 [2(2)/...] Предлагается выполнить 1 оставить неизменным
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   В дополнение к базовым командам навигации по решениям, вы можете нажать r,
   чтобы «отказаться» от действий, которые вы не одобряете. Например, первое
   решение удалит пакет libreoffice. Нажимая r, когда выбран объект,
   соответствующий этому действию, мы сообщаем aptitude, что он не должен
   удалять пакет libreoffice.

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Разрешить зависимости
   --\ Удалить следующие пакеты:
     libreoffice-report-builder-bin                           [1:3.5.4+dfsg-4 (now, testing)]
 R    libreoffice                                                [1:3.5.4+dfsg-4 (now, testing)]
















 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Как вы можете видеть, объект списка, соответствующий удалению libreoffice
   в его текущей версии выделен красным и обозначен символом «R», означающим,
   что это действие отклонено. Решения, которые вы сгенерируете в будущем (то
   есть, всякое решение, которое вы ещё не просмотрели) не будет включать это
   действие, хотя уже сгенерированные решения, содержащие это действие, всё
   ещё будут доступны.

   [Primechanie] Примечание
                 На снимке экрана, приведенном выше, описание пакета
                 libreoffice отображается в середине окна; под ним вы можете
                 видеть зависимость, которая послужила причиной того, что
                 текущая версия пакета libreoffice будет удалена, вместе со
                 всеми другими способами разрешения этой зависимости, о
                 которых известно aptitude.

   Например, если бы этот отказ был установлен сразу же после попытки
   удаления libreoffice-base, нажатие клавиши . привело бы к обнаружению
   следующего решения и, соответственно, пропуску решений, которые бы удаляли
   пакет libreoffie.

   Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Resolve Dependencies
   --\ Сохранить для следующих пакетов их текущие версии:
     libreoffice-base                                      [1:3.5.4+dfsg-4 (now, testing)]

















 [2(2)/...] Предлагается выполнить 1 оставить неизменным
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Отказы применяются только к новым решениям; то есть, решениям, создаваемым
   при нажатии клавиши . во время просмотра последнего из созданных решений.
   Ранее созданные решения могут содержать действия, от которых вы
   отказались. Вы можете отменить отказ в любое время, выбрав действие,
   которому вы ранее отказали в выполнении, и нажав r; это снова разрешит
   создавать решения, содержащие данное действие, включая все решения,
   которые ранее были «пропущены».

   Противоположностью отказа от действия является его одобрение. Чтобы
   одобрить действие, выберите его и нажмите a; это заставит решатель проблем
   выбирать этой действие всегда, если это возможно^[3]. Одобренные действия
   будут окрашены зелёным цветом и будут обозначены символом «A», как на
   следующем снимке экрана:

   Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Resolve Dependencies
   --\ Сохранить для следующих пакетов их текущие версии:
 A    libreoffice-base                                      [1:3.5.4+dfsg-4 (now, testing)]

















 [2(2)/...] Предлагается выполнить 1 оставить неизменным
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   [Vazhno] Важно
            Если вы не разрешите какие-либо сломанные зависимости, aptitude
            автоматически выполнит своё текущее предложение когда вы
            зафиксируете свой выбор, нажав клавишу g. Тем не менее, довольно
            трудно разрешать проблемы с зависимостями автоматически, и вы
            можете быть не рады результатам, поэтому обычно хорошо бы
            просмотреть то, что aptitude планирует сделать до того, как
            зафиксировать свой выбор.

  Обновление списка пакетов и установка пакетов

   Теперь вы достаточно знаете об aptitude, чтобы на самом деле изменить
   что-то в вашей системе.

   Вам периодически следует обновлять список доступных пакетов с серверов
   Debian, чтобы отслеживать новые пакеты и новые версии пакетов. Для этого
   нажмите клавишу u. В любой момент загрузки, вы можете нажать клавишу q для
   отмены.

   Как только у вас есть свежий список пакетов, вы можете выбрать пакеты для
   обновления, установки, или удаления, как это описано в предыдущем разделе.
   Чтобы рассмотреть запрошенные вами действия, нажмите g один раз. При
   установке пакета kaffeine-mozilla (из предыдущего примера), появится
   следующее окно:

   Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1                  Будет использовано 2925kB дис  DL размер: 1375kB
 --\ Пакеты устанавливаются автоматически для удовлетворения зависимостей
 piA kaffeine                                        +2843kB <none>     0.4.3-1
 --\ Устанавливаемые пакеты
 pi  kaffeine-mozilla                                +81.9kB <none>     0.4.3-1







 Эти пакеты устанавливаются, так как они нужны другим пакетам, которые вы выбрали для установки

 При выборе пакета его текущее состояние появится
 здесь.





   Как вы можете видеть, aptitude автоматически решил установить kaffeine,
   так как пакет kaffeine-mozilla требует его наличия. Теперь следует выбрать
   либо продолжение установки путём нажатия клавиши g, либо её отмену
   нажатием q.

Использование aptitude из командной строки

   В дополнение к «графическому» интерфейсу, описанному в предыдущем разделе,
   aptitude может использоваться для управления пакетами напрямую из
   командной строки подобно тому, как вы использовали бы apt-get. Этот раздел
   охватывает наиболее частые действия aptitude, вызываемые из командной
   строки; дополнительную информацию, см. в справочнике по командной строке
   aptitude.

   В общем случае вызов aptitude из командной строки выглядит так:

   aptitude действие [аргументы...]

   действие говорит aptitude, какое действие следует предпринять; остальные
   аргументы используются в соответствии с конкретными опциями. Обычно они
   состоят из имен пакетов и переключателей командной строки^[4].

   Наиболее важными действиями являются следующие:

   aptitude update

           Эта команда обновляет список пактов как если бы вы вошли в
           графический интерфейс и нажали клавишу u.

   aptitude safe-upgrade

           Эта команда обновит наибольшее число пакетов, которые можно
           обновить не удаляя существующие пакеты.

           Иногда необходимо удалить один пакет для того, чтобы обновить
           другой; в таких ситуациях эта команда не может обновить пакеты.
           Используйте команду full-upgrade, чтобы обновить также и эти
           пакеты.

   aptitude full-upgrade

           Подобно команде safe-upgrade, эта команда попытается обновить
           пакеты, но она более агрессивна относительно разрешения проблем
           зависимостей: она будет устанавливать и удалять пакеты до тех пор
           пока все зависимости не будут удовлетворены. Возможно, она
           приведёт к нежелательным вещам, поэтому следует быть аккуратными
           при её использовании.

           [Primechanie] Примечание
                         По историческим причинам эта команда была изначально
                         названа dist-upgrade, и это имя все еще распознается
                         aptitude.

   aptitude [ install | remove | purge ] пакет1 [пакет2...]

           Эти команды устанавливают, удаляют или вычищают^[5] конкретные
           пакеты. «Установка» уже установленного пакета, который может быть
           обновлён, приведёт к его обновлению.

   aptitude search шаблон1 [шаблон2...]

           Эта команда ищет пакеты, чьи имена содержат любой данный шаблон, и
           выводит результат в терминал. В дополнение к простой строке
           текста, каждый шаблон может выступать поисковым шаблоном как это
           описано в разделе «Поисковые шаблоны». ^[6] Например, «aptitude
           search gnome kde» выведет список всех пакетов, чьи имена содержат
           «gnome» или «kde».

   aptitude show пакет1 [пакет2...]

           Выводит информацию о каждом указанном пакете в терминал.

   Все команды, которые устанавливают, обновляют и удаляют пакеты допускают
   параметр -s, который означает «симулирование». Когда параметр -s передан
   из командной строки, программа выполнит все действия, которые она обычно
   выполнила бы, но, в действительности, она не загрузит и не
   установит/удалит какие-либо файлы.

   Иногда aptitude будет давать подсказки подобные этой:

 Следующие НОВЫЕ пакеты будут автоматически установлены:
   space-orbit-common
 Следующие НОВЫЕ пакеты будут установлены:
   space-orbit space-orbit-common
 0 пакетов обновлено, 2 установлено новых, 0 пакетов отмечено для удаления, и 0 пакетов не обновлено.
 Необходимо получить 3200kB архивов. После распаковки 8413kB будет занято.
 Хотите продолжить? [Y/n/?]

   В дополнение к очевидным опциям «Да» и «Нет», доступен ряд команд, которые
   могут быть использованы для изменения отображаемой в подсказке информации
   или для определения дальнейших действий. Например, ввод s приведёт к
   отображению или скрытию информации о том, сколько места будет использовано
   каждым пакетом:

 Хотите продолжить? [Y/n/?] s

 Будет отображаться информация об изменении размеров.

 Следующие НОВЫЕ пакеты будут автоматически установлены:
   space-orbit-common <+8020kB>
 Следующие НОВЫЕ пакеты будут установлены:
   space-orbit <+393kB> space-orbit-common <+8020kB>
 0 пакетов обновлено, 2 установлено новых, 0 пакетов отмечено для удаления, и 0 пакетов не обновлено.
 Необходимо получить 3200kB архивов. После распаковки 8413kB будет занято.
 Хотите продолжить? [Y/n/?]

   Сходным образом ввод d приведёт к отображению информации об автоматически
   устанавливаемых или удаляемых пакетах:

 Следующие НОВЫЕ пакеты будут автоматически установлены:
   space-orbit-common (D: space-orbit)
 Следующие НОВЫЕ пакеты будут установлены:
   space-orbit space-orbit-common
 0 пакетов обновлено, 2 установлено новых, 0 пакетов отмечено для удаления, и 0 пакетов не обновлено.
 Необходимо получить 3200kB архивов. После распаковки 8413kB будет занято.

   Это показывает, что space-orbit-common будет установлен, так как
   space-orbit зависит от него. Вы можете увидеть весь список возможных
   опций, введя в приглашение ?.

   Если ваш запрос нарушает зависимости так, что эта проблема не может быть
   легко разрешена, aptitude спросит, что делать:

 Следующие пакеты НЕРАБОТОСПОСОБНЫ:
   libsdl1.2debian
 Следующие пакеты будут УДАЛЕНЫ:
   libsdl1.2debian-alsa
 .
 .
 .
 Следующие действия разрешат зависимости:

 Установить следующие пакеты:
 libsdl1.2debian-all [1.2.12-1 (unstable)]

 Счёт 41

 Принять данное решение? [Y/n/q/?]

   Ввод y (или простое нажатие клавиши Enter) приведёт к принятию
   предложенного решения. Ввод n отобразит «следующее наилучшее» решение:

 Принять данное решение? [Y/n/q/?] n
 Следующие действия разрешат зависимости:

 Установить следующие пакеты:
 libsdl1.2debian-esd [1.2.12-1 (unstable)]

 Счёт 19

 Принять данное решение? [Y/n/q/?]

   Как и в основном приглашении командной строки, из приглашения решателя
   зависимостей вы можете выполнить ряд дополнительных действий, включая
   изменение состояний пакетов вручную. Введите ?, чтобы увидеть полный
   список возможных действий.

   Ввод q приведёт к аварийному закрытию автоматического решателя и позволит
   вам разрешить зависимости вручную:

 Принять данное решение? [Y/n/q/?] q
 aptitude не удалось найти решение для этих зависимостей. Вы можете разрешить это вручную или нажмите 'n', чтобы выйти.
 Следующие пакеты имеют неудовлетворённые зависимости:
   libsdl1.2debian: Зависимости: libsdl1.2debian-alsa (= 1.2.12-1) но его невозможно установить или
                             libsdl1.2debian-all (= 1.2.12-1) но его невозможно установить или
                             libsdl1.2debian-esd (= 1.2.12-1) но его невозможно установить или
                             libsdl1.2debian-arts (= 1.2.12-1) но его невозможно установить или
                             libsdl1.2debian-oss (= 1.2.12-1) но его невозможно установить или
                             libsdl1.2debian-nas (= 1.2.12-1) но его невозможно установить или
                             libsdl1.2debian-pulseaudio (= 1.2.12-1) но его невозможно установить или
 Будете разбираться с зависимостями вручную? [N/+/-/_/:/?]

   Вы можете использовать любую команду управления пакетами для разрешения
   сломанных зависимостей (введите ?, чтобы увидеть полный список доступных
   команд). Введите n или нажмите Enter, чтобы выйти из aptitude:

 Будете разбираться с зависимостями вручную? [N/+/-/_/:/?] n
 Прервать.

   Полную документацию по возможностям командной строки aptitude, см. в
   Руководство по командной строке.

   --------------------------------------------------------------------------

   ^[2] Вы также можете изменять пакеты, используя меню Пакет; более
   подробную информацию см. в разделе «Меню Пакет».

   ^[3] Одобрение действия несколько отличается от требования ко всем
   решениям содержать данное действие; одобрение предполагает, что когда
   возникает выбор между одобренным и не одобренным действием, решатель
   всегда будет выбирать одобренное действие. Если имеется несколько
   возможных одобренных действий, все они будут кандидатами на помещение их в
   решение.

   ^[4] «Переключатель» — это буква, упреждённая дефисом: например, «-a»,
   «-v» и т. д.

   ^[5] Вычистка пакета удаляет пакет и его файлы настройки.

   ^[6] В действительности то же верно и относительно команд, которые
   принимают пакеты в качестве аргументов, таких как install или show.

                    Глава 2. Справочное руководство aptitude

   Содержание

   Терминальный пользовательский интерфейс aptitude

                Использование меню

                Меню команд

                Работа с несколькими окнами

                Становимся root

   Управление пакетами

                Управление списком пакетов

                Доступ к информации о пакете

                Изменение состояний пакета

                Загрузка, установка и удаление пакетов

                Понимание и управление надёжностью пакетов

                Управление пакетами, установленными автоматически

   Разрешение зависимостей пакетов

                Разрешение зависимостей в aptitude

                Непосредственное разрешение зависимостей

                Интерактивное разрешение зависимостей

                Стоимость в интерактивном решателе зависимостей

                Настройка интерактивного решателя зависимостей

   Поисковые шаблоны

                Поиск строк

                Сокращения для поисковых терминов

                Поиск и версии

                Явные цели поиска

                Руководство по поисковым терминам

   Настройка aptitude

                Настройка списка пакетов

                Настройка привязки клавиш

                Настройка цветов и стилей текста

                Настройка разметки экрана

                Руководство по файлу настроек

                Темы

   Играем в Сапёра

     Белый Кролик напялил на нос очки. "С чего начинать, Ваше Величество?"   
     — спросил он.

     "Начни с начала," — торжественно произнёс Король, — "и продолжай, пока
     не дойдёшь до конца. Тогда остановись!"
                                       -- Льюис Кэрролл, Алиса в стране чудес

   aptitude — огромная программа с множеством возможностей, и иногда трудно
   вспомнить, как сделать некоторую вещь, или даже вспомнить, возможно ли это
   вообще. Действительно, многие запросы возможностей, получаемые автором,
   описывают то, что уже присутствует в программе, но что трудно обнаружить.
   ^[7]

   В попытке побороть эту неизвестность данное руководство описывает все
   возможности и параметры настройки aptitude. Более краткое руководство
   важных возможностей aptitude, см. Глава 1, Приступая к работе.

   [Primechanie] Примечание
                 Поведение программы aptitude и её внешний вид могут быть
                 настроены несколькими способами. Настоящее руководство
                 описывает то, как работает эта программа с настройками
                 по-умолчанию; описание того, как различные настройки влияют
                 на поведение программы, дано в «Настройка aptitude».

Терминальный пользовательский интерфейс aptitude

   Этот раздел описывает части терминального пользовательского интерфейса
   aptitude, которые не имеют отношения к управлению пакетами.

  Использование меню

   Строка меню в верхней части экрана содержит наиболее важные команды
   aptitude. Для того, чтобы активировать строку меню, нажмите Control+t; вы
   можете перемещаться по меню, используя клавиши со стрелками, и выбирать
   пункт меню, используя Enter.

   Некоторые пункты меню также имеют привязку к «горячим клавишам»: буквы или
   цифры, которые могут быть использованы для выбора пункта меню в тот
   момент, когда меню активно. Эти горячие клавиши отображаются более светлым
   тоном, чем остальная часть меню.

   В дополнение некоторые пункты меню так же имеют привязку к «клавишам
   быстрого доступа»: сочетаниям клавиш, которые выполняют то же действие в
   тот момент, когда меню не активно. Эти сочетания клавиш приводятся в
   правой части меню.

   В дальнейшем команды меню будут обозначаться так: Меню → Пункт (клавиша).
   Это означает, что вам следует выбрать Пункт из Меню, и что клавиша
   является клавишей быстрого доступа для этой команды.

  Меню команд

    Меню Действия

   Рисунок 2.1. Команды, доступные в меню Действия

   +------------------------------------------------------------------------+
   |          Команда           |                 Описание                  |
   |----------------------------+-------------------------------------------|
   |                            | Если предварительный просмотр установки   |
   | Действия →                 | не отображается, то отобразить его; в     |
   | Установить/удалить пакеты  | противном случае, выполнить установочный  |
   | (g)                        | запуск как это описано в «Загрузка,       |
   |                            | установка и удаление пакетов».            |
   |----------------------------+-------------------------------------------|
   | Действия → Обновить список | Обновить список пакетов.                  |
   | пакетов (u)                |                                           |
   |----------------------------+-------------------------------------------|
   |                            | Отметить для обновления все пакеты,       |
   | Действия → Пометить        | которые можно обновить, за исключением    |
   | обновляемые (U)            | тех, которые были зафиксированы или       |
   |                            | запрещены для обновления.                 |
   |----------------------------+-------------------------------------------|
   | Действия → Забыть о новых  | Сбросить всю информацию о том, какие      |
   | пакетах (f)                | пакеты являются «новыми» (очистить дерево |
   |                            | «Новые пакеты»).                          |
   |----------------------------+-------------------------------------------|
   |                            | Отменить все незаконченные установки,     |
   | Действия → Отменить        | удаления, обновления и фиксации. Это      |
   | незаконченные действия     | эквивалентно выполнению команды Оставить  |
   |                            | для каждого пакета в базе данных пакетов. |
   |----------------------------+-------------------------------------------|
   | Действия → Очистить кэш    | Удалить все сжатые пакеты, которые были   |
   | пакетов                    | загружены aptitude ^[a].                  |
   |----------------------------+-------------------------------------------|
   |                            | Удалить все сжатые пакеты, которые были   |
   |                            | загружены aptitude ^[a] и более не        |
   | Действия → Очистить        | доступны в архивах. Предполагается, что   |
   | устаревшие файлы           | это устаревшие пакеты, и они могут быть   |
   |                            | удалены для освобождения места на диске,  |
   |                            | их загрузка в противном случае не         |
   |                            | потребуется.                              |
   |----------------------------+-------------------------------------------|
   | Действия → Играть в сапёра | Играть в Сапёра, это описано в «Играем в  |
   |                            | Сапёра».                                  |
   |----------------------------+-------------------------------------------|
   | Действия → Стать           | Продолжить работу от имени root; см.      |
   | суперпользователем         | «Становимся root».                        |
   |----------------------------+-------------------------------------------|
   | Действия → Выйти (Q)       | Выйти из aptitude, сохранив все изменения |
   |                            | состояний пакетов.                        |
   |------------------------------------------------------------------------|
   | ^[a] Или любая другая утилита apt.                                     |
   +------------------------------------------------------------------------+

    Меню Откат

   Рисунок 2.2. Команды, доступные в меню Откат

   +------------------------------------------------------------------------+
   |    Команда    |                        Описание                        |
   |---------------+--------------------------------------------------------|
   |               | Отменить последствия последнего изменения состояния    |
   | Откат → Откат | пакетов вплоть до времени последнего запуска aptitude, |
   | (Control+u)   | обновления списка пакетов или выполнения установочного |
   |               | запуска.                                               |
   +------------------------------------------------------------------------+

    Меню Пакет

   Рисунок 2.3. Команды, доступные в меню Пакет

   +------------------------------------------------------------------------+
   |         Команда         |                   Описание                   |
   |-------------------------+----------------------------------------------|
   | Пакет → Установить (+)  | Отметить выбранный в данный момент пакет для |
   |                         | установки.                                   |
   |-------------------------+----------------------------------------------|
   | Package → Reinstall (L) | Flag the currently selected package for      |
   |                         | reinstallation.                              |
   |-------------------------+----------------------------------------------|
   | Пакет → Удалить (-)     | Отметить выбранный в данный момент пакет для |
   |                         | удаления.                                    |
   |-------------------------+----------------------------------------------|
   | Пакет → Вычистить (_)   | Отметить выбранный в данный момент пакет для |
   |                         | вычистки.                                    |
   |-------------------------+----------------------------------------------|
   |                         | Отменить незаконченные установки, обновления |
   | Пакет → Оставить (:)    | или удаления выбранного в данный момент      |
   |                         | пакета, а также удалить фиксации,            |
   |                         | установленные на этом пакете.                |
   |-------------------------+----------------------------------------------|
   | Пакет → Фиксировать (=) | Зафиксировать выбранный в данный момент      |
   |                         | пакет.                                       |
   |-------------------------+----------------------------------------------|
   |                         | Пометить выбранный в данный момент пакет как |
   |                         | «установленный автоматически». Более         |
   | Пакет → Отметить Auto   | подробную информацию о пакетах,              |
   | (M)                     | установленных вручную или автоматически, см. |
   |                         | «Управление пакетами, установленными         |
   |                         | автоматически».                              |
   |-------------------------+----------------------------------------------|
   |                         | Пометить выбранный в данный момент пакет как |
   | Пакет → Отметить Manual | «установленный вручную» . Более подробную    |
   | (m)                     | информацию о пакетах, установленных вручную  |
   |                         | или автоматически, см. «Управление пакетами, |
   |                         | установленными автоматически».               |
   |-------------------------+----------------------------------------------|
   |                         | Если выбран пакет, который может быть        |
   | Пакет → Запретить       | обновлен, запретить его обновление до        |
   | версию (F)              | доступной в данный момент версии. Если       |
   |                         | выбрана версия пакета, запретить обновление  |
   |                         | этого пакета до этой версии.                 |
   |-------------------------+----------------------------------------------|
   |                         | Отобразить окно, содержащее информацию о     |
   | Пакет → Информация      | выбранном в данный момент пакете, т. е.      |
   | (enter)                 | информацию о том, от каких пакетов он        |
   |                         | зависит, какие пакеты зависят от него, а     |
   |                         | также доступные версии этого пакета.         |
   |-------------------------+----------------------------------------------|
   |                         | При просмотре списка пакетов эта команда     |
   |                         | переключает отображение информации в         |
   |                         | информационной области (нижняя половина      |
   |                         | экрана). Информационная область может        |
   | Пакет → Цикл информации | отображать длинное описание выбранного в     |
   | о пакете (i)            | данного момент пакета (поведение             |
   |                         | по-умолчанию), сводку зависимостей,          |
   |                         | связанных с этим пакетом, или анализ того,   |
   |                         | какие другие пакеты требуют или предлагают   |
   |                         | выбранный пакет.                             |
   |-------------------------+----------------------------------------------|
   |                         | Отобразить список изменений Debian           |
   | Пакет → История         | выбранного в данный момент пакета. Чтобы     |
   | изменений (C)           | посмотреть список изменений конкретной       |
   |                         | версии, выберите эту версию и выполните      |
   |                         | данную команду.                              |
   +------------------------------------------------------------------------+

    Меню Решатель

   Рисунок 2.4. Команды, доступные в меню Решатель

   +------------------------------------------------------------------------+
   |     Команда     |                       Описание                       |
   |-----------------+------------------------------------------------------|
   | Решатель →      | Отобразить детальное описание текущего предложения   |
   | Рассмотреть     | решателя проблем (см. «Интерактивное разрешение      |
   | решение (e)     | зависимостей»).                                      |
   |-----------------+------------------------------------------------------|
   | Решатель →      | Выполнить действия, предлагаемые решателем в данный  |
   | Применить       | момент.                                              |
   | решение (!)     |                                                      |
   |-----------------+------------------------------------------------------|
   | Решатель →      |                                                      |
   | Следующее       | Выбрать следующее предложение решателя проблем.      |
   | решение (.)     |                                                      |
   |-----------------+------------------------------------------------------|
   | Решатель →      |                                                      |
   | Предыдущее      | Выбрать предыдущее предложение решателя проблем.     |
   | решение (,)     |                                                      |
   |-----------------+------------------------------------------------------|
   | Решатель →      |                                                      |
   | Первое решение  | Выбрать первое предложение решателя проблем.         |
   | (<)             |                                                      |
   |-----------------+------------------------------------------------------|
   | Решатель →      | Выбрать последнее созданное решателем проблем        |
   | Последнее       | предложение (см. «Интерактивное разрешение           |
   | решение (>)     | зависимостей»).                                      |
   |-----------------+------------------------------------------------------|
   |                 | При просмотре решения, переключить отклонение        |
   | Решатель →      | выбранного в данный момент действия и перейти к      |
   | Переключить     | следующему действию (см. «Интерактивное разрешение   |
   | отказы (r)      | зависимостей»). Если в данный момент действие        |
   |                 | принято, его принятие будет отменено.                |
   |-----------------+------------------------------------------------------|
   |                 | При просмотре решения, переключить принятие          |
   | Решатель →      | выбранного в данный момент действия и перейти к      |
   | Переключить     | следующему действию (см. «Интерактивное разрешение   |
   | одобрение (a)   | зависимостей»). Если в данный момент действие        |
   |                 | отклонено, отклонение будет отменено.                |
   |-----------------+------------------------------------------------------|
   | Решатель →      | При просмотре решения, просмотреть детальную         |
   | Показать цель   | информацию о пакете, подверженном выбранному в       |
   | (Enter)         | данный момент действию (см. «Интерактивное           |
   |                 | разрешение зависимостей»).                           |
   |-----------------+------------------------------------------------------|
   |                 | Отклонить (как Решатель → Переключить отказы (r))    |
   |                 | все действия, которые сломали бы фиксацию пакета или |
   | Решатель → Не   | установили бы запрещенную к установке версию. Эти    |
   | ломать фиксации | действия отклоняются по-умолчанию, пока параметр     |
   |                 | Aptitude::ProblemResolver::Allow-Break-Holds не      |
   |                 | установлен в значение true, но этот пункт меню       |
   |                 | позволяет вам отклонить их вручную в любое время.    |
   +------------------------------------------------------------------------+

    Меню Поиск

   Рисунок 2.5. Команды, доступные в меню Поиск

   +------------------------------------------------------------------------+
   |           Команда            |                Описание                 |
   |------------------------------+-----------------------------------------|
   |                              | Найти следующий пакет в списке пакетов, |
   | Поиск → Поиск (/)            | соответствующий поисковому шаблону (см. |
   |                              | «Поисковые шаблоны»).                   |
   |------------------------------+-----------------------------------------|
   |                              | Найти предыдущий пакет в списке         |
   | Поиск → Поиск назад (\)      | пакетов, соответствующий поисковому     |
   |                              | шаблону (см. «Поисковые шаблоны»).      |
   |------------------------------+-----------------------------------------|
   | Поиск → Найти снова (n)      | Повторить последнюю команду поиска.     |
   |------------------------------+-----------------------------------------|
   |                              | Повторить последнюю команду поиска, но  |
   | Поиск → Выполнить обратный   | в обратном направлении. Если последняя  |
   | поиск снова (N)              | команда поиска была поиском назад, эта  |
   |                              | команда выполнит поиск вперед, и        |
   |                              | наоборот.                               |
   |------------------------------+-----------------------------------------|
   |                              | Отфильтровать текущий список пакетов,   |
   | Поиск → Ограничить экран (l) | удалив из него все пакеты, которые не   |
   |                              | соответствуют поисковому шаблону (см.   |
   |                              | «Поисковые шаблоны»).                   |
   |------------------------------+-----------------------------------------|
   | Поиск → Безразмерный экран   | Отменить фильтрацию текущего списка     |
   |                              | пакетов (будут показаны все пакеты).    |
   |------------------------------+-----------------------------------------|
   | Поиск → Найти                | Найти следующий сломанный пакет. Эта    |
   | неработоспособные (b)        | команда эквивалентна поиску ?broken.    |
   +------------------------------------------------------------------------+

    Меню Параметры

   Рисунок 2.6. Команды, доступные в меню Параметры

   +------------------------------------------------------------------------+
   |       Команда        |                    Описание                     |
   |----------------------+-------------------------------------------------|
   |                      | Открыть новое окно верхнего уровня, в котором   |
   |                      | вы можете изменять параметры aptitude. Опции    |
   | Параметры →          | настройки отображаются в дереве схожем с        |
   | Предпочтения         | деревом пакетов; чтобы включить или отключить   |
   |                      | опцию, выберите её и нажмите Пробел или Enter.  |
   |                      | Опции настройки сохраняются в файл              |
   |                      | ~/.aptitude/config тотчас при их изменении.     |
   |----------------------+-------------------------------------------------|
   | Параметры → Отменить | Сбросить все опции к их значениям по-умолчанию. |
   | настройки            |                                                 |
   +------------------------------------------------------------------------+

    Меню Окна

   [Primechanie] Примечание
                 Обзор того, как работают окна, см. в разделе «Работа с
                 несколькими окнами».

   Рисунок 2.7. Команды, доступные в меню Окна

   +------------------------------------------------------------------------+
   |           Команда           |                 Описание                 |
   |-----------------------------+------------------------------------------|
   | Окна → Следующее (F6)       | Переключиться к следующему активному     |
   |                             | окну.                                    |
   |-----------------------------+------------------------------------------|
   | Окна → Предыдущее (F7)      | Переключиться к предыдущему активному    |
   |                             | окну.                                    |
   |-----------------------------+------------------------------------------|
   | Окна → Закрыть (q)          | Закрыть текущее окно.                    |
   |-----------------------------+------------------------------------------|
   | Окна → Новое окно Пакета    | Создать новое окно со списком пакетов.   |
   |-----------------------------+------------------------------------------|
   |                             | Создать окно, отображающее пакеты,       |
   | Окна → Проверка             | которые еще не установлены и которые     |
   | рекомендаций                | Рекомендуются уже установленными в вашей |
   |                             | системе пакетами.                        |
   |-----------------------------+------------------------------------------|
   | Окна → Новый плоский список | Создать новое окно со списком пакетов, в |
   | пакетов                     | котором пакеты не распределены по        |
   |                             | категориям.                              |
   |-----------------------------+------------------------------------------|
   |                             | Создать новое окно со списком пакетов, в |
   | Окна → Новый Debtags        | котором пакеты распределены по           |
   | браузер                     | категориям соответственно их значениям   |
   |                             | debtags.                                 |
   |-----------------------------+------------------------------------------|
   | Окна → Новый браузер        | Просмотреть список пакетов,              |
   | категорий                   | упорядоченный по категориям.             |
   |-----------------------------+------------------------------------------|
   |                             | Появляется ряд дополнительных пунктов    |
   |                             | меню; они соответствуют активным в       |
   | Дополнительные меню         | настоящее время окнам. Чтобы             |
   |                             | переключиться на окно, выберите его из   |
   |                             | меню.                                    |
   +------------------------------------------------------------------------+

    Меню Справка

   Рисунок 2.8. Команды, доступные в меню Справка

   +------------------------------------------------------------------------+
   |        Команда        |                    Описание                    |
   |-----------------------+------------------------------------------------|
   | Справка → О программе | Отобразить информацию об авторском праве.      |
   |-----------------------+------------------------------------------------|
   | Справка → Справка (?) | Отобразить интерактивную справку.              |
   |-----------------------+------------------------------------------------|
   | Справка → Руководство | Отобразить руководство пользователя (этот      |
   | пользователя          | документ).                                     |
   |-----------------------+------------------------------------------------|
   | Помощь → ЧАВО         | Отобразить aptitude ЧАВО.                      |
   |-----------------------+------------------------------------------------|
   | Помощь → Новости      | Отобразить историю изменений aptitude.         |
   |-----------------------+------------------------------------------------|
   |                       | Отобразить условия, по которым вы можете       |
   | Помощь → Лицензия     | копировать, изменять и распространять          |
   |                       | aptitude.                                      |
   +------------------------------------------------------------------------+

  Работа с несколькими окнами

   aptitude позволяет вам работать с несколькими «окнами» одновременно.
   «Окно» (иногда оно называется «экран») является тем, что может появляться
   в области экрана ниже строки меню. Наиболее часто используемым окном
   является список пакетов, но окно загрузки так же встречается довольно
   часто.

   Когда одновременно открыты несколько окон, вверху экрана появляется строка
   со списком всех активных окон. Например, если я выберу apt, нажав Enter,
   затем выберу libc6, экран будет выглядеть как-то так:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
          Пакеты                  apt info                  libc6 info
 aptitude 0.3.1
 i A  --\ libc6                                             2.3.2.ds1- 2.3.2.ds1-
   Description: GNU C Library: Динамические библиотеки и данные Timezone
     Содержит стандартные библиотеки, которые используются всеми программами системы.
     Данный пакет содержит динамические версии стандартной библиотеки C и
     стандартной математической библиотеки, а также множество других библиотек. Данные Timezone также
     включены в пакет.
   Приоритет: необходимый
   Раздел: base
   Сопровождающий: GNU Libc Maintainers <debian-glibc@lists.debian.org>
   Размер в сжатом виде: 4901k
   Размер в распакованном виде: 15.9M
   Исходный текст: glibc
   --\ Зависит
     --- libdb1-compat
   --\ Предлагает
     --- locales
     --- glibc-doc
   --\ Конфликтует
 GNU C Library: Динамические библиотеки и данные Timezone

   Вы можете закрыть текущее окно, используя команду Окна → Закрыть (q).
   Чтобы переключиться на следующее или предыдущее окно, используйте Окна →
   Следующее (F6) и Окна → Предыдущее (F7), или кликните на названии окна
   вверху экрана; также в меню Окна вы можете найти список всех активных
   окон.

   Как показано выше, некоторые команды (например, просмотр информации о
   пакете) автоматически создают новые окна; также вы сами можете создать
   новое окно, используя команды Окна → Новое окно Пакета или Окна → Новый
   браузер категорий.

  Становимся root

   Некоторые действия, такие как обновление списка пакетов, могут быть
   выполнены только от имени root. Если вы, не являясь root, попытаетесь
   выполнить обновление списка пакетов, aptitude спросит вас о том, хотите ли
   вы стать root:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 --- Установленные пакеты
 --- Неустановленные пакеты
 --- Устаревшие и пакеты, созданные локально
 --- Виртуальные пакеты
 --- Задачи

   +-------------------------------------------------------------------------+
   |Для обновления списка пакетов требуются административные права, которыми вы     |
   |в данный момент не обладаете. Получить права суперпользователя?|
   |                                                                         |
   |         [ Стать суперпользователем ]                  [ Не становиться суперпользователем ]          |
 Th+-----------------------------------------------------------------------+









   Если вы выберите «Стать суперпользователем», aptitude попросит вас ввести
   пароль root; если вы правильно введёте его, aptitude выполнит действие,
   которому требовались привилегии root. После завершения этого действия вы
   останетесь root.

   Вы можете переключиться на учётную запись root в любое время, используя
   команду Действия → Стать суперпользователем. Все изменения состояний
   пакетов останутся (но они не будут сохранены до тех пор, пока вы не
   выйдите из aptitude).

   По-умолчанию aptitude использует команду su для приобретения привилегий
   root. Если вы хотели бы использовать другую команду (такую как sudo),
   установите опцию настройки Aptitude::Get-Root-Command.

Управление пакетами

   Этот раздел описывает то, как управлять списком пакетов, как установить
   новые пакеты в вашу систему и как удалить старые пакеты.

  Управление списком пакетов

   Для того, чтобы поддерживать список пакетов в актуальном состоянии,
   рекомендуется периодически обновлять его. Вы можете сделать это, используя
   команду Действия → Обновить список пакетов (u).

  Доступ к информации о пакете

   Информация о пакетах представлена в aptitude в нескольких местах: список
   пакетов даёт быстрый обзор состояния каждого пакета, а также доступны
   дополнительные окна, предоставляющие подробную информацию о пакете.

    Список пакетов

   Список пакетов отображает «краткий» обзор состояния пакета. Например,
   информация о пакете webmin может иметь следующий вид:

 piAU  webmin                                        +5837kB <none>     1.160-2

   Четыре символа с левой стороны этого обзора статуса показывают, что пакет
   не установлен («p»), что он будет установлен («i»), что он был
   автоматически выбран для установки («A»), и что он ненадёжен («U»). С
   правой стороны этого обзора отображаются текущая версия и наиболее свежая
   доступная версия, а также то, какое количество места будет использовано
   при обновлении.

   [Podskazka] Подсказка
               Вы можете настроить отображение обзора статуса, подробности
               см. в разделе «Настройка того, как отображаются пакеты».

   Четыре флага статуса с левой стороны экрана дают базовую информацию о
   состоянии пакета. Первый символ соответствует текущему состоянию пакета.
   Второй символ соответствует действию, которое будет произведено над
   пакетом. Третий символ обозначает, был ли пакет установлен автоматически
   (см. «Управление пакетами, установленными автоматически»), а четвёртый
   символ обозначает, является ли пакет надёжным (см. «Понимание и управление
   надёжностью пакетов»).

   Возможные значения флага «текущее состояние» даны в Рисунок 2.9, «Значения
   флага «текущее состояние»», а возможные значения флага «действие» даны в
   Рисунок 2.10, «Значения флага «действие»».

   Рисунок 2.9. Значения флага «текущее состояние»

   i - пакет установлен и все его зависимости удовлетворены.
   c - пакет был удалён, но его файлы настройки все ещё присутствуют.
   p - пакет и все его файлы настройки были удалены, или пакет никогда не был
       установлен.
   v - пакет является виртуальным.
   B - пакет имеет сломанные зависимости.
   u - пакет был распакован, но не настроен.
   C - наполовину настроенный пакет: настройка пакета была прервана.
   H - наполовину установленный пакет: установка пакета была прервана.

   Рисунок 2.10. Значения флага «действие»

   i - пакет будет установлен.
   u - пакет будет обновлён.
   d - пакет будет удалён; он будет удалён, но его файлы настройки останутся
       в системе.
   p - пакет будет вычищен; он и его файлы настройки будут удалены.
       пакет будет зафиксирован; он будет сохранен в текущей версии, даже
   h - если будет доступна более новая версия, до тех пор, пока фиксация не
       будет отменена.
   F - обновление пакета было запрещено.
   r - пакет будет переустановлен.
       пакет «сломан»; некоторые из его зависимостей не удовлетворены.
   B - aptitude не даст вам установить, удалить или обновить что-либо, пока у
       вас имеются сломанные пакеты.

   В дополнение aptitude использует цвета для обозначения состояния пакета,
   если это поддерживается вашим терминалом. Различия в состоянии
   отображаются главным образом при помощи цвета фона:

   Чёрный

           Пакет не может быть обновлён (или не будет установлен), и у него
           нет проблем с зависимостями. Если пакет установлен, его имя будет
           подсвечено.

   Зелёный

           Пакет будет установлен.

   Синий

           Пакет установлен и будет обновлён.

   Пурпурный

           Пакет установлен, но будет удалён.

   Белый

           Пакет установлен и «зафиксирован» в текущей версии; он будет
           игнорироваться при автоматическом обновлении .

   Красный

           Этот пакет сломан; некоторые из его зависимостей не удовлетворены.

   Наконец, в нижней половине окна отображается расширенное описание.
   aptitude попытается определить участвует ли данный пакет в проблеме
   зависимостей; если он участвует в таковой, то здесь будет отображена
   информация о проблеме зависимостей. Чтобы переключиться между информацией
   о зависимостях и описанием пакета, нажмите i.

    Подробная информация о пакете

   Нажатие Enter в тот момент, когда некоторый пакет подсвечен, приведёт к
   отображению окна информации о пакете:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.2.14.1
 i A --\ apt                                                0.5.25     0.5.25
   Описание: Продвинутый интерфейс для dpkg
     Это Debian интерфейс нового поколения для пакетного менеджера dpkg. Он
     предоставляет утилиту apt-get utility и метод APT для dselect, обеспечивающий более простой
     и безопасный способ установки и обновления пакетов.

     APT обладает рядом уникальный возможностей, таких как установка пакетов в нужном порядке и использование нескольких источников-хранилищ для установки
     и обновления. Более полная информация о возможностях APT доступны в руководстве пользователя в пакете apt-doc.
   Пакеты первой необходимости: да
   Приоритет: важный
   Раздел: base
   Сопровождающий: APT Development Team <deity@lists.debian.org>
   Размер в сжатом виде: 970k
   Размер в распакованном виде: 2961k
   Исходный пакет: apt
   --\ Зависит
     --- libc6 (>= 2.3.2.ds1-4)
     --- libgcc1 (>= 1:3.3.3-1)
     --- libstdc++5 (>= 1:3.3.3-1)
   --\ Предлагает
     --- aptitude | synaptic | gnome-apt | wajig
     --- dpkg-dev
     --\ apt-doc (НЕУДОВЛЕТВОРИТЕЛЬНЫЙ)
 p     0.6.25
 p     0.5.25
   --\ Заменяет
     --- libapt-pkg-doc (< 0.3.7)
     --- libapt-pkg-dev (< 0.3.7)
   --- Названия пакетов, предоставленные apt
   --- Пакеты, которые зависят от apt
   --\ Версии
 p A 0.6.25
 i A 0.5.25


   По этому окну можно перемещаться также как по списку пакетов: например, на
   снимке экрана выше я раскрыл зависимость от apt-doc, демонстрирующую
   доступные версии пакета apt-doc, которые удовлетворят зависимость. Этими
   версиями можно управлять также как пакетами: например, чтобы установить
   версию 0.5.25 пакета apt-doc, вам следует выбрать её и нажать +.

   [Podskazka] Подсказка
               Чтобы быстро удовлетворить зависимость, выберите её и нажмите
               +; aptitude попытается автоматически удовлетворить её.

   В дополнение к зависимостям пакета, вы можете просмотреть имена пакетов,
   Предоставляемых этим пакетом, пакеты, зависящие от данного пакета, а также
   доступные версии пакета (включая все другие пакеты, которые Предоставляют
   его).

   Как обычно, вы можете закрыть это окно и вернуться к основному окну, нажав
   q. Для удобства доступны несколько других информационных окон (которые
   лишь отображают некоторую обычно используемую информацию, скрывая все
   остальное): нажмите v, чтобы просмотреть версии пакета, d, чтобы
   просмотреть зависимости пакета и r, чтобы просмотреть «обратные
   зависимости» пакета (пакеты, зависящие от данного пакета).

  Изменение состояний пакета

   Доступны следующие команды для изменения состояния пакетов. Команды
   вступят в силу, когда вы выполните установочный запуск; пока вы не
   сделаете этого, все команды могут быть отменены при помощи Откат → Откат
   (Control+u).

   Чтобы применить команду к пакету, просто выберите пакет в списке пакетов и
   исполните команду. Эти команды могут также применяться к группам пакетов;
   выберите групповой заголовок (например, «Обновляемые пакеты») и исполните
   команду.

   +------------------------------------------------------------------------+
   |          Команда          |                  Описание                  |
   |---------------------------+--------------------------------------------|
   |                           | Отметить текущий пакет для установки.      |
   |                           |                                            |
   |                           | Если пакет не установлен, он будет         |
   | Установка: Пакет →        | установлен. Если он уже установлен, он     |
   | Установить (+)            | будет обновлён, если это возможно, а любой |
   |                           | запрет на обновления, имеющий воздействие  |
   |                           | на пакет (например, Фиксация), будет       |
   |                           | отменен.                                   |
   |---------------------------+--------------------------------------------|
   | Удаление: Пакет → Удалить | Отметить текущий пакет для удаления.       |
   | (-)                       |                                            |
   |                           | Если пакет установлен, он будет удалён.    |
   |---------------------------+--------------------------------------------|
   |                           | Отметить текущий пакет для вычистки.       |
   |                           |                                            |
   | Вычистка: Пакет →         | Если пакет установлен, он будет удалён.    |
   | Вычистить (_)             | Более того, даже если он удалён, все       |
   |                           | оставшиеся файлы (такие как файлы          |
   |                           | настройки), связанные с пакетом, будут     |
   |                           | удалены из системы.                        |
   |---------------------------+--------------------------------------------|
   |                           | Отметить текущий пакет как оставляемый в   |
   |                           | его текущей версии.                        |
   |                           |                                            |
   | Оставить: Пакет →         | Всякое действие, которое должно было быть  |
   | Оставить (:)              | произведено над пакетом: установка,        |
   |                           | удаление или обновление — отменяется, а    |
   |                           | любая постоянная фиксация, которая была    |
   |                           | установлена на пакет, удаляется.           |
   |---------------------------+--------------------------------------------|
   |                           | Установить постоянную фиксацию пакета.     |
   |                           |                                            |
   |                           | Как и в случае команды Оставить, любое     |
   | Фиксировать: Пакет →      | действие, которое должно было быть         |
   | Фиксировать (=)           | произведено над пакетом отменяется. В      |
   |                           | дополнение, пакет не будет автоматически   |
   |                           | обновлён ^[a] до тех пор, пока не будет    |
   |                           | отменена фиксация. Вы можете отменить      |
   |                           | фиксацию, исполнив команду Установка.      |
   |---------------------------+--------------------------------------------|
   |                           | Пакет не будет автоматически обновлён^[a]  |
   |                           | до той версии, до которой он был бы        |
   |                           | обновлён в данный момент. Если он должен   |
   |                           | был быть обновлён, его обновление будет    |
   |                           | отменено.                                  |
   |                           |                                            |
   |                           | Если вы исполняете эту команду на          |
   | Пакет → Запретить версию  | отдельной версии пакета, пакет не будет    |
   | (F)                       | обновлён до выбранной версии. Заметьте,    |
   |                           | что за раз может быть запрещена только     |
   |                           | одна версия.                               |
   |                           |                                            |
   |                           | Эта функциональность в значительной        |
   |                           | степени обеспечивается для удобства        |
   |                           | пользователей «нестабильного»              |
   |                           | дистрибутива, так они могут избежать       |
   |                           | установки неудачных версий пакетов.        |
   |---------------------------+--------------------------------------------|
   |                           | Flag the current package for               |
   |                           | reinstallation.                            |
   |                           |                                            |
   |                           | Заметьте, что переустановка не будет       |
   | Reinstall: Package →      | сохранена по техническим причинам, если вы |
   | Reinstall (L)             | выйдите из aptitude или выполните          |
   |                           | установочный запуск (в сущности,           |
   |                           | подлежащие программные слои (dpkg и apt)   |
   |                           | не позволяют узнать то, была переустановка |
   |                           | успешной или же нет).                      |
   |---------------------------+--------------------------------------------|
   |                           | Устанавливает, следует ли придавать пакету |
   |                           | статус автоматически установленного;       |
   | Пакет → Отметить Auto     | автоматически установленные пакеты будут   |
   | (M), Пакет → Отметить     | удалены, если они не требуются ни одному   |
   | Manual (m)                | другому пакету. Дополнительную информацию  |
   |                           | см. в разделе «Управление пакетами,        |
   |                           | установленными автоматически».             |
   |------------------------------------------------------------------------|
   | ^[a] То есть, он не будет подвержен Действия → Пометить обновляемые    |
   | (U) или таким действиям командной строки как full-upgrade или          |
   | safe-upgrade .                                                         |
   +------------------------------------------------------------------------+

   В дополнение к этим командам, которые оказывают воздействие на выбранный
   пакет, имеются две команды, которые воздействуют на большое число пакетов
   одновременно и в не зависимости от того, что выбрано. Действия → Забыть о
   новых пакетах (f) очищает «новый» статус всех пакетов в списке пакетов, а
   Действия → Пометить обновляемые (U) отмечает все пакеты, которые могут
   быть обновлены, для обновления за исключением зафиксированных пакетов или
   пакетов, которые были бы обновлены до запрещённых версий.

   [Primechanie] Примечание
                 Все изменения состояния пакетов сохраняются, когда вы
                 выходите из aptitude, обновляете список пакетов или
                 выполняете установочный запуск. Если вы не желаете сохранять
                 ваши изменения, вы всегда можете прервать работу aptitude,
                 нажав Ctrl-C.

  Загрузка, установка и удаление пакетов

   Изменение состояний пакетов, как это описано в предыдущем разделе, в
   действительности не влияет на то, что установлено в вашей системе. Таким
   образом, вы можете корректировать состояния пакетов без влияния на вашу
   систему до тех пор, пока вы не будете удовлетворены тем, что видите; как
   только вы будете удовлетворены, вы можете действительно «внести»
   изменения, фактически установив или удалив пакеты.^[8]

   Чтобы внести ваши изменения, используйте команду Действия →
   Установить/удалить пакеты (g). Выбор этой команды приведёт к отображению
   окна предпросмотра, описывающего изменения, которые будут выполнены. Это
   окно является простым списком пакетов, и вы можете манипулировать пакетами
   (например, отменяя нежелательные удаления) так же как вы делаете это в
   основном списке.

   Когда вы закончите работу с предварительным просмотром изменения,
   используйте команду Окна → Закрыть (q), чтобы отменить установку, либо
   используйте команду Действия → Установить/удалить пакеты (g) для
   продолжения. aptitude загрузит все файлы, которые следует загрузить и
   пригласит вас продолжить установку. Когда вы выберите «Продолжить»,
   начнутся установки и удаления.

   Пакеты, загруженные aptitude помещаются в каталог кэша (по-умолчанию в
   /var/cache/apt/archives). Обычно они бесконечно хранятся в каталоге. Чтобы
   удалить все файлы в этом каталоге, используйте Действия → Очистить кэш
   пакетов; чтобы удалить только те файлы, которые не могут быть загружены
   снова (то есть, устаревшие пакеты), используйте Действия → Очистить
   устаревшие файлы.

  Понимание и управление надёжностью пакетов

   Способность apt получить доступ к многим источникам пакетов ведёт к
   потенциальным уязвимостям в безопасности. Допустим вы добавили архив
   пакетов, опубликованных каким-то хакером Джо, в ваш файл sources.list,
   чтобы установить пакет gargleblast. Возможно, тем не менее, что — без
   вашего ведома — архив Джо содержит также его собственные «переделанные»
   версии таких пакетов как libc6 и ssh... версии, которые крадут вашу личную
   информацию или открывают бэкдоры на вашей системе! Если эти пакеты имеют
   более высокий номер версии, чем настоящие пакеты дистрибутива Debian, apt
   с радостью установит их на вашу систему во время следующего обновления,
   позволяя Джо без шума сделать свою грязную работу. Этот Джо также мог бы
   вломиться на ваше зеркало архивов Debian и заменить настоящее программное
   обеспечение его поддельной версией.

   К счастью, новые версии apt и aptitude, такие как версия, описываемая в
   настоящем руководстве, имеют встроенную защиту, чтобы помочь победить
   такой тип атаки. apt использует сильные механизмы безопасности, основанные
   на популярной программе для шифрования GPG, для проверки того, что пакеты,
   поставляемые с официального зеркала Debian, являются теми же пакетами, что
   и те, что были загружены на сервер разработчиками Debian. aptitude
   предупредит вас, если вы попытаетесь установить пакет из источника,
   отличного от Debian, или если вы попытаетесь обновить пакет, которые был
   установлен из официального источника до той версии, которая получена не из
   официального источника.

   [Preduprezhdenie] Предупреждение
                     Механизмы безопасности в apt обеспечивают почти
                     безупречную гарантию того, что содержание вашего зеркала
                     архива идентично содержанию главного архива Debian. Тем
                     не менее, они не являются панацеей: например, существует
                     множество способов того, как подделанный пакет мог бы
                     теоретически попасть в главный архив Debian.

                     Удостоверение того, что вы устанавливаете программное
                     обеспечение только из надёжного источника, даст вам
                     важный уровень защиты от злонамеренных пакетов, но не
                     может исключить все риски присущие установке программ.

    Понимаем надёжности

   apt позволяет администратору архива предоставлять подпись индекса архива.
   Эта подпись, которая (для всех практических целей) не может быть
   фальшивой, означает, что файлы пакетов, указанные в индексе, являются теми
   же самыми файлами, которые администратор был намерен поместить в архив: то
   есть, что содержание архива не было подделано с тех пор как оно было
   создано.^[9] Подпись может быть подтверждена проверкой на её соответствие
   публичному ключу администратора. Публичный ключ архива Debian поставляется
   вместе с apt, обычно на компакт-диске Debian.

   Когда aptitude загружает индекс архива, он проверяет, правильно ли
   подписан индекс. Если он не подписан, aptitude не будет доверять файлам
   пакетов из из этого архива. (См. информацию ниже о том, что это означает.)
   Если у индекса имеется подпись, но она неверна или не может быть
   подтверждена будет выведено предупреждение, и aptitude будет отказываться
   доверять пакетам из этого архива.

   Позже, когда вы выполните установочный запуск, aptitude проверит,
   относятся ли пакеты к надёжным источникам. Если ненадёжный пакет должен
   быть установлен, или пакет должен быть обновлён с надёжной до ненадёжной
   версии, будет отображено предупреждение, и у вас будет возможность
   прервать загрузку:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.3.0                    Будет использовано 831kB дис   DL размер: 30.4MB
 --\ Обновляемые пакеты
 iu U wesnoth                                       -98.3kB 0.8.7-1    0.8.8-1.0w
 iuAU wesnoth-data                                  +930kB  0.8.7-1    0.8.8-1.0w
 +------------------------------------------------------------------------------+
 |ПРЕДУПРЕЖДЕНИЕ: будут установлены версии ненадёжных пакетов!     #|
 |                                                                             #|
 |Ненадёжные пакеты могут скомпрометировать безопасность системы. #|
 |Продолжайте установку, если только вам точно это нужно.  #|
 |                                                                       #|
 |                                                                             #|
 |  * wesnoth [версия 0.8.8-1.0wesnoth.org]                                   #|
 |  * wesnoth-data [версия 0.8.8-1.0wesnoth.org]                              #|
 |  * wesnoth-music [версия 0.8.8-1.0wesnoth.org]                             #|
 |         [ На самом деле продолжить ]                  [ Прервать установку ]          |
 +------------------------------------------------------------------------------+
                                                                                #
                                                                                #
                                                                                #
                                                                                #
                                                                                #
                                                                                #

    Доверие дополнительным ключам

   Вам может показаться удобным позволить apt доверять дополнительным архивам
   помимо основного архива Debian. Для каждого архива, которому вы желаете
   доверять, вы должны будете получить публичный ключ, который используется
   для подписи индекса архива пакетов. Это обычно текстовый файл, имя
   которого заканчивается .asc; он может быть передан вам администратором
   сайта или загружен с публичного сервера ключей. Дополнительную информацию
   о том, что такое публичные ключи и как их получить, см. веб страницу GPG.

   Список ключей, которым доверяет apt, хранится в файле-брелоке
   /etc/apt/trusted.gpg. Как только у вас появился ключ GPG, вы можете
   добавить его к этому файлу, выполнив команду gpg --no-default-keyring
   --keyring /etc/apt/trusted.gpg --import newkey.asc. aptitude после этого
   будет доверять любому архиву, подписанному ключом, содержащимся в
   newkey.asc.

   [Preduprezhdenie] Предупреждение
                     Как только ключ архива добавлен к брелоку APT, этот
                     архив будет рассматриваться как такой же надёжный как
                     основные зеркала Debian! Вам следует делать это только в
                     том случае, когда вы совершенно уверены в том, что ключ,
                     добавляемый вами, верен, и что тот человек, который
                     владеет этим ключом, заслуживает доверия и достаточно
                     компетентен.

  Управление пакетами, установленными автоматически

   Чтобы установить один пакет, часто бывает необходимо установить несколько
   других (чтобы удовлетворить зависимости). Например, если вы хотите
   установить пакет clanbomber, вы должны также установить пакет libclanlib2.
   Если вы удалите clanbomber, вам, вероятно, больше не потребуется пакет
   libclanlib2; aptitude попытается обнаружить это и автоматически удалить
   пакет libclanlib2.

   Это работает так: когда вы устанавливаете пакет, aptitude автоматически
   устанавливает все другие пакеты, от которых зависит ваш пакет. Эти пакеты
   отмечаются как «установленные автоматически»; aptitude будет отслеживать
   их и удалит их, когда от них больше не будут зависеть установленные
   вручную пакеты^[10]. Они будут отображаться в предварительном просмотре
   как «пакеты, удаляемые по причине того, что они больше не используются.»

   Как и в любом другом автоматическом процессе, имеется возможность того,
   что что-то пойдёт не так. Например, даже если пакет был автоматически
   установлен, он может оказаться полезным сам по себе. Вы можете отменить
   флаг «автоматический» в любое время, нажав m; если пакет уже должен быть
   удалён, вы можете использоваться Пакет → Установить (+) чтобы отменить
   удаление и очистить флаг «автоматический».

Разрешение зависимостей пакетов

  Разрешение зависимостей в aptitude

   В aptitude имеются два основных алгоритма разрешения зависимостей.

   Первый — алгоритм, используемый также в таких программах как apt-get и
   synaptic; я буду называть его «непосредственное разрешение». Он
   используется всякий раз, когда вы в интерактивном режиме выбираете пакет
   для установки, и непосредственно после того, как один или большее
   количество пакетов отмечаются для установки в командной строке.
   Непосредственное разрешение довольно быстро, и оно разрешает большую часть
   проблем зависимостей, но иногда этот алгоритм не способен найти какое-либо
   решение.

   Второй алгоритм, который я буду называть «интерактивным разрешением»,
   используется, когда пакеты обладают сломанными зависимостями даже после
   непосредственного разрешения^[11]. Этот алгоритм может разрешить большее
   количество зависимостей, он даёт вам возможность предварительного
   просмотра решения до его применения, и он предоставляет вам обратную связь
   с решателем для направления его к более хорошему решению.

  Непосредственное разрешение зависимостей

   Всякий раз когда вы выбираете установку или обновление пакета в aptitude,
   aptitude сразу же предпринимает попытку разрешения всех неудовлетворённых
   зависимостей. Для каждой неудовлетворённой зависимости («Зависит»,
   «Рекомендует», или «Конфликтует»), он выполняет следующие шаги:

    1. Если зависимость является рекомендацией, aptitude пытается определить,
       является она «новой» рекомендацией, или «ранее удовлетворённой»
       рекомендацией. aptitude рассматривает рекомендацию в качестве «новой»,
       если пакет, объявляющий эту рекомендацию, в настоящее время не
       установлен, или если установленная версия данного пакета не
       рекомендует пакет с тем же именем. С другой стороны, рекомендация
       является «ранее удовлетворённой», если пакет, объявляющий эту
       рекомендацию, установлен, установленная в настоящее время версия этого
       пакета рекомендует пакет с тем же именем, и эта рекомендация в
       настоящее время удовлетворена.

       Например: допустим, что версия 1.0 пакета prog рекомендует версию 4.0
       пакета libcool1, но версия 2.0 пакета prog рекомендует версию 5.0
       пакета libcool1, а также рекомендует пакет apache. Если вы выберите
       обновление пакета prog с версии 1.0 до версии 2.0, рекомендация пакета
       apache будет рассматриваться в качестве «новой», поскольку версия 1.0
       пакета prog не рекомендовала пакет apache. С другой стороны,
       рекомендация пакета libcool1 не является «новой», так как версия 1.0
       пакета prog рекомендовала пакет libcool1, даже несмотря на то, что она
       рекомендовала другую версию. Тем не менее, если пакет libcool1
       установлен, эта рекомендация будет рассматриваться в качестве «ранее
       удовлетворённой».

       Если параметр настройки Apt::Install-Recommends имеет значение true,
       то aptitude всегда будет пытаться удовлетворить «новые» и «ранее
       удовлетворённые» рекомендации; все остальные будут игнорироваться
       непосредственным решением. Если этот параметр имеет значение false,
       все рекомендации будут игнорироваться алгоритмом непосредственного
       разрешения зависимостей.

    2. Если зависимость от нескольких пакетов составлена с применением ИЛИ,
       рассматривается каждая альтернатива в том порядке, в каком они даны.
       Например, если пакет зависит от «exim | mail-transport-agent»,
       aptitude в первую очередь рассмотрит пакет exim, а затем
       mail-transport-agent.

    3. Попытаться разрешить зависимость для каждой альтернативы. Если
       зависимость является конфликтом, удалить текущую альтернативу, если
       она установлена (и для конфликта без версии, также удалить всякий
       пакет, предоставляющий цель конфликта). В противном случае, установить
       версию-кандидат текущей альтернативы, если она разрешает зависимость.
       Если же нет, или если нет версии-кандидата (например потому, что
       текущая альтернатива является виртуальным пакетом), и если зависимость
       указана без версии, то попытаться установить пакет с наивысшим
       приоритетом^[12], чья версия-кандидат предоставляет цель текущей
       альтернативы.

       Например, мы пытаемся разрешить зависимость «Зависит: exim |
       mail-transport-agent». aptitude в первую очередь попытается установить
       пакет exim. Если пакет exim не доступен, aptitude попытается
       установить пакет с наивысшим приоритетом, чья версия-кандидат
       предоставляет exim. Если такого пакета нет, aptitude установит пакет с
       наивысшим приоритетом, чья версия-кандидат предоставляет виртуальный
       пакет mail-transport-agent. С другой стороны, допустим, что эта
       зависимость имеет вид «Зависит: exim (>= 2.0.0) |
       mail-transport-agent», но доступна лишь версия 1.0 пакета exim. В этом
       случае, aptitude не будет устанавливать exim (поскольку его версия не
       подходит), и не будет пытаться установить пакеты, предоставляющие exim
       (так как виртуальные пакеты не могут подойти для разрешения
       зависимости с ограничением версии). Таким образом, aptitude прибегнет
       к установке пакета с наивысшим приоритетом, чья версия-кандидат
       предоставляет mail-transport-agent.

    4. Если пакет был установлен на предыдущем шаге, разрешить его
       зависимости, используя этот алгоритм, затем остановиться.

   Хотя этот метод обычно разрешает все зависимости пакетов, он может не
   работать в ряде обстоятельств.

     * Конфликты разрешаются удалением пакета, который является целью
       конфликта. Тем не менее, в этом случае другие пакеты, которые зависят
       от этого пакета, имеют нерешённые зависимости; непосредственный
       решатель не предпринимает попыток исправить их.

     * Зависимость может быть неразрешимой из-за ограничений версии и из-за
       того ограничения, что рассматриваются только версии-кандидаты.
       Например, допустим, что доступны версии 1.0 и 2.0 пакета fileutils,
       что версией-кандидатом является 1.0, и что пакет octopus объявляет
       зависимость «Зависит: fileutils (>= 2.0)». Непосредственное решение не
       может разрешить эту зависимость: оно никогда не будет рассматривать
       версию 2.0, так как она не является версией-кандидатом.

   Интерактивный решатель зависимостей может разрешить подобные ситуации и
   даже больше. Когда остаются сломанные зависимости, или когда
   непосредственное разрешение зависимостей отключено, интерактивный решатель
   автоматически запустит поиск решения. Следующий раздел описывает то, как
   использовать интерактивный решатель зависимостей.

  Интерактивное разрешение зависимостей

   Если возникает такая проблема зависимостей, которая не может быть решена
   использованием непосредственного решателя зависимостей, aptitude может
   помочь вам в её решении. Как только возникнет проблема, в нижней части
   экрана появится красная полоска, содержащая сводку предложения aptitude по
   решению этой зависимости. Например, на следующем снимке экрана, aptitude
   указывает, что можно решить проблему, сохранив двум пакетам их текущих
   версиях.

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 aptitude 0.6.8.2       #Сломано: 2   Освободится на диске 9 297 кБ
 id   libreoffice-base                                    -9 297 kB 1:3.5.4+dfsg-4  1:3.5.4+dfsg-4
 i     mysql-common                                   5.5.30+dfsg-1 5.5.30+dfsg-1
 i   sqlitebrowser                                        2.0.0~beta1+ds   2.0.0~beta1+ds
 i     unixdbc                                             2.2.14p2-5   2.2.14p2-5
 i    virtuoso-minimal                                                  6.1.4+dfsg1-6   6.1.4+dfsg1-6
 i     virtuoso-opensource-6.1-bin                                        6.1.4+dfsg1-6  6.1.4+dfsg1-6
 i     virtuoso-opensource-6.1-common                                            6.1.4+dfsg1-6   6.1.4+dfsg1-6
    --- devel - Утилиты и программы для разработки ПО (57)
    --- doc - Документация и специальные программы для просмотра документации (51)
 office-productivity suit — database
 libreoffice-base будет удалён.


 Следующие пакеты зависят от libreoffice-base и будут испорчены
 удалением:


   * libreoffice зависит от libreoffice-base
   * libreoffice-report-builder-bin зависит от libreoffice-base

 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Как это обозначено в нижней части экрана, вы можете просмотреть
   дополнительные решения, нажав . и ,, применить текущее решение, нажав !, и
   рассмотреть решение более более подробно, нажав e. Когда вы рассматриваете
   текущее решение, появляется экран, схожий со следующим:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Помощь  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Разрешить зависимости
   --\ Удалить следующие пакеты:
     libreoffice-report-builder-bin                           [1:3.5.4+dfsg-4 (now, testing)]
     libreoffice                                                [1:3.5.4+dfsg-4 (now, testing)]
















 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Вы можете получить доступ к информации о пакете, который является объектом
   действия, просто нажав клавишу Enter в тот момент, когда этот пакет
   выбран. Для получения более подробного объяснения того, почему aptitude
   сделал некоторый выбор, вы можете выбрать элемент в списке. Когда вы
   сделаете это, нижняя половина экрана будет отображать зависимость,
   разрешаемую выбором aptitude, а также каждый способ, каким эта зависимость
   могла бы быть разрешена.

  Действия  Откат  Пакет  Решатель  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Разрешить зависимости
   --\ Удалить следующие пакеты:
     libreoffice-report-builder-bin                           [1:3.5.4+dfsg-4 (now, testing)]
     libreoffice                                      [1:3.5.4+dfsg-4 (now, testing)]






 office prodictivity suit
 libreoffice зависит от libreoffice-base
 --\ Следующие действия разрешат эту зависимость:
   -> Обновить libreoffice [1:3.5.4+dfsg-4 (now, testing)] -> 1:4.0.2~rc-2.2 (exper
   -> Обновить libreoffice [1:3.5.4+dfsg-4 (now, testing)] -> 1:3.5.4+dfsg2-1 (uns
   -> Удалить libreoffice [1:3.5.4+dfsg-4 (now, testing)]
   -> Обновить libreoffice-base [1:3.5.4+dfsg-4 (now, testing)] -> 1:4.0.2~rc-2.2 (
   -> Обновить libreoffice-base [1:3.5.4+dfsg-4 (now, testing)] -> 1:3.5.4+dfsg2-1

   -> Отменить удаление libreoffice-base
 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Вы можете направлять решатель зависимостей к одобряемому вами решению,
   одобряя или отклоняя индивидуальные действия решения. Если вы одобряете
   действие, то решатель будет выбирать это действие всегда, когда это
   возможно, игнорируя альтернативы (когда имеется несколько одобренных
   альтернатив, любая из них может быть выбрана). С другой стороны, если вы
   отклоняете действие, решатель никогда не выберет это действие.

   Чтобы отклонить действие, выберите его и нажмите r; отклонение может быть
   отменено повторным нажатием r. Сходным образом, выберите действие и
   нажмите a, чтобы одобрить его; нажмите a снова, чтобы вернуть изначальное
   состояние действия. Вы можете откатить то или иное действие, используя
   команду Откат → Откат (Control+u) в то время, когда активен экран
   решателя. Если вы отмените отклонение или одобрение, любые решения,
   которые до этого игнорировались, будут доступны при следующей генерации
   нового решения.

   [Primechanie] Примечание
                 По-умолчанию, решатель отклоняет действия, которые меняют
                 состояния зафиксированных пакетов, и те, которые
                 устанавливают запрещённые версии пакетов. Вы можете отменить
                 эти отклонения, позволяя, таким образом, автоматически
                 игнорировать зафиксированные или запрещённые отметки, так же
                 как вы могли бы игнорировать любое другое отклонение.
                 Установка параметра настройки
                 Aptitude::ProblemResolver::Allow-Break-Holds в значение true
                 отключит это поведение, что подразумевает, что решатель
                 всегда будет ломать фиксации (хотя и со штрафом, см.
                 Aptitude::ProblemResolver::BreakHoldScore).

   Отклонённые действия окрашены красным и отмечены флагом «R», а одобренные
   действия окрашены зелёным и отмечены флагом «A». Вы можете видеть это на
   следующем снимке экрана, где действие «удалить
   libreoffice-report-builder-bin в текущей версии» было отклонено, а
   действие «удалить libreoffice в текущей версии» было одобрено.

  Действия  Откат  Пакет  Решатель  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Разрешить зависимости
   --\ Сохранить для следующих пакетов их текущие версии:
 R   libreoffice-report-builder-bin                           [1:3.5.4+dfsg-4 (now, testing]
 A   libreoffice                                      [1:3.5.4+dfsg-4 (now, testing]
















 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Отклонения и одобрения оказывают влияние только на заново создаваемые
   решения. Вы можете определить, когда будет создано новое решение, для
   этого посмотрите на индикатор в нижнем левом углу экрана: там имеется
   число в круглых скобках, это число решений, которые были созданы.
   Соответственно, когда число за круглыми скобками и число внутри круглых
   скобок равны (как в случае вверху), нажатие . приведёт к созданию нового
   решения. Если в скобках нет числа (например, индикатор имеет следующий
   вид: [1/5]), то дополнительные решения не будут созданы. В любой момент вы
   можете выбрать последнее созданное решение, нажав >, или первое созданное
   решение, нажав <.

   [Vazhno] Важно
            Состояние решателя проблем сбрасывается, когда вы изменяете
            состояние какого-либо пакета. Если вы отмечаете пакет для
            установки, обновления или удаления и т. д., решатель забывает обо
            всех отклонениях или одобрениях, а также обо всех решениях,
            которые были созданы до этого момента.

   В дополнение к выбору действий в списке вверху экрана, вы также можете
   выбрать их, используя список в нижней половине экрана. Чтобы получить
   доступ к этому списку, либо кликните на нем мышкой, либо нажмите Tab.
   Наконец, чтобы посмотреть решения, предлагаемые решателем и расположенные
   по порядку, нажмите o. Это даст вам список зависимостей, которые были
   решены, и действие, предпринятое для их разрешения, в виде как на
   следующем снимке экрана.

  Действия  Откат  Пакет  Решатель  Поиск  Параметры  Окна  Помощь
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
                 Пакеты                          Разрешить зависимости
   --\ libreoffice зависит от libreoffice-base
     -> Удалить libreoffice [1:3.5.4+dfsg-4 (now, testing)]
   --\ libreoffice-report-builder-bin зависит от libreoffice-base
     -> Удалить libreoffice-report-builder-bin [1:3.5.4+dfsg-4 (now, testing)]





 office prodictivity suit
 libreoffice зависит от libreoffice-base
 --\ Следующие действия разрешат эту зависимость:
   -> Обновить libreoffice [1:3.5.4+dfsg-4 (now, testing)] -> 1:4.0.2~rc-2.2 (exper
   -> Обновить libreoffice [1:3.5.4+dfsg-4 (now, testing)] -> 1:3.5.4+dfsg2-1 (uns
   -> Удалить libreoffice [1:3.5.4+dfsg-4 (now, testing)]
   -> Обновить libreoffice-base [1:3.5.4+dfsg-4 (now, testing)] -> 1:4.0.2~rc-2.2 (
   -> Обновить libreoffice-base [1:3.5.4+dfsg-4 (now, testing)] -> 1:3.5.4+dfsg2-1

   -> Отменить удаление libreoffice-base
 [1(1)/...] Предлагается выполнить 2 удаления
 e: Рассмотреть  !: Применить  .: Следующий  ,: Предыдущий

   Вы можете выйти из этого вида отображения, снова нажав o.

  Стоимость в интерактивном решателе зависимостей

    Стоимости и стоимостные компоненты

   Стоимость решения, выводимая интерактивным решателем зависимостей,
   является значением, используемым aptitude для определения того, насколько
   «плохим» является некоторое решение. «Более хорошие» решения отображаются
   перед «более плохими» решениями. Стоимость решения определяется параметром
   настройки Aptitude::ProblemResolver::SolutionCost.

   Некоторая типичная стоимость приведена в Пример 2.1, «Примеры стоимости
   решателя».

   Пример 2.1. Примеры стоимости решателя

   Стоимость по-умолчанию, сортировка по их стоимости безопасности, затем по
   их приоритету apt:

 safety, priority

   Удалить как можно меньше пакетов, затем отменить как можно меньше
   действий:

 removals, canceled-actions

   Отсортировать решения по числу удаляемых пакетов плюс двойное число
   отменяемых действий.

 removals + 2 * canceled-actions

   Как видно из приведённых выше примеров, стоимость не является с
   необходимостью «единичным» числом. Фактически, стоимость состоит из одного
   или более стоимостных компонентов, каждый из которых является числом,
   ассоциированным с решением. Когда решатель сортирует решения, он
   рассматривает стоимостные компоненты по порядку, переходя к более поздним
   компонентам только в том случае, если ранние компоненты равны. Например, в
   стоимости «removals, canceled-actions», решения с наименьшим числом
   удалений всегда будут отображаться перед решениями с большим числом
   удалений независимо от того, сколько в них отменяемых действий. Тем не
   менее, решения с одинаковым числом удалений сортируются так, что решения с
   наименьшим числом отменяемых действий отображаются первыми.

   Стоимостные компоненты могут быть двух вариантов: базовые стоимостные
   компоненты и составные стоимостные компоненты.

   Базовые компоненты просто именуют некоторое свойство решения, такое как
   «обновления» или «удаления». Список встроенных базовых компонентов,
   предоставляемый aptitude может быть найден в Таблица 2.1, «Базовые
   стоимостные компоненты». Вы можете также создать свои собственные
   стоимостные компоненты, используя подсказки add-to-cost-component и
   raise-cost-component; подробности см. в разделе «Настройка подсказок
   решателя».

   Каждый базовый компонент является либо счётчиком, либо уровнем. Счётчики
   считают то, сколько действий решения удовлетворяют некоторому условию
   (такому как удаление пакетов или установка новых пакетов), в то время как
   уровни ассоциируют число со всяким действием и вычисляют наибольшее число,
   ассоциируемое со всяким действием в решении.

   Таблица 2.1. Базовые стоимостные компоненты

+----------------------------------------------------------------------------------+
|        Имя         |  Тип  |                      Описание                       |
|--------------------+-------+-----------------------------------------------------|
|                    |       |Считает число фиксаций, ломаемых решением, если      |
|broken-holds        |Счётчик|решателю разрешено ломать фиксации                   |
|                    |       |(Aptitude::ProblemResolver::Allow-Break-Holds).      |
|--------------------+-------+-----------------------------------------------------|
|canceled-actions    |Счётчик|Считает число ожидаемых действий, отменяемых решением|
|                    |       |(сохранение пакет в их текущих версиях).             |
|--------------------+-------+-----------------------------------------------------|
|installs            |Счётчик|Считает число пакетов, устанавливаемых решением.     |
|--------------------+-------+-----------------------------------------------------|
|non-default-versions|Счётчик|Считает число версий, устанавливаемых или обновляемых|
|                    |       |из источников не по-умолчанию.                       |
|--------------------+-------+-----------------------------------------------------|
|                    |       |Значение, которое возрастает при снижении у версии   |
|priority            |Уровень|пакета приоритета apt. Точнее, оно вычисляется       |
|                    |       |отрицанием приоритета (так, например, если приоритет |
|                    |       |равен 500, этот компонент будет равен -500).         |
|--------------------+-------+-----------------------------------------------------|
|removals            |Счётчик|Считает число пакетов, удаляемых решением.           |
|--------------------+-------+-----------------------------------------------------|
|removals-of-manual  |Счётчик|Считает число установленных вручную пакетов,         |
|                    |       |удаляемых решением.                                  |
|--------------------+-------+-----------------------------------------------------|
|                    |       |Широкое эвристическое значение, которое возрастает в |
|safety              |Уровень|том случае, когда действия становятся наименее       |
|                    |       |«безопасными»; подробности см. в разделе «Стоимости  |
|                    |       |безопасности».                                       |
|--------------------+-------+-----------------------------------------------------|
|upgrades            |Счётчик|Считает число пакетов, обновляемых решением.         |
+----------------------------------------------------------------------------------+

   Составные компоненты получаются путём комбинации значений базовых
   компонентов. Например, removals + canceled-actions складывает компоненты
   removal и canceled-actions, в результате получается компонент, который
   считает число удалений и отменяемых действий. Сложные компоненты
   комбинируют счётчики, складывая их вместе, и уровни, беря их максимальное
   значение, как это показано в Рисунок 2.11, «Синтаксис составных
   стоимостных компонент».

   [Primechanie] Примечание
                 Складывать два уровня неправильно, а также брать максимум
                 двух счётчиков или каким-то образом комбинировать уровни и
                 счётчики. Например, стоимость removals + safety и
                 max(upgrades, installs) будут считаться ошибками и будут
                 игнорироваться решателем.^[13]

   Рисунок 2.11. Синтаксис составных стоимостных компонент

   Сложить два или более значения стоимости:

                 [множитель1]*стоимость1 + [множитель2]*стоимость2 + ...


   Принять максимальное значение двух или более базовых стоимости:

                 max([множитель1]*стоимость1, [множитель2]*стоимость2, ...)


   Заметьте, что каждый отдельный базовый компонент может быть умножен на
   коэффициент до его объединения с другими компонентами. Это может быть
   использовано для управления компромиссами стоимости. Например, стоимость
   2*removals + 3*upgrades говорит о том, что три удаления в точности так же
   «плохи» как два обновления. Решения, содержащие четыре удаления и одно
   обновление, будут рассматриваться как эквивалентные решениям, содержащим
   одно удаление и три обновления, поскольку стоимость обоих типов решений
   равна одиннадцати.

    Стоимости безопасности

   Рисунок 2.12. Уровни стоимости безопасности

   Urovni stoimosti bezopasnosti

   Компонент стоимости безопасности является эвристической оценкой того,
   насколько «безопасно» или «небезопасно» некоторое решение. Стоимости
   безопасности могут рассматриваться как способ разделения решений на
   несколько нумерованных «уровней», где «менее безопасным» уровням
   назначаются более высокие числа. Рисунок 2.12, «Уровни стоимости
   безопасности» демонстрирует, как это работает с настройками aptitude
   по-умолчанию.

   [Podskazka] Подсказка
               Уровни стоимости безопасности являются способом управления
               порядком, согласно которому выводятся решения зависимостей.
               Полное описание того, как изменять порядок сортировки решений
               aptitude, см. в разделе «Стоимость в интерактивном решателе
               зависимостей».

   По-умолчанию, aptitude инициализирует решатель с «приемлемым» набором
   уровней стоимости безопасности. Это следующие уровни:

   Таблица 2.2. Уровни стоимости безопасности по-умолчанию

+---------------------------------------------------------------------------------------+
| Уровень |         Описание          |               Параметры настройки               |
|стоимости|                           |                                                 |
|---------+---------------------------+-------------------------------------------------|
|         |Решения, включающие лишь   |                                                 |
|         |«безопасные» действия      |                                                 |
|10,000   |(установка для пакета цели |Aptitude::ProblemResolver::Safe-Level,           |
|         |по-умолчанию или сохранение|Aptitude::ProblemResolver::Remove-Level          |
|         |текущей версии пакета) и   |                                                 |
|         |удаления пакетов.          |                                                 |
|---------+---------------------------+-------------------------------------------------|
|20,000   |Решение отменяет все       |Aptitude::ProblemResolver::Keep-All-Level        |
|         |действия пользователя.     |                                                 |
|---------+---------------------------+-------------------------------------------------|
|         |Решения, которые ломают    |                                                 |
|         |фиксации, установленные    |                                                 |
|40,000   |пользователем, или         |Aptitude::ProblemResolver::Break-Hold-Level      |
|         |устанавливают запрещённые  |                                                 |
|         |версии.                    |                                                 |
|---------+---------------------------+-------------------------------------------------|
|         |Решения, которые           |                                                 |
|         |устанавливают версии не    |                                                 |
|50,000   |по-умолчанию (такие, как   |Aptitude::ProblemResolver::Non-Default-Level     |
|         |например,                  |                                                 |
|         |«экспериментальные»).      |                                                 |
|---------+---------------------------+-------------------------------------------------|
|         |Действия, которые удаляют  |                                                 |
|60,000   |пакеты первой              |Aptitude::ProblemResolver::Remove-Essential-Level|
|         |необходимости.             |                                                 |
+---------------------------------------------------------------------------------------+

   Если решение соответствует нескольким уровням стоимости безопасности, оно
   будет помещено на самый высокий уровень, то есть, тот, что появился
   последним. Например, решение, обновляющее один пакет до его версии
   по-умолчанию и ломающее фиксацию другого пакета, будет помещено на уровень
   40,000. Вы можете настроить уровни индивидуальных версий, используя
   руководство по решателю; подробности см. в разделе «Настройка подсказок
   решателя». Уровни по-умолчанию иллюстрируются в Рисунок 2.12, «Уровни
   стоимости безопасности».

  Настройка интерактивного решателя зависимостей

    Настройка подсказок решателя

   Чтобы улучшить качество решений зависимостей, получаемых вами, вы можете
   дать интерактивному решателю зависимостей подсказки. Эти подсказки могут
   изменить приоритеты решателя, сильнее склоняя его в пользу одной версии
   пакет, или они могут быть использованы для «предварительной загрузки»
   решателя с отклонениями и одобрениями, так же как если бы вы вошли в
   решатель и вручную отклонили или одобрили различные версии.

   Подсказки хранятся в файле настройки apt, /etc/apt/apt.conf, в группе
   настроек «Aptitude::ProblemResolver::Hints» (подробности о файле настроек
   см. в разделе «Руководство по файлу настроек»).

   Каждая подсказка решателя состоит из действия, цели и необязательной
   версии. Подсказка записывается так: "действие цель [версия]". Чтобы
   применить подсказку решателя, aptitude находит один или несколько пакетов,
   используя значение переменной цель, выбирает одну или несколько версий
   этих пакетов, используя значение переменной версия и, наконец, выполняет
   данное действие.

   Поле действие подсказки решателя может быть одним из следующих:

    1. «approve»: Одобрить версию, как будто была выполнена команда Решатель
       → Переключить одобрение (a) .

    2. «reject»: Отклонить версию, как будто была выполнена команда Решатель
       → Переключить отказы (r) .

    3. «discard»: Отбросить всякое решение, содержащее версию. Отличается от
       «reject» тем, что она не видима для пользователя и не может быть
       изменена интерактивно.

    4. «increase-safety-cost-to число»: увеличить стоимость безопасности
       всякого решения, содержащего версию до числа; если стоимость
       безопасности этого действия уже выше, чем число, эта подсказка не
       будет работать. Стоимость безопасности может использоваться (и
       используется по-умолчанию) для управления порядком, соответственно
       которому появляются решения; подробности см. в разделе «Стоимости и
       стоимостные компоненты» и «Стоимости безопасности».

       Несколько специальных уровней стоимости, которые могут быть выбраны по
       имени:

         a. conflict, discard: вместо изменения стоимости безопасности,
            отбросить решения, содержащие версию, как если бы была применена
            подсказка «discard ».

         b. maximum: наиболее высокая стоимость безопасности.

         c. minimum: наименее низкая стоимость безопасности. Любой поиск
            начинается с этой стоимости, поэтому «увеличение» версии на эту
            стоимость не оказывает влияния. Тем не менее, это значение может
            быть использовано при настройке предопределённых уровней
            безопасности: например, установка
            Aptitude::ProblemResolver::Remove-Level на «minimum» приведёт к
            тому, что удаляемые пакеты не будут оказывать влияния на
            стоимость безопасности решения.

       [Primechanie] Примечание
                     Подсказка increase-safety-cost-to применяется в
                     дополнение ко всякой стоимости безопасности
                     по-умолчанию, соответствующей выбранному действию.
                     Например, подсказка, увеличивающая стоимость
                     безопасности «установки hal из экспериментального
                     архива» до 15,000, не окажет влияния, так как это
                     действие уже имеет стоимость безопасности равную 50,000
                     (учитывая, что эта версия пакета hal не является
                     версией-кандидатом по-умолчанию).

    5. «number»: добавить данное число к счету версии пакета, настраивая
       решатель в пользу этой версии или (с отрицательным числом) против неё.
       Например, подсказка 200 emacs добавляет 200 к счёту emacs, в то время
       как подсказка -10 emacs вычитает 10 из его счёта.

   Если поле цель подсказки решателя содержит знак вопроса («?») или тильду
   («~»), она рассматривается как поисковый шаблон, и рассматриваются все
   подходящие версии пакетов. В других же случаях она рассматривается как имя
   пакета. Поэтому цель «g++» выберет только пакет g++, а цель
   «?section(non-free)» выберет все пакеты в секции non-free. Дополнительную
   информацию о поисковых шаблонах см. в разделе «Поисковые шаблоны».

   Если поле версия отсутствует, то все версии пакета подвергаются
   воздействию данной подсказки. В противном случае она может иметь любую из
   следующих форм:

    1. «/архив»: подсказка затрагивает только версии, доступные в данном
       архиве.

    2. «<версия»: подсказка затрагивает только те версии, номер версии
       которых меньше версии.

    3. «<=версия»: подсказка затрагивает только те версии, номер версии
       которых меньше или равен версии.

    4. «=версия»: подсказка затрагивает только те версии, номер версии
       которых равен версии.

    5. «<>версия»: подсказка затрагивает только те версии, номер версии
       которых не равен версии.

    6. «>=версия»: подсказка затрагивает только те версии, номер версии
       которых больше или равен версии.

    7. «>версия»: подсказка затрагивает только те версии, номер версии
       которых больше версии.

    8. «:UNINST»: вместо влияния на какую-либо версию цели, подсказка влияет
       на решение удалить цель. Например, «reject aptitude :UNINST»
       предупредит решатель от попытки удалить aptitude.

    9. «версия»: подсказка затрагивает только те версии, номер версии которых
       равен версии.

Поисковые шаблоны

   Когда в aptitude вы ищете пакет или устанавливаете ограничение
   отображения, строка, введённая вами, называется «поисковым шаблоном». Хотя
   базовое употребление поисковых шаблонов заключается в том, чтобы отбирать
   пакеты по имени, aptitude позволяет вам создавать намного более сложные
   поисковые запросы. Помимо использования в визуальном интерфейсе, поисковые
   шаблоны могут использоваться в некоторых операциях командной строки;
   дополнительную информацию см. в разделе Руководство по командной строке.

   Поисковой шаблон состоит из одного или более условий (иногда
   называемых«терминами»); пакеты соответствуют шаблону, если они
   соответствуют всем его терминам. Термины обычно начинаются со знака
   вопроса («?»), за которым следует имя соответствующего термина,
   описывающего тот поиск, который выполняется этим термином: например,
   термин ?name отбирает пакеты по именам, а термин ?version отбирает пакеты
   по версиям. Любые дополнительные параметры поискового термина помещаются в
   скобки (см. документацию по терминам для подробного изложения того, что
   означают те или иные параметры).

   [Primechanie] Примечание
                 Текст не начинающийся с «?» также формирует поисковой
                 шаблон: aptitude будет расценивать каждое слово (или
                 закавыченную строку) как аргумент шаблона ?name, который
                 производит поиск пакета, чьё имя соответствует введённому
                 тексту, текст интерпретируется как регулярное выражение.

   [Preduprezhdenie] Предупреждение
                     Поведение aptitude в случае, когда данный поисковый
                     шаблон не начинается с «?» (или «~»), предоставляется
                     как удобство для интерактивного использования и будет
                     изменено в будущих выпусках; скрипты, вызывающие
                     aptitude должны явным образом указывать поисковую
                     стратегию, которую следует использовать. То есть,
                     скрипты должны осуществлять поиск по «?name(coq)», а не
                     по «coq»).

  Поиск строк

   Многие поисковые термины принимают в качестве параметра строку и
   сравнивают её с одним или несколькими полями пакета. Строки могут вводится
   с двойными кавычками или без них («"»), поэтому «?name(scorch)» и
   «?name("scorch")» будут выполнять один и тот же поиск. Если вы ввели
   поисковую строку, используя двойные кавычки, вы можете добавить в неё
   символ двойных кавычек, помещая непосредственно перед ним две обратных
   косых черты («\») : например, «?description("\"easy\"")» будет
   соответствовать пакету, чьё описание содержит строку «"easy"».

   Если вы введёте «голую» строку, т. е. строку, не заключённую в двойные
   кавычки, aptitude будет считать, что эта строка «заканчивается», когда
   будет обнаружена закрывающая скобка или запятая перед вторым аргументом
   поискового термина ^[14]. Для того, чтобы отменить специальное значение
   этих символов, поместите тильду («~») непосредственно перед ними.
   Например, «?description(etc))» является синтаксической ошибкой, так как
   первый символ «)» заканчивает ?description термин, а второй символ «)» не
   соответствует какому-либо символу «(». С другой стороны,
   «?description(etc~))» соответствует пакету, чьё описание содержит текст
   «etc)». Для использования сокращённой нотации терминов есть и другие
   причины; более подробную информацию см. в разделе «Сокращения для
   поисковых терминов».

   Большинство текстовых поисков (имен пакетов, описаний и т. д.) выполняются
   с использованием нечувствительных к регистру регулярных выражений.
   Регулярное выражение соответствует полю, если любая часть поля
   соответствует этому выражению; например, «ogg[0-9]» будет соответствовать
   «libogg5», «ogg123» и «theogg4u». Некоторые символы имеют специальное
   значение внутри регулярных выражений ^[15] , поэтому если вы хотите, чтобы
   они использовались в поиске, вам необходимо экранировать их обратной косой
   чертой: например, чтобы найти «g++», вам следует использовать шаблон
   «g\+\+».

   Символы «!» и «|» имеют специальные значения внутри поисковых шаблонов.
   Чтобы включить эти символы в строку, не заключенную в кавычки, вам
   необходимо поместить тильду («~») непосредственно перед ними. Например,
   чтобы выбрать пакеты, чье описание содержит либо «grand», либо «oblique»,
   используйте шаблон «?description(grand~|oblique)». Тем не менее, в
   указанных случаях вам, вероятно, покажется более удобным использовать
   закавыченную строку: «?description("grand|oblique")».

  Сокращения для поисковых терминов

   Некоторые поисковые термины могут быть введены, используя их «краткие»
   формы, которые состоят из тильды («~»), за которой следует один символ,
   определяющий термин, а затем аргументы (если они имеются) этого термина.
   Например, краткой формой термина ?name(aptitude) является ~n aptitude.

   Когда вы вводите термин, используя его краткую форму, символы тильды и
   «пробелов» — то есть символы пробела, табуляции и т. д. — будут закрывать
   этот термин и начинать новый. Например, «~mDaniel Burrows» будет
   соответствовать пакету, чье поле сопровождающего содержит «Daniel», и чье
   имя содержит «Burrows», в то время как «~i~napt» соответствует
   установленным пакетам, чье имя содержит apt. Для того, чтобы добавить
   символы пробелов в поисковое выражение, вы можете либо поместить тильду
   перед символом пробела (как в Daniel~ Burrows), либо заключить его в
   кавычки (как в "Debian Project" или даже в Debian" "Project). Внутри
   закавыченной строки, для отмены специального значения кавычек может
   использоваться символ обратной косой черты («\»): например, ~d"\"email"
   будет соответствовать пакету, чье описание содержит символ кавычки,
   непосредственно за которым идет выражение email ^[16].

   [Primechanie] Примечание
                 Знаки вопроса («?») не заканчивают краткую форму термина,
                 даже если за ними следует имя поискового термина. Например,
                 «~napt?priority(required)» будет соответствовать пакетам,
                 чьи имена соответствуют регулярному выражению«
                 apt?priority(required)». Для того, чтобы объединить краткий
                 термин с поисковым термином, определенным по имени, добавьте
                 один или несколько пробелов между двумя этими терминами как
                 в «~napt ?priority(required)», или поместите текст (если
                 таковой имеется), следующий за краткой формой термина, в
                 кавычки как в «~n"apt"?priority(required)».

   Таблица 2.3, «Краткое руководство по поисковым терминам» содержит список
   кратких форм для каждого поискового термина.

  Поиск и версии

   По-умолчанию шаблон соответствует пакету, если любая версия этого пакета
   соответствует шаблону. Тем не менее, некоторые шаблоны ограничивают свои
   подшаблоны так, чтобы последние соответствовали только некоторым версиям
   пакета. Например, поисковый термин ?depends(шаблон) выберет пакет, который
   зависит от пакета, соответствующего шаблону. Тем не менее, шаблон будет
   проверен только относительно тех версий пакета, которые фактически
   удовлетворяют зависимость. Это означает, что если foo зависит от bar (>=
   3.0), и доступны версии 2.0, 3.0 и 4.0 bar, то в поисковом шаблоне
   ?depends(?version(2\.0)), только версии 3.0 и 4.0 будут проверены
   относительно шаблона ?version(2\.0), и следовательно foo не будет найден
   этим поиском.

   Важно то, какие версии проверяются, поскольку некоторые шаблоны, как в
   примере выше, соответствуют одной версии, но не соответствуют другой.
   Например, шаблон ?installed соответствует только той версии пакета (если
   таковая имеется), которая установлена в текущий момент. Сходным образом,
   шаблон ?maintainer(сопровождающий) соответствует только тем версиям,
   сопровождающим которых является данный сопровождающий. Обычно все версии
   пакета имеют одного и того же сопровождающего, но это не всегда так; в
   действительности, любой поисковой шаблон, проверяющий поля пакета
   (конечно, отличные от его имени) будет вести себя таким образом, так как
   все поля пакета могут меняться в зависимости от версии.

   Для того, чтобы проверить шаблон относительно всех версий пакета, даже
   если этот шаблон обычно проверялся бы только относительно некоторых
   версий, используйте термин ?widen. Например,
   ?depends(?widen(?version(2\.0))) выберет пакет A, который зависит от
   пакета B, где B имеет версию, соответствующую 2.0, независимо от того,
   удовлетворяет эта версия зависимость A или нет. С другой стороны, термин
   ?narrow ограничивает версии теми версиями, которые подходят под подшаблон:
   ?narrow(?installed, ?depends(?version(ubuntu))) выберет пакет, чья
   установленная версия имеет зависимость, которая может быть удовлетворена
   пакетом, чья строка версии содержит «ubuntu».

   [Primechanie] Примечание
                 Имеется незаметное, но очень важное различие между
                 соответствием шаблона пакету и соответствием шаблона всем
                 версиям этого пакета. Когда шаблон проверяется относительно
                 пакета, каждый из его терминов проверяется относительно
                 этого пакета, и поэтому каждый термин будет соответствовать
                 этому пакету, если любая версия пакета ему соответствует.
                 Когда же шаблон проверяется относительно каждой версии
                 пакета, он будет соответствовать пакету только тогда, когда
                 все его термины соответствуют одной и той же версии пакета
                 одновременно.

                 Например: предположим, что установлена версия 3.0-1 пакета
                 aardvark, но доступна версия 4.0-1. Тогда поисковое
                 выражение ?version(4\.0-1)?installed соответствует пакету
                 aardvark, так как ?version(4\.0-1) соответствует версии
                 4.0-1 aardvark, в то время как ?installed соответствует
                 версии 3.0-1. С другой стороны, это выражение не
                 соответствует всем версиям пакета aardvark, поскольку нет
                 такой версии, которая бы была установлена и имела бы номер
                 версии 4.0-1.

  Явные цели поиска

   Некоторые особенно сложные поисковые запросы могут быть выражены в
   aptitude с помощью ясных целей. В обычных поисковых выражениях не
   существует способа указать пакет или версию пакета, которая проверяется в
   текущий момент. Например, предположим, что вы хотите найти все пакеты P,
   которые зависят от другого пакета Q, причем такие пакеты, что Q
   рекомендует P. Очевидно, вам нужно начать с термина ?depends(...). Но
   параметр этого термина в ... требует некоторым образом выбрать пакеты,
   идентичные тому, которому соответствует ?depends. Описывая задачу выше, я
   делал это, указывая имена пакетов, называя их P и Q; термины с явными
   целями делают то же самое. ^[17]

   Явная цель вводится термином $Sfor;:

   Рисунок 2.13. Синтаксис термина ?for

 ?for переменная: шаблон

   Это выражение ведет себя в точности так же как шаблон, но в шаблоне может
   использоваться переменная для того, чтобы указывать на пакет или версию
   пакета, которой соответствует шаблон. Вы можете использовать переменную
   двумя способами:

    1. Термин ?= в точности соответствует пакету или версии пакета,
       обозначенным данной переменной. В частности, если соответствующий
       ?for-термин ограничен определённой версией, то ?= будет
       соответствовать либо этой версии (если ?= ограничен), либо всему
       пакету; в противном случае он будет соответствовать любой версии этого
       пакета.

       См. Пример 2.2, « Использование термина ?= » для примера того, как
       использовать ?=.

    2. Термин ?bind(переменная, шаблон) соответствует пакету или версии
       пакета, если значение переменной соответствует шаблоном.

       Для терминов с ? доступно сокращение. Выражение ?bind(переменная,
       ?термин[(аргументы)]) может быть заменено на
       ?переменная:термин(аргументы).

       Пример использования ?bind см. в разделе Пример 2.3, «Использование
       термина ?bind».

  Руководство по поисковым терминам

   Таблица 2.3, «Краткое руководство по поисковым терминам» содержит краткое
   изложение всех поисковых терминов, поддерживаемых aptitude. Полное
   описание каждого термина может быть найдено ниже.

   Таблица 2.3. Краткое руководство по поисковым терминам

+-------------------------------------------------------------------------------------------------------+
|             Длинная форма             |           Краткая форма            |         Описание         |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакет, привязанный|
|?=переменная                           |                                    |к переменной; см. «Явные  |
|                                       |                                    |цели поиска».             |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать любой пакет,      |
|?not(шаблон)                           |!шаблон                             |который не соответствует  |
|                                       |                                    |шаблону.                  |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, которые   |
|                                       |                                    |отмечены для данного      |
|?action(действие)                      |~aдействие                          |действия (например,       |
|                                       |                                    |«установки» или           |
|                                       |                                    |«обновления»).            |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, все версии|
|?all-versions(шаблон)                  |                                    |которых соответствуют     |
|                                       |                                    |шаблону.                  |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать любой пакет,      |
|?and(шаблон1, шаблон2)                 |шаблон1 шаблон2                     |который соответствует и   |
|                                       |                                    |шаблону1, и шаблону2.     |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, у которых |
|?any-version(шаблон)                   |                                    |хотя бы одна версия       |
|                                       |                                    |соответствует шаблону.    |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбирает пакеты для данной|
|                                       |                                    |архитектуры (такой как    |
|?architecture(архитектура)             |~rархитектура                       |«amd64» или «all»).       |
|                                       |                                    |Специальные значения:     |
|                                       |                                    |native и foreign.         |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты из данного |
|?archive(архив)                        |~Aархив                             |архива (например,         |
|                                       |                                    |«unstable»).              |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты,           |
|?automatic                             |~M                                  |установленные             |
|                                       |                                    |автоматически.            |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбирает всё, если        |
|?bind(переменная, шаблон)              |?переменная:термин-имя[(аргументы)] |переменная подходит под   |
|                                       |                                    |шаблон; см. «Явные цели   |
|                                       |                                    |поиска».                  |
|---------------------------------------+------------------------------------+--------------------------|
|?broken                                |~b                                  |Выбрать пакеты, имеющие   |
|                                       |                                    |сломанные зависимости.    |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакет, имеющий    |
|?broken-тип-зависимости                |~Bтип-зависимости                   |сломанную зависимость     |
|                                       |                                    |данного типа-зависимости. |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, имеющие   |
|?broken-тип-зависимости(шаблон)        |~DB[тип-зависимости:]шаблон         |сломанную зависимость     |
|                                       |                                    |данного типа-зависимости, |
|                                       |                                    |подходящие под шаблон.    |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, которые   |
|                                       |                                    |пакет, подходящий под     |
|?broken-reverse-тип-зависимости(шаблон)|~RBтип-зависимости:шаблон           |шаблон, объявляет как     |
|                                       |                                    |сломанную зависимость типа|
|                                       |                                    |тип-зависимости.          |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, которые   |
|?conflicts(шаблон)                     |~Cшаблон                            |конфликтуют с пакетом,    |
|                                       |                                    |соответствующим шаблону.  |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, которые   |
|?config-files                          |~c                                  |были удалены, но не       |
|                                       |                                    |вычищены.                 |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты,           |
|                                       |                                    |объявляющие зависимость   |
|?тип-зависимости(шаблон)               |~D[тип-зависимости:]шаблон          |типа тип-зависимости по   |
|                                       |                                    |отношению к пакету,       |
|                                       |                                    |подходящему под шаблон.   |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, чье       |
|?description(описание)                 |~dописание                          |описание соответствует    |
|                                       |                                    |описанию.                 |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать необходимые       |
|                                       |                                    |пакеты, то есть те, что   |
|?essential                             |~E                                  |имеют Пакеты первой       |
|                                       |                                    |необходимости: да в своих |
|                                       |                                    |управляющих файлах.       |
|---------------------------------------+------------------------------------+--------------------------|
|?exact-name(имя)                       |                                    |Выбрать пакеты, названные |
|                                       |                                    |именем.                   |
|---------------------------------------+------------------------------------+--------------------------|
|?false                                 |~F                                  |Не выбрать ни одного      |
|                                       |                                    |пакета.                   |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, подходящие|
|                                       |                                    |под шаблон с переменной,  |
|?for переменная: шаблон                |                                    |привязанной к             |
|                                       |                                    |соответствующему пакету;  |
|                                       |                                    |см. «Явные цели поиска».  |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, которые не|
|?garbage                               |~g                                  |требуются ни одному       |
|                                       |                                    |пакету, установленному    |
|                                       |                                    |вручную.                  |
|---------------------------------------+------------------------------------+--------------------------|
|?installed                             |~i                                  |Выбрать установленные     |
|                                       |                                    |пакеты.                   |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты,           |
|?maintainer(сопровождающий)            |~mсопровождающий                    |сопровождающиеся          |
|                                       |                                    |сопровождающим.           |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты,           |
|                                       |                                    |поддерживающие            |
|                                       |                                    |мультархитектурность      |
|?multiarch(мультиархитектура)          |                                    |мультиархитектуры (то     |
|                                       |                                    |есть, либо «foreign», либо|
|                                       |                                    |«same», либо «allowed»,   |
|                                       |                                    |либо «none»).             |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, для       |
|?narrow(фильтр, шаблон)                |~S фильтр шаблон                    |которых единственная      |
|                                       |                                    |версия подходит и под     |
|                                       |                                    |фильтр, и под шаблон.     |
|---------------------------------------+------------------------------------+--------------------------|
|?name(имя)                             |~nимя, имя                          |Выбрать пакеты с данным   |
|                                       |                                    |именем.                   |
|---------------------------------------+------------------------------------+--------------------------|
|?new                                   |~N                                  |Выбрать новые пакеты.     |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать установленные     |
|?obsolete                              |~o                                  |пакеты, которые более не  |
|                                       |                                    |могут быть загружены.     |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, подходящие|
|?or(шаблон1, шаблон2)                  |шаблон1 | шаблон2                   |под шаблон1, шаблон2, или |
|                                       |                                    |под оба.                  |
|---------------------------------------+------------------------------------+--------------------------|
|?origin(источник)                      |~Oисточник                          |Выбрать пакеты с данным   |
|                                       |                                    |источником.               |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты,           |
|?provides(шаблон)                      |~Pшаблон                            |предоставляющие пакет,    |
|                                       |                                    |подходящий под шаблон.    |
|---------------------------------------+------------------------------------+--------------------------|
|?priority(приоритет)                   |~pприоритет                         |Выбрать пакеты с данным   |
|                                       |                                    |приоритетом.              |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, являющиеся|
|                                       |                                    |целями зависимости типа   |
|?reverse-тип-зависимости(шаблон)       |~R[тип-зависимости:]шаблон          |тип-зависимости,          |
|                                       |                                    |объявленными пакетом,     |
|                                       |                                    |подходящим под шаблон.    |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, являющиеся|
|                                       |                                    |целями сломанной          |
|?reverse-broken-тип-зависимости(шаблон)|~RBтип-зависимости:шаблон           |зависимости типа          |
|                                       |                                    |тип-зависимости,          |
|                                       |                                    |объявленной пакетом,      |
|                                       |                                    |подходящим под шаблон.    |
|---------------------------------------+------------------------------------+--------------------------|
|?section(раздел)                       |~sраздел                            |Выбрать пакеты в данном   |
|                                       |                                    |разделе.                  |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, имя пакета|
|?source-package(имя)                   |                                    |с исходными кодами        |
|                                       |                                    |которого подпадает под    |
|                                       |                                    |регулярное выражение имя. |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, версия    |
|                                       |                                    |пакета с исходными кодами |
|?source-version(версия)                |                                    |которого подпадает под    |
|                                       |                                    |регулярное выражение      |
|                                       |                                    |версия.                   |
|---------------------------------------+------------------------------------+--------------------------|
|?tag(тег)                              |~Gтег                               |Выбрать пакеты, имеющие   |
|                                       |                                    |данный debtag тег.        |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Полнотекстовый поиск      |
|?term(ключевое-слово)                  |                                    |пакетов, содержащих данное|
|                                       |                                    |ключевое-слово.           |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Полнотекстовый поиск      |
|                                       |                                    |пакетов, содержащих       |
|?term-prefix(ключевое-слово)           |                                    |ключевое слово,           |
|                                       |                                    |начинающееся с данного    |
|                                       |                                    |ключевого-слова.          |
|---------------------------------------+------------------------------------+--------------------------|
|?true                                  |~T                                  |Выбрать все пакеты.       |
|---------------------------------------+------------------------------------+--------------------------|
|?task(задача)                          |~tзадача                            |Выбрать пакеты, входящие в|
|                                       |                                    |данную задачу.            |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать установленные     |
|?upgradable                            |~U                                  |пакеты, которые могут быть|
|                                       |                                    |обновлены.                |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, отмеченные|
|                                       |                                    |пользовательским тегом,   |
|?user-tag                              |                                    |подходящим под регулярное |
|                                       |                                    |выражение                 |
|                                       |                                    |пользовательский-тег.     |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать пакеты, чья версия|
|                                       |                                    |подходит под версию       |
|?version(версия)                       |~Vверсия                            |(специальные значения:    |
|                                       |                                    |CURRENT, CANDIDATE, и     |
|                                       |                                    |TARGET).                  |
|---------------------------------------+------------------------------------+--------------------------|
|?virtual                               |~v                                  |Выбрать виртуальные       |
|                                       |                                    |пакеты.                   |
|---------------------------------------+------------------------------------+--------------------------|
|                                       |                                    |Выбрать версии, у которых |
|                                       |                                    |любая версия              |
|?widen(шаблон)                         |~Wшаблон                            |соответствующего пакета   |
|                                       |                                    |подпадает под шаблон,     |
|                                       |                                    |исключая локальные        |
|                                       |                                    |ограничения версий.       |
+-------------------------------------------------------------------------------------------------------+

   имя

           Выбирает пакеты, чьи имена подходят под регулярное выражение имя.
           Это метод поиска «по-умолчанию» и он используется для шаблонов,
           которые не начинаются с ~.

           [Primechanie] Примечание
                         Чтобы выбрать пакеты, чьи имена содержат несколько
                         различных подстрок, используйте термин ?name
                         (описывается ниже); например,
                         «?name(apti)?name(tude)» будет соответствовать
                         пакетам, чьи имена содержат и «apti», и «tude».

   ?=переменная

           Выбирает пакеты, соответствующим значению переменной, которая
           должна быть связана ?for. Например, ?for x: ?depends( ?recommends(
           ?=x ) ) будет соответствовать пакету x, зависящему от пакета,
           рекомендующего x.

           Например, следующее поисковое выражение соответствует пакетам,
           которые конфликтуют сами с собой:

           Пример 2.2. Использование термина ?=

           ?for x: ?conflicts(?=x)

           Дополнительную информацию см. в разделе «Явные цели поиска».

   ?not(шаблон), !шаблон

           Выбирает пакеты, которые не соответствуют шаблону. Например,
           «?not(?broken)» выбирает пакеты, которые не являются «сломанными».

           [Primechanie] Примечание
                         Чтобы включить символ «!» в поисковую строку, он
                         должен быть «экранирован» путем помещения перед ним
                         тильды («~»); в противном случае, aptitude будет
                         рассматривать его как часть термина ?not. Например,
                         чтобы выбрать пакеты, чье описание содержит
                         «extra!», используйте «?description(extra~!)».

   ?and(шаблон1, шаблон2), шаблон1 шаблон2

           Выбирает пакеты, которые подходят и под шаблон1, и под шаблон2.

   ?or(шаблон1, шаблон2), шаблон1 | шаблон2

           Выбирает пакеты, которые подходят под шаблон1 или под шаблон2.

           [Primechanie] Примечание
                         Чтобы использовать символ «|» в регулярном
                         выражении, он должен быть «экранирован», иначе
                         aptitude создаст из него термин ИЛИ: «~|».

   (шаблон)

           Выбирает шаблон. Например, «opengl (perl|python)» соответствует
           пакетам, чьи имена содержат opengl, а также содержат или perl, или
           python.

   ?action(действие), ~aдействие

           Выбирает пакеты, над которыми должно быть выполнено данное
           действие . Действием может быть «install», «upgrade», «downgrade»,
           «remove», «purge», «hold» (проверяет, был ли пакет зафиксирован),
           или «keep» (проверяет, будет ли пакет оставлен в текущей версии).

           Заметьте, что этот запрос проверяет лишь то, действительно ли
           действие будет произведено над пакетом, а не то, может ли вообще
           оно быть произведено. Таким образом, например, ?action(upgrade)
           соответствует только тем пакетам, которые вы уже решили обновить,
           а не тем пакетам, которые могут быть обновлены в будущем (для
           последнего, используйте ?upgradable).

   ?all-versions(шаблон)

           Выбирает пакеты, все версии которых соответствуют данному
           выражению. Каждая версия пакета будет отдельно проверена на
           соответствие шаблону, и пакет будет считаться подходящим под
           шаблон только в том случае, если под него подходят все его версии.
           Пакеты без версий, такие как виртуальные пакеты, всегда будут
           выбираться этим поисковым термином.

           Этот термин не может быть использован в контексте, в котором выбор
           версий уже сужен, например при помощи ?depends или ?narrow. Тем не
           менее, он всегда может использоваться в ?widen.

   ?any-version(шаблон)

           Выбирает пакет, если какая-либо его версия соответствует шаблону в
           скобках. Этот запрос двойственен ?all-versions.

           Этот термин не может быть использован в контексте, в котором выбор
           версий уже сужен, например при помощи ?depends или ?narrow. Тем не
           менее, он всегда может использоваться в ?widen.

           [Primechanie] Примечание
                         Этот термин тесно связан с ?narrow. Фактически,
                         термин ?any-version(шаблон1 шаблон2) делает в
                         точности то же, что ?narrow(шаблон1, шаблон2).

   ?architecture(архитектура), ~rархитектура

           Выбирает версии пакета для данной архитектуры. Например,
           «?architecture(amd64)» выбирает пакеты архитектуры amd64, а
           «?architecture(all)» выбирает все независящие от архитектуры
           пакеты. Также принимает специальные значения native и foreign.

   ?archive(архив), ~Aархив

           Выбирает версии пакета, доступные из архива, соответствующего
           указанному регулярному выражению архив. Например,
           «?archive(testing)» выбирает пакеты, доступные из архива testing.

   ?automatic, ~M

           Выбирает пакеты, которые были установлены автоматически.

   ?bind(переменная, шаблон), ?переменная:имя-термина[(аргументы)]

           Выбирает пакеты или версии пакетов, если данный шаблон
           соответствует пакету или версии, привязанной к переменной, которая
           должна быть определена в ?for.

           Пример 2.3. Использование термина ?bind

           ?for x: ?depends(?depends(?for z: ?bind(x, ?depends(?=z))))

           ?for x: ?depends(?depends(?for z: ?x:depends(?=z)))

           Два поисковых шаблона в примере выше выбирают пакет x такой, что x
           зависит от пакета y, который, в свою очередь, зависит от пакета z
           такого, что x также напрямую зависит от z. В первом шаблоне ?bind
           используется явным образом, в то время как во втором шаблоне
           используется эквивалентный сокращенный синтаксис.

           Дополнительную информацию см. в разделе «Явные цели поиска».

   ?broken, ~b

           Выбирает «сломанные» пакеты: они имеют неудовлетворенную
           зависимость, предзависимость, поломки или конфликт.

   ?broken-тип-зависимости, ~Bтип-зависимости

           Выбирает пакеты, которые имеют неудовлетворенную («сломаны»)
           зависимость данного типа-зависимости. Типом-зависимости может быть
           «depends», «predepends», «recommends», «suggests», «breaks»,
           «conflicts» или «replaces».

   ?broken-тип-зависимости(pattern), ~DB[тип-зависимости:]шаблон

           Выбирает пакеты с неудовлетворенной зависимостью типа
           тип-зависимости по отношению к пакету, соответствующему шаблону.
           Типом-зависимости может быть любой тип зависимостей, указанный в
           описании ?broken-тип-зависимостей.

   ?conflicts(шаблон), ~Cшаблон

           Выбирает пакеты, конфликтующие с пакетом, соответствующим данному
           шаблону. Например, «?conflicts(?maintainer(dburrows@debian.org))»
           выбирает пакеты, конфликтующие с теми пакетами, которые
           сопровождаю я.

   ?config-files, ~c

           Выбирает пакеты, которые были удалены, но чьи файлы настройки
           остаются в системе (то есть, они были удалены, но не вычищены).

   ?тип-зависимости(шаблон), ~D[тип-зависимости:]шаблон

           Типом-зависимости может быть любой из типов зависимости,
           приведенный в описании ?broken-тип-зависимости, а также provides:
           например, ?depends(libpng3) выберет пакеты, которые зависят от
           libpng3. Если запрос используется в короткой форме (~D), и
           тип-зависимости не указан, по-умолчанию выбирается тип depends.

           Если тип-зависимости соответствует «provides», то выбираются те
           пакеты, которые предоставляют пакет, подходящий под шаблон
           (эквивалент ?provides). В противном случае, выбираются те пакеты,
           объявляющие зависимость типа тип-зависимости по отношению к версии
           пакета, подходящей под шаблон.

   ?description(описание), ~dописание

           Выбирает пакеты, чье описание подпадает под регулярное выражение
           описание.

   ?essential, ~E

           Выбирает пакеты первой необходимости.

   ?exact-name(имя)

           Выбирает пакеты, имеющие имя имя. Этот термин схож с ?name, но имя
           должно точно подходить под шаблон. Например, под следующий шаблон
           подходит только пакет apt; с ?name, под него подходил бы также
           aptitude, uvccapture и так далее.

           Пример 2.4. Использование термина ?exact-name

           ?exact-name(apt)

   ?false, ~F

           Под этот термин не подходит ни один пакет. ^[18]

   ?for переменная: шаблон

           Выбирает шаблон, но данная переменная может использоваться внутри
           шаблона для указания на пакет или версию пакета, на которую
           указывает этот термин.

           Вы можете использовать переменные двумя способами. Чтобы применить
           содержащий ? термин к переменной, напишите
           ?переменная:имя-термина(аргументы); например, ?x:depends(apt). В
           дополнение, термин ?=переменная выберет пакеты или версии пакетов,
           которые подходят под значение данной переменной.

           Например, следующий термин выберет пакет x, который зависит и
           рекомендует другой пакет y.

           Пример 2.5. Использование термина ?for

           ?for x: ?depends( ?for y: ?x:recommends( ?=y ) )

           Дополнительную информацию см. в разделе «Явные цели поиска».

   ?garbage, ~g

           Выбирает пакеты, которые еще не установлены или которые были
           установлены автоматически, и не входят в зависимости какого-либо
           установленного пакета.

   ?installed, ~i

           Выбирает версии пакета, установленные в данный момент.

           Так как по-умолчанию проверяются все версии, этот термин обычно
           выбирает пакеты, установленные в настоящий момент.

   ?maintainer(сопровождающий), ~mсопровождающий

           Выбирает пакет, чей сопровождающий подпадает под регулярное
           выражение сопровождающий. Например, «?maintainer(joeyh)» найдет
           все пакеты, сопровождаемые Джо Хессом.

   ?multiarch(мультиархитектура)

           Выбирает пакеты, поддерживающие мультиархитектурность,
           определенную мультиархитектурностью. Например,
           «?multiarch(foreign)» найдет все пакеты, которые удовлетворяют
           зависимости пакетов для другой архитектуры. «?multiarch(none)»
           выберет пакеты без поддержки мультиархитектурности.

   ?narrow(фильтр, шаблон), ~S фильтр шаблон

           Этот термин «сужает» поиск до версий пакетов, подходящих под
           фильтр. В частности, он выбирает версии пакетов, подпадающие и под
           фильтр, и под шаблон. Строковое значение этого сочетания является
           строковым значением шаблона.

   ?name(имя), ~nимя

           Выбирает пакеты, чье имя подпадает под регулярное выражение имя.
           Например, большинство пакетов, которые подпадают под
           «?name(^lib)», являются библиотеками одного или другого вида.

   ?new, ~N

           Выбирает пакеты, являющиеся «новыми»: то есть, они были добавлены
           в архив с момента последней очистки списка пакетов при помощи
           Действия → Забыть о новых пакетах (f) или действия командной
           строки forget-new.

   ?obsolete, ~o

           Этот термин выбирает установленные пакеты, которые более не
           доступны в их любой версии из любого архива. В визуальном
           интерфейсе эти пакеты приводятся в группе «Устаревшие и пакеты,
           созданные локально».

   ?origin(источник), ~Oисточник

           Выбирает версии пакетов, чей источник подпадает под регулярное
           выражение источник. Например, «!?origin(debian)» найдет
           неофициальные пакеты в вашей системе (пакеты не из архива Debian).

   ?provides(шаблон), ~Pшаблон

           Выбирает версии пакетов, которые предоставляют пакет, подпадающий
           под шаблон. Например, «?provides(mail-transport-agent)» выберет
           пакеты, предоставляющие «mail-transport-agent».

   ?priority(приоритет), ~pприоритет

           Выбирает пакеты, чей приоритет равен приоритету; приоритет должен
           быть extra, important, optional, required или standard. Например,
           «?priority(required)» выберет пакеты, чей приоритет соответствует
           «required».

   ?reverse-тип-зависимости(шаблон), ~R[тип-зависимости:]шаблон

           Тип-зависимости может быть или «provides», или один из типов
           зависимостей, приведенных в описании ?broken-тип-зависимости. Если
           тип-зависимости не введен, по-умолчанию используется depends.

           Если тип-зависимости соответствует «provides», выбирается пакет,
           чье имя предоставляется версией пакета, подпадающей под шаблон. В
           противном случае, выбираются пакеты, относительно которых версия
           пакета, подпадающая под шаблон, объявляет тип зависимости
           тип-зависимости.

   ?reverse-broken-тип-зависимости(шаблон),
   ?broken-reverse-тип-зависимости(шаблон), ~RB[тип-зависимости:]шаблон

           Тип-зависимости может быть или «provides», или один из типов
           зависимостей, приведенных в описании ?broken-тип-зависимости. Если
           тип-зависимости не введен, по-умолчанию используется depends.

           Выбирает пакеты, относительно которого версия пакета, подпадающая
           под шаблон объявляет неудовлетворенную зависимость типа
           тип-зависимости.

   ?section(раздел), ~sраздел

           Выбирает пакеты, чей раздел подпадает под регулярное выражение
           раздел.

   ?source-package(имя)

           Выбирает пакет, чье имя пакета с исходным кодом подпадает под
           регулярное выражение имя.

   ?source-version(версия)

           Выбирает пакет, чья версия пакета с исходным кодом подпадает под
           регулярное выражение версия.

   ?tag(тег), ~Gтег

           Выбирает пакет, чьё поле Тег подпадает под регулярное выражение
           тег. Например, шаблон ?tag(game::strategy) выберет стратегические
           игры.

           Дополнительную информацию о тегах и debtags, см. на
           http://debtags.alioth.debian.org.

   ?task(задача), ~tзадача

           Выбирает пакет, чье имя встречается в задаче, подпадающий под
           регулярное выражение задача.

   ?term(ключевое-слово)

           Этот термин выполняет полнотекстовый поиск ключевого-слова в кэше
           пакетов package. Когда он используется совместно с «aptitude
           search», Поиск → Ограничить экран (l) в curses оболочке, или
           введен в поле поиска пакета в GTK+ оболочке, то он позволит
           ускорить поиск aptitude, используя индекс Xapian.

   ?term-prefix(ключевое-слово)

           Этот термин выполняет полнотекстовый поиск любого ключевого слова
           в кэше пакетов apt, начинающегося с ключевого слова. Когда этот
           термин используется совместно с «aptitude search», Поиск →
           Ограничить экран (l) в curses оболочке, или введен в поле поиска
           пакета в GTK+ оболочке, этот термин позволит ускорить поиск
           aptitude, используя индекс Xapian.

           Этот термин схож с ?term, но выбирает расширения ключевого слова.
           Например, следующий поисковый шаблон будет выбирать любой пакет,
           индексированный под ключевыми словами hour, hourglass, hourly и
           так далее:

           Пример 2.6. Использование термина ?term-prefix

           ?term-prefix(hour)

   ?true, ~T

           Этот термин выбирает любой пакет. Например,
           «?installed?provides(?true)» выбирает установленные пакеты,
           предоставленные любыми пакетами.

   ?upgradable, ~U

           Этот термин выбирает установленный пакет, который может быть
           обновлен.

   ?user-tag(тег)

           Этот термин выбирает пакет, отмеченный пользовательским тегом,
           подпадающим под регулярное выражение тег.

   ?version(версия), ~Vверсия

           Выбирает версию пакета, чей номер версии подпадает под регулярное
           выражение версия, за исключением того, что отмечено ниже.
           Например, «?version(debian)» выберет пакеты, чья версия содержит
           «debian».

           Следующие значения поля версия трактуются специфично. Чтобы искать
           номера версий, содержащих эти значения, предпошлите значению
           обратную косую черту; например, чтобы найти пакеты, чей номер
           версии содержит CURRENT, ищите \CURRENT.

              * CURRENT выбирает установленную в настоящее время версию
                пакета, если таковая имеется.

              * CANDIDATE выбирает версию, если таковая имеется, пакета,
                которая будет установлена, если вы нажмете +, выбрав пакет,
                или выполните команду aptitude install для этого пакета.

              * TARGET выбирает версию пакета, которая выбрана для установки
                в настоящее время, если таковая имеется.

   ?virtual, ~v

           Выбирает пакет, являющийся чисто виртуальным: то есть, его имя
           предоставляется пакетом или упомянуто в зависимости, но пакета с
           таким именем не существует. Например, «?virtual!?provides(?true)»
           выбирает пакеты, являющиеся виртуальными и не предоставлены
           каким-либо пакетом: то есть, пакеты, которые входят в зависимости,
           но не существуют.

   ?widen(шаблон), ~Wшаблон

           «Расширяет» поиск: если подходящие версии были ограничены термином
           (таким как ?depends), эти ограничения сбрасываются. Так,
           ?widen(шаблон) выбирает версию пакета, если шаблон соответствует
           какой-либо версии этого пакета.

Настройка aptitude

  Настройка списка пакетов

   Имеется большое количество возможностей по настройке списка пакетов: как
   отображаются пакеты, как формируется иерархия пакетов, как пакеты
   сортируются, и даже то, как организован экран, все это может быть
   изменено.

    Настройка того, как отображаются пакеты

   Этот раздел описывает то, как настроить содержание и формат списка
   пакетов, строку статуса и строку заголовка, а также вывод командыaptitude
   search.

   Формат каждой из этих ячеек определяется «форматной строкой». Форматная
   строка представляет собой строку текста, содержащую %-экранирование,
   например, %p, %S и так далее. Окончательный вывод создается путем принятия
   текста и замены %-экранирований согласно их значениям (приведенным ниже).

   %-экранирование может иметь либо фиксированный размер, в этом случае оно
   будет заменено тем же количеством текста (с дополнительными символами
   пробела, добавленными для полного заполнения этого размера, если это
   необходимо), или оно может быть «расширяемым», последнее означает, что оно
   примет размер не затребованный столбцами с фиксированным размером. Если
   имеются несколько расширяемых столбцов, дополнительные пробелы
   распределяются между ними поровну.

   Все %-экранирования имеют размер по-умолчанию и/или возможность
   растяжения. Размер %-экранирования может быть изменен путем ввода
   соответствующего числа между % и символом, определяющим экранирование;
   например, %20V создает вывод версии-кандидата пакета шириной 20 символов.
   Помещение знака вопроса (?) между % и символом, определяющем
   экранирование, приведёт к тому, что «базовая» ширина столбца будет
   изменяться в зависимости от его содержания. Заметьте, что получившиеся
   столбцы могут быть не выравнены по вертикали!

   Если вы хотите, чтобы определенное %-экранирование было расширяемым, даже
   несмотря на то, что обычно оно имеет фиксированную ширину, поместите
   непосредственно после него знак решётки (то есть, «#»). Например, чтобы
   отобразить версию-кандидат некоторого пакета, не важно, какой длины,
   используйте форматную строку %V#. Вы также можете поместить # после того,
   что не является %-экранированием; aptitude «растянет» текст,
   предшествующий #, вставив после него дополнительные пробелы.

   Таким образом, синтаксис %-экранирования таков:

 %[ширина][?]код[#]

   Переменные настройки Aptitude::UI::Package-Display-Format,
   Aptitude::UI::Package-Status-Format и Aptitude::UI::Package-Header-Format
   определяют форматы списка пакетов по-умолчанию, заголовок шапки списка
   пакетов, и, соответственно, строку статуса внизу списка пакетов. Чтобы
   изменить то, как отображаются результаты команды aptitude search,
   используйте опцию -F.

   В форматных строках доступны следующие %-экранирования:

   [Primechanie] Примечание
                 Некоторые описания, приведенные ниже, указывают на «пакет».
                 В графическом интерфейсе это либо отображаемый пакет, либо
                 пакет, выбранный в текущий момент; при поиске через
                 командную строку, это отображаемый пакет.

   Экранирование       Имя           Размер    Расширямость     Описание
                                  по-умолчанию
                                                            В
                                                            действительности,
                                                            это не
                                                            экранирование;
   %%            Литерал %        1            Нет          оно просто
                                                            вставляет знак
                                                            процента в вывод
                                                            в том месте, где
                                                            вы его поставите.
                                                            В некоторых
                                                            обстоятельствах
                                                            строка формата
                                                            отображения будет
                                                            иметь
                                                            «параметры»:
                                                            например, при
                                                            поиске в
                                                            командной строке,
                                                            группы,
                                                            соответствующие
   %#число       Замена параметра Переменная   Нет          поиску,
                                                            используются в
                                                            качестве
                                                            параметров при
                                                            отображении
                                                            результата
                                                            поиска. Этот код
                                                            формата будет
                                                            заменен
                                                            параметром,
                                                            обозначенным
                                                            числом.
                                                            Флаг в один
                                                            символ длинной,
                                                            резюмирующие
                                                            любое действие,
   %a            Флаг действия    1            Нет          выполняемое над
                                                            пакетом, описание
                                                            в Рисунок 2.10,
                                                            «Значения флага
                                                            «действие»».
                                                            В некотором
                                                            смысле более
                                                            подробное
   %A            Действие         10           Нет          описание
                                                            действия, которое
                                                            будет выполнено
                                                            над пакетом.
                                                            Если сломанных
                                                            пакетов нет, не
                                                            выводит ничего. В
                 Счетчик                                    противном случае,
   %B            сломанных        12           Нет          вызывает строку
                 пакетов                                    вида «Сломано:
                                                            10»,
                                                            характеризующую
                                                            число сломанных
                                                            пакетов.
                                                            Флаги в один
                                                            символ длинной,
                                                            резюмирующие
                 Флаг текущего                              текущее состояние
   %c            состояния        1            Нет          пакета, описание
                                                            в Рисунок 2.9,
                                                            «Значения флага
                                                            «текущее
                                                            состояние»».
                 Текущее                                    Более подробное
   %C            состояние        11           Нет          описание текущего
                                                            состояния пакета.
   %d            Описание         40           Да           Короткое описание
                                                            пакета.
                                                            Размер пакетного
   %D            Размер пакета    8            Нет          файла,
                                                            содержащего
                                                            пакет.
                                                            Имя компьютера,
   %H            Имя узла         15           Нет          на котором
                                                            запущен aptitude.
                                                            Отображает
                                                            наивысший
                                                            приоритет,
                                                            назначенный
                                                            версии пакета;
   %i            Pin-приоритет    4            Нет          для пакетов,
                                                            отображает
                                                            приоритет версии,
                                                            которая будет
                                                            установлена (если
                                                            таковая имеется).
                 Размер в                                   (Предполагаемое)
   %I            установленном    8            Нет          количество места,
                 виде                                       занимаемое
                                                            пакетом на диске.
   %m            Сопровождающий   30           Да           Сопровождающий
                                                            пакета.
                                                            Если пакет
                                                            установлен
                 Флаг                                       автоматически,
   %M            автоматической   1            Нет          выводит «A»; в
                 установки                                  противном случае,
                                                            не выводит
                                                            ничего.
                                                            Выводит версию
                                                            aptitude,
   %n            Версия программы Длина        Нет          работающую в
                                  «0.6.11».                 настоящий момент,
                                                            в настоящее время
                                                            «0.6.11».
                                                            Выводит имя
   %N            Имя программы    Длина имени. Нет          программы; обычно
                                                            «aptitude».
                                                            Если ни один
                                                            пакет не будет
                                                            установлен, не
                                                            выводит ничего. В
                                                            противном случае,
                                                            выводит строку,
                                                            характеризующую
                 Размер для                                 общий размер всех
   %o            загрузки         17           Нет          пакетных файлов,
                                                            которые будут
                                                            установлены
                                                            (приблизительный
                                                            подсчет того,
                                                            сколько должно
                                                            быть загружено);
                                                            например, «DL
                                                            размер: 1000B».
                                                            Выводит имя
                                                            пакета. Когда
                                                            пакет
                                                            отображается в
                                                            контексте дерева,
                                                            имя пакета будет
   %p            Имя пакета       30           Да           выделено
                                                            отступом, если
                                                            это возможно, в
                                                            соответствии с
                                                            глубиной его
                                                            положения в
                                                            дереве.
   %P            Приоритет        9            Нет          Выводит приоритет
                                                            пакета.
                                                            Выводит
                                                            приблизительное
                 Число обратных                             число
   %r            зависимостей     2            Нет          установленных
                                                            пакетов,
                                                            зависящих от
                                                            данного пакета.
                                                            Выводит
                                                            сокращенное
                                                            описание
   %R            Приоритет в      3            Нет          приоритета
                 сокращенном виде                           пакета: например,
                                                            «Important»
                                                            заменяется на
                                                            «Imp».
   %s            Раздел           10           Нет          Выводит раздел
                                                            пакета.
                                                            Если пакет
   %S            Статус доверия   1            Нет          ненадежен,
                                                            отображает символ
                                                            "U".
   %t            Архив            10           Да           Архив, в котором
                                                            находится пакет.
                                                            Выводит «*», если
                                                            пакет отмечен
   %T            Отмеченный тегом 1            Нет          тегом, в
                                                            противном случае
                                                            не выводит
                                                            ничего.^[19]
                                                            Если
                                                            запланированные
                                                            действия изменят
                                                            количество места
                                                            на диске, выводит
                 Изменение                                  характеристику
   %u            использования    30           Нет          изменения
                 диска                                      дискового
                                                            пространства;
                                                            например, «Будет
                                                            использовано
                                                            100MB дискового
                                                            пространства.»
                                                            Выводит версию
                                                            пакета,
                                                            установленную в
   %v            Текущая версия   14           Нет          настоящий момент,
                                                            либо выводит
                                                            <none>, если
                                                            пакет не
                                                            установлен.
                                                            Выводит версию
                                                            пакета, которая
                                                            была бы
                                                            установлена, если
                                                            бы была выполнена
   %V            Версия-кандидат  14           Нет          команда Пакет →
                                                            Установить (+) на
                                                            данном пакете,
                                                            либо выводит
                                                            <none>, если
                                                            пакет в настоящее
                                                            время недоступен.
                                                            Выводит
                                                            количество
                                                            дополнительного
                                                            дискового
                 Изменение                                  пространства,
   %Z            размера          9            Нет          которое будет
                                                            использовано,
                                                            либо освобождено
                                                            установкой,
                                                            обновлением или
                                                            удалением пакета.

    Настройка иерархии пакетов

   Иерархия пакетов создаётся политикой группировки: правилами, описывающими
   то, как должна строится иерархия. Политика группировки описывает
   «конвейер» правил; каждое правило может отбрасывать пакеты, создавать
   иерархии нижнего уровня, внутрь которых помещаются пакеты, или, в
   противном случае, управлять деревом пакетов. Пункты настройки
   Aptitude::UI::Default-Grouping и Aptitude::UI::Default-Preview-Grouping
   устанавливают политики группировки для заново создаваемых списков пакетов
   и, соответственно, экранов предварительного просмотра. Вы можете
   установить политики группировки для текущего списка пакетов, нажав G.

   Политики группировки описываются списком правил, разделенных запятыми:
   правило1,правило2,.... Каждое правило состоит из имени правила, за
   которым, возможно, следуют аргументы: например, версии или
   раздел(подкаталог). Требуются ли аргументы и то, сколько их требуется
   (либо возможно), зависит от типа правила.

   Правила могут быть нетерминальными или терминальными. Нетерминальное
   правило обработает пакет, создав некоторую часть иерархии, и передаст
   потом пакет следующему правилу. Терминальное правило, с другой стороны,
   также создаст часть дерева (обычно пункты, соответствующие пакетам), но не
   передаст после этого пакет следующему правилу. Если ни одно терминальное
   правило не определено, aptitude будет использовать правило по-умолчанию,
   которое должно создать стандартные «пакетные пункты».

 action

           Группирует пакеты соответственно действию, запланированному для
           выполнения на них; пакеты, которые не могут быть обновлены и
           останутся неизменёнными, будут проигнорированы. Это группировка,
           использующаяся в деревьях предварительного просмотра.

 architecture

           Группирует пакеты согласно их архитектуре.

 deps

           Это терминальное правило.

           Создает стандартный пакетный объект, который может быть расширен
           для обнаружения зависимостей этого пакета.

 filter(шаблон)

           Включить только пакеты, для которых по меньшей мере одна версия
           соответствует шаблону.

           Если шаблон «отсутствует», ни один пакет не будет отброшен. Эта
           особенность нужна для обратной совместимости и может быть удалена
           в будущем.

 firstchar

           Группирует пакет, основываясь на первом символе их имени.

 hier

           Группирует пакеты, согласно дополнительному файлу данных,
           описывающему «иерархию» пакетов.

 pattern(шаблон [=> заголовок] [{ правило }] [, ...])

           Настраиваемая политика группировки. Каждая версия всякого пакета
           проверяется относительно данного шаблона. Первое найденное
           соответствие используется для того, чтобы назначить заголовок
           пакету; затем пакеты группируются по их заголовкам. Строки вида
           \N, встречающиеся в заголовке будут удалены N-ым результатом
           соответствия. Если заголовок отсутствует, считается, что он равен
           \1. Заметьте, что пакеты, которые не соответствуют ни одному
           шаблону вообще не будут отображены в дереве.

           Пример 2.7. Использование pattern для группировки пакетов по
           сопровождающему

           pattern(?maintainer() => \1)

           Пример, приведенный выше группирует пакеты согласно их полю
           Сопровождающий. Правило pattern(?maintainer()) сделает то же
           самое, так как отсутствующий параметр title по-умолчанию
           принимается равным \1.

           Вместо => заголовок, запись может заканчиваться ||. Это
           показывает, что пакеты, подпадающие под соответствующий шаблон
           будут вставлены в дерево того же уровня, что группирующий шаблон,
           а не будут помещены в поддеревья.

           Пример 2.8. Использование pattern с некоторыми пакетами,
           помещенными на верхний уровень

           шаблон(?action(remove) => Удаляемые пакеты, ?true ||)

           Пример выше помещает удаляемые пакеты в поддерево, а остальные
           пакеты помещает на текущем уровне, группируя согласно правилам,
           следующим за шаблоном.

           По-умолчанию все пакеты, соответствующие каждому шаблону
           группируются согласно правилам, которые следуют за политикой
           pattern. Чтобы определить отличную политику для некоторых пакетов,
           введите эту политику в скобки ({}) после заголовка группы, после
           ||, или после шаблона, если и то, и другое отсутствует. Например:

           Пример 2.9. Использование политики группировки pattern с
           подполитиками

           pattern(?action(remove) => Удаляемые пакеты {}, ?action(install)
           => Устанавливаемые пакеты, ?true || {status})

           Политика, приведенная в примере выше, имеет следующие результаты:

              * Удаляемые пакеты помещаются в поддерево, обозначенное
                «Удаляемые пакеты»; политика группировки для этого поддерева
                пуста, поэтому пакеты помещаются в него в виде обычного
                списка.

              * Устанавливаемые пакеты помещаются в поддерево, обозначенное
                Устанавливаемые пакеты и группируются согласно политикам,
                следующим за pattern.

              * Все оставшиеся пакеты помещаются на верхний уровень дерева и
                группируются в соответствии с их статусом.

           Дополнительную информацию о формате pattern см. в разделе
           «Поисковые шаблоны» .

 priority

           Группирует пакеты согласно их приоритету.

 section[(режим[,passthrough])]

           Группирует пакеты согласно их полю Раздел

           режим может быть одним из следующих:

                none

                        Группа основывается на всем поле Раздел, поэтому
                        будут созданы такие категории как «non-free/games».
                        Если режим не определен, данный режим используется по
                        умолчанию.

                topdir

                        Группа основывается на части поля Раздел до первого
                        символа /; если эта часть Раздела не распознана, или
                        если её нет /, будет использоваться первая запись в
                        списке Aptitude::Sections::Top-Sections.

                subdir

                        Группа основывается на части поля Раздел после
                        первого символа /, если она содержится в списке
                        Aptitude::Sections::Top-Sections. Если же нет, или
                        если отсутствует /, группа основывается на всем поле
                        Раздел.

                subdirs

                        Группа основывается на части поля Раздел после
                        первого символа /, если часть поля, предшествующая ей
                        содержится в списке Aptitude::Sections::Top-Sections;
                        если нет, или если отсутствует /, используется все
                        поле. Если имеют место несколько символов / в части
                        используемого поля, будет сформирована иерархия
                        групп. Например, если «games» не является членом
                        Aptitude::Sections::Top-Sections, то пакеты с
                        разделом «games/arcade» будут помещены подзаголовок
                        высшего уровня «games», в подраздел, названный
                        «arcade».

           Если имеет место passthrough, пакеты, которые по какой-то причине
           не имеют действительного Раздела (например, виртуальные пакеты),
           будут переданы напрямую следующему уровню группировки без
           размещения их по подкатегориям.

 status

           Группирует пакеты по следующим категориям:

              * Обновления, связанные с безопасностью

              * Обновляемые

              * Новый

              * Установленные

              * Не установленные

              * Устаревшие и пакеты, созданные локально

              * Виртуальные

 source

           Группирует пакеты, согласно имени пакета с исходным кодом.

 tag[(аспект)]

           Группирует пакеты в соответствии с теговой информацией, хранящейся
           в пакетных файлах Debian. Если задан аспект, то будут отображены
           только теги, соответствующие этому аспекту, а пакеты, не имеющие
           этого аспекта, будут скрыты; в противном случае, все пакеты будут
           отображены по меньшей мере один раз (безтеговым списком пакетов
           отдельно от пакетов, имеющих теги).

           Дополнительную информацию о debtags см. на
           http://debtags.alioth.debian.org.

 task

           Создает дерево с названием «Задачи», содержащее доступные задачи
           (информация о задачах считывается из файла debian-tasks.desc в
           пакете tasksel). Правило, следующее за задачей создает категорию
           задачи в качестве потомка дерева Задач.

 versions

           Это терминальное правило.

           Создает стандартный пакетный объект, который может быть расширен
           для показа версий пакета.

    Настройка того, как сортируются пакеты

   По-умолчанию пакеты в списке пакетов или в выводе команды aptitude search
   сортируются по имени. Тем не менее, часто полезно сортировать их в
   соответствии с другими критериями (например, размером пакета), и aptitude
   позволяет вам это делать путем изменения политики сортировки.

   Подобно политике группировки, описанной в предыдущем разделе, политика
   сортировки представляет собой список, в котором элементы разделены
   запятыми. Каждый объект в списке является именем правила сортировки; если
   пакеты «идентичны» согласно первому правилу, используется второе правило
   для сортировки этих пакетов, и так далее. Помещение символа тильды (~)
   перед правилом, обращает обычное значение этого правила. Например,
   priority,~name отсортирует пакеты по приоритету, но пакеты с одним и тем
   же приоритетом будут помещены в обратом порядке относительно имени.

   Чтобы изменить политику сортировки активного списка пакетов, нажмите S.
   Чтобы изменить сортировку по-умолчанию для всех списков пакетов,
   установите опцию настройки Aptitude::UI::Default-Sorting. Чтобы изменить
   политику сортировки aptitude search, используйте опцию командной строки
   --sort.

   Доступные правила таковы:

   installsize

           Сортирует пакеты по приблизительному размеру, необходимому после
           установки.

   installsizechange

           Sorts packages by the change in the installed size (estimated
           amount of size required when installed), comparing the current
           version (if installed) and the candidate version to be installed,
           upgraded or removed.

   debsize

           Sorts packages by the size of the package.

   name

           Сортирует пакеты по имени.

   priority

           Сортирует пакеты по приоритету.

   version

           Сортирует пакеты согласно номеру их версии.

  Настройка привязки клавиш

   Клавиши, используемые для активации команд в aptitude могут быть настроены
   в файле настроек. У каждой команды есть ассоциированная с ней переменная
   настройки под Aptitude::UI::Keybindings; чтобы изменить сочетание клавиш,
   привязанное к команде, просто установите соответствующей переменной это
   сочетание клавиш в качестве значения. Например, чтобы привязать клавишу s
   к команде поиска, установите Aptitude::UI::Keybindings::Search значение
   «s». Вы можете потребовать нажатия клавиши Control, поместив «C-» перед
   клавишей: например, использование «C-s» вместо «s» привяжет Поиск к
   Control+s, а не к s. Наконец, вы можете привязать команду к нескольким
   клавишам одновременно, используя список, элементы которого разделены
   запятыми: например, использование «s,C-s» приведёт к тому, что и клавиша
   s, и сочетание клавиш Control+s будут выполнять поиск.

   Следующие команды могут быть привязаны к клавишам путем установки
   переменной Aptitude::UI::Keybindings::команда, где командой является имя
   команды, которую вы желаете привязать к клавише:

   +------------------------------------------------------------------------+
   |        Команда         |  По-умолчанию   |          Описание           |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Если пакеты сломаны, и      |
   | ApplySolution          | !               | aptitude предлагает решение |
   |                        |                 | проблемы, немедленно        |
   |                        |                 | применить это решение.      |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Перейти к началу текущего   |
   | Begin                  | home,C-a        | экрана: в верх списка или в |
   |                        |                 | левую часть текстового      |
   |                        |                 | поля.                       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отправляет отчет об ошибке  |
   | BugReport              | B               | в выбранном пакете,         |
   |                        |                 | используя reportbug.        |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отменяет текущее            |
   | Cancel                 | C-g,escape,C-[  | взаимодействие: например,   |
   |                        |                 | закрывает диалог или        |
   |                        |                 | деактивирует меню.          |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отображает файл             |
   | Changelog              | C               | changelog.Debian выбранного |
   |                        |                 | пакета или версии пакета.   |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Изменяет правило            |
   | ChangePkgTreeGrouping  | G               | группировки текущего        |
   |                        |                 | активного списка пакетов.   |
   |------------------------+-----------------+-----------------------------|
   | ChangePkgTreeLimit     | l               | Изменяет предел текущего    |
   |                        |                 | активного списка пакетов.   |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Изменяет правило сортировки |
   | ChangePkgTreeSorting   | S               | текущего активного списка   |
   |                        |                 | пакетов.                    |
   |------------------------+-----------------+-----------------------------|
   | ClearAuto              | m               | Отмечает выбранный пакет    |
   |                        |                 | как установленный вручную.  |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Сворачивает выбранное       |
   | CollapseAll            | ]               | дерево и всех его детей в   |
   |                        |                 | иерархическом списке.       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Сворачивает выбранное       |
   | CollapseTree           | Нет привязки.   | дерево в иерархическом      |
   |                        |                 | списке.                     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В иерархическом редакторе   |
   |                        |                 | сохраняет позицию текущего  |
   | Commit                 | N               | пакета в иерархии и         |
   |                        |                 | переходит к следующему      |
   |                        |                 | пакету.                     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В диалогах это эквивалентно |
   |                        |                 | нажатию «Ok»; при           |
   |                        |                 | взаимодействии со строкой   |
   | Confirm                | enter           | статуса с несколькими       |
   |                        |                 | вариантами выбора ответа на |
   |                        |                 | вопрос, выбирает опцию      |
   |                        |                 | по-умолчанию.               |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Переключает ввод с          |
   | Cycle                  | tab             | клавиатуры на следующий     |
   |                        |                 | «графический элемент».      |
   |------------------------+-----------------+-----------------------------|
   | CycleNext              | f6              | Переключает на следующее    |
   |                        |                 | активное окно.              |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Переключает между           |
   | CycleOrder             | o               | предопределенными           |
   |                        |                 | компоновками экрана.        |
   |------------------------+-----------------+-----------------------------|
   | CyclePrev              | f7              | Переключает на предыдущее   |
   |                        |                 | активное окно.              |
   |------------------------+-----------------+-----------------------------|
   | DelBOL                 | C-u             | Удаляет весь текст между    |
   |                        |                 | курсором и началом строки.  |
   |------------------------+-----------------+-----------------------------|
   | DelBack                | backspace,C-h   | Удаляет предыдущий символ   |
   |                        |                 | при вводе текста.           |
   |------------------------+-----------------+-----------------------------|
   | DelEOL                 | C-k             | Удаляет весь текст от       |
   |                        |                 | курсора и до конца строки.  |
   |------------------------+-----------------+-----------------------------|
   | DelForward             | delete,C-d      | Удаляет символ под курсором |
   |                        |                 | при вводе текста.           |
   |------------------------+-----------------+-----------------------------|
   | Dependencies           | d               | Отображает зависимости      |
   |                        |                 | выбранного пакета.          |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | При просмотре списка        |
   | DescriptionCycle       | i               | пакетов, переключает между  |
   |                        |                 | доступными окнами в         |
   |                        |                 | информационной области.     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | При просмотре списка        |
   | DescriptionDown        | z               | пакетов, прокручивает       |
   |                        |                 | информационную область вниз |
   |                        |                 | на одну строку.             |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | При просмотре списка        |
   | DescriptionUp          | a               | пакетов, прокручивает       |
   |                        |                 | информационную область      |
   |                        |                 | вверх на одну строку.       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Если окно предварительного  |
   |                        |                 | просмотра не отображается,  |
   |                        |                 | то отображает его ^[a];     |
   | DoInstallRun           | g               | если окно предварительного  |
   |                        |                 | просмотра открыто,          |
   |                        |                 | выполняет установочный      |
   |                        |                 | запуск.                     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Перемещается ниже:          |
   | Down                   | down,j          | например, прокручивает      |
   |                        |                 | текст вниз или выбирает     |
   |                        |                 | следующий объект в списке.  |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Запускает                   |
   | DpkgReconfigure        | R               | «dpkg-reconfigure» для      |
   |                        |                 | выбранного пакете.          |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Если пакеты сломаны,        |
   | DumpResolver           | *               | записывает текущее          |
   |                        |                 | состояние решателя проблем  |
   |                        |                 | в файл (для целей отладки). |
   |------------------------+-----------------+-----------------------------|
   | EditHier               | E               | Открывает редактор          |
   |                        |                 | иерархии.                   |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Переходит к концу текущего  |
   | End                    | end,C-e         | экрана: в низ списка или в  |
   |                        |                 | правую часть текстового     |
   |                        |                 | поля.                       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Если некоторые пакеты       |
   |                        |                 | сломаны, и aptitude         |
   | ExamineSolution        | e               | предлагает решение,         |
   |                        |                 | отображает диалог с         |
   |                        |                 | детальным описанием         |
   |                        |                 | предложенного решения.      |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Открывает выбранное дерево  |
   | ExpandAll              | [               | и всех его детей в          |
   |                        |                 | иерархическом списке.       |
   |------------------------+-----------------+-----------------------------|
   | ExpandTree             | Нет привязки.   | Открывает выбранное дерево  |
   |                        |                 | в иерархическом списке.     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Выбирает первое решение,    |
   | FirstSolution          | <               | созданное решателем         |
   |                        |                 | проблем.                    |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Запрещает пакет для         |
   | ForbidUpgrade          | F               | обновления до текущей       |
   |                        |                 | доступной версии (или       |
   |                        |                 | определенной версии).       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Сбрасывает всю информацию о |
   |                        |                 | том, какие пакеты являются  |
   | ForgetNewPackages      | f               | «новыми» (приводит к        |
   |                        |                 | очистке списка «новых»      |
   |                        |                 | пакетов).                   |
   |------------------------+-----------------+-----------------------------|
   | Help                   | ?               | Отображает интерактивное    |
   |                        |                 | окно помощи.                |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В линейном редакторе с      |
   | HistoryNext            | down,C-n        | историей перемещается по    |
   |                        |                 | истории вперед.             |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В линейном редакторе с      |
   | HistoryPrev            | up,C-p          | историей перемещается по    |
   |                        |                 | истории назад.              |
   |------------------------+-----------------+-----------------------------|
   | Hold                   | =               | Помещает пакет на фиксацию. |
   |------------------------+-----------------+-----------------------------|
   | Install                | +               | Отмечает пакет для          |
   |                        |                 | установки.                  |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отмечает один пакет для     |
   | InstallSingle          | I               | установки; все остальные    |
   |                        |                 | пакеты сохраняются в их     |
   |                        |                 | текущих версиях.            |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отменяет все запросы        |
   | Keep                   | :               | установки или удаления и    |
   |                        |                 | все фиксации пакета.        |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Выбирает последнее решение, |
   | LastSolution           | <               | созданное решателем         |
   |                        |                 | проблем.                    |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Перемещается влево:         |
   |                        |                 | например, перемещается на   |
   | Left                   | left,h          | одно меню влево в строке    |
   |                        |                 | меню или перемещает курсор  |
   |                        |                 | влево при редактировании    |
   |                        |                 | текста.                     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В иерархическом списке      |
   |                        |                 | выбирает следующего         |
   |                        |                 | родственника выбранного в   |
   | LevelDown              | J               | текущий момент объекта      |
   |                        |                 | (выбирает следующий объект  |
   |                        |                 | на тем же уровне с тем же   |
   |                        |                 | родителем).                 |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В иерархическом списке      |
   |                        |                 | выбирает предыдущего        |
   |                        |                 | родственника выбранного в   |
   | LevelUp                | K               | текущий момент объекта      |
   |                        |                 | (выбирает предыдущий объект |
   |                        |                 | на тем же уровне с тем же   |
   |                        |                 | родителем).                 |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Пытается обновить все       |
   | MarkUpgradable         | U               | пакеты, которые не          |
   |                        |                 | зафиксированы или не        |
   |                        |                 | запрещены к обновлению.     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В минёре, помещает флаг на  |
   | MineFlagSquare         | f               | квадрат или удаляет флаг с  |
   |                        |                 | квадрата.                   |
   |------------------------+-----------------+-----------------------------|
   | MineLoadGame           | L               | Загружает игру минёр.       |
   |------------------------+-----------------+-----------------------------|
   | MineSaveGame           | S               | Сохраняет игру минёр.       |
   |------------------------+-----------------+-----------------------------|
   | MineSweepSquare        | Нет привязки.   | Очищает вокруг текущего     |
   |                        |                 | квадрата в минёре.          |
   |------------------------+-----------------+-----------------------------|
   | MineUncoverSquare      | Нет привязки.   | Открывает текущий квадрат в |
   |                        |                 | минёре                      |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Открывает текущий квадрат в |
   | MineUncoverSweepSquare | enter           | минёре если он закрыт; в    |
   |                        |                 | противном случае очищает    |
   |                        |                 | вокруг него.                |
   |------------------------+-----------------+-----------------------------|
   | NextPage               | pagedown,C-f    | Перемещает текущий экран на |
   |                        |                 | одну страницу вперёд.       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Перемещает решатель         |
   | NextSolution           | .               | зависимостей к следующему   |
   |                        |                 | решению.                    |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Эта клавиша выбирает кнопку |
   | No                     | n^[b]           | «нет» в диалогах с          |
   |                        |                 | вариантами ответа да/нет.   |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Выбирает родителя           |
   | Parent                 | ^               | выбранного объекта в        |
   |                        |                 | иерархическом списке.       |
   |------------------------+-----------------+-----------------------------|
   | PrevPage               | pageup,C-b      | Перемещает текущий экран на |
   |                        |                 | одну страницу назад.        |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Возвращает решатель         |
   | PrevSolution           | ,               | зависимостей к предыдущему  |
   |                        |                 | решению.                    |
   |------------------------+-----------------+-----------------------------|
   | Purge                  | _               | Отмечает выбранный пакет    |
   |                        |                 | для вычистки.               |
   |------------------------+-----------------+-----------------------------|
   | PushButton             | space,enter     | Активирует выбранную кнопку |
   |                        |                 | или переключает флажок.     |
   |------------------------+-----------------+-----------------------------|
   | Quit                   | q               | Закрыть текущее окно.       |
   |------------------------+-----------------+-----------------------------|
   | QuitProgram            | Q               | Выходит из программы.       |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отклонить все действия      |
   |                        |                 | решателя, которые сломали   |
   | RejectBreakHolds       |                 | бы фиксацию; эквивалентно   |
   |                        |                 | Решатель → Не ломать        |
   |                        |                 | фиксации.                   |
   |------------------------+-----------------+-----------------------------|
   | Refresh                | C-l             | Перерисовывает экран с      |
   |                        |                 | нуля.                       |
   |------------------------+-----------------+-----------------------------|
   | Remove                 | -               | Отмечает пакет для          |
   |                        |                 | удаления.                   |
   |------------------------+-----------------+-----------------------------|
   | ReInstall              | L               | Отмечает выбранный пакет    |
   |                        |                 | для переустановки.          |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Повторяет последний поиск,  |
   | RepeatSearchBack       | N               | но ищет в обратном          |
   |                        |                 | направлении.                |
   |------------------------+-----------------+-----------------------------|
   | ReSearch               | n               | Повторяет последний поиск.  |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отображает пакеты, которые  |
   | ReverseDependencies    | r               | зависят от выбранного       |
   |                        |                 | пакета.                     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Перемещается вправо:        |
   |                        |                 | например, перемещается на   |
   | Right                  | right,l         | одно меню вправо в строке   |
   |                        |                 | меню или перемещает курсор  |
   |                        |                 | вправо при редактировании   |
   |                        |                 | текста.                     |
   |------------------------+-----------------+-----------------------------|
   | SaveHier               | S               | В иерархическом редакторе   |
   |                        |                 | сохраняет текущую иерархию. |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Активирует функцию «поиска» |
   | Search                 | /               | в текущем активном элементе |
   |                        |                 | интерфейса.                 |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Активирует функцию          |
   | SearchBack             | \               | «обратного поиска» в        |
   |                        |                 | текущем активном элементе   |
   |                        |                 | интерфейса.                 |
   |------------------------+-----------------+-----------------------------|
   | SearchBroken           | b               | В дереве пакетов ищет       |
   |                        |                 | следующий сломанный пакет.  |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отмечает текущий пакет как  |
   | SetAuto                | M               | установленный               |
   |                        |                 | автоматически.              |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | В списке пакетов            |
   | ShowHideDescription    | D               | переключает видимость       |
   |                        |                 | информационной области.     |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | При просмотре решения       |
   |                        |                 | отмечает выбранное действие |
   | SolutionActionApprove  | a               | как "одобренное" (если это  |
   |                        |                 | возможно, оно будет         |
   |                        |                 | включено в будущие          |
   |                        |                 | решения).                   |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | При просмотре решения,      |
   |                        |                 | отмечает выбранное действие |
   | SolutionActionReject   | r               | как "отклоненное" (будущие  |
   |                        |                 | решения не будут содержать  |
   |                        |                 | это действие).              |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Разворачивает или           |
   | ToggleExpanded         | enter           | сворачивает выбранное       |
   |                        |                 | дерево в иерархическом      |
   |                        |                 | списке.                     |
   |------------------------+-----------------+-----------------------------|
   | ToggleMenuActive       | C-m,f10,C-space | Активирует или деактивирует |
   |                        |                 | главное меню.               |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Отменяет последнее действие |
   |                        |                 | вплоть до тех пор, когда    |
   |                        |                 | была запущена aptitude ИЛИ  |
   | Undo                   | C-_,C-u         | до вплоть момента           |
   |                        |                 | последнего обновления       |
   |                        |                 | списка пакетов или          |
   |                        |                 | установки пакетов.          |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Перемещается вверх:         |
   |                        |                 | например, прокручивает      |
   | Up                     | up,k            | текстовый экран вверх или   |
   |                        |                 | выбирает предыдущий объект  |
   |                        |                 | в списке.                   |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Обновляет список пакетов,   |
   | UpdatePackageList      | u               | загружая, если это          |
   |                        |                 | необходимо, новые списки из |
   |                        |                 | сети Интернет.              |
   |------------------------+-----------------+-----------------------------|
   | Versions               | v               | Отображает доступные версии |
   |                        |                 | выбранного пакета.          |
   |------------------------+-----------------+-----------------------------|
   |                        |                 | Эта клавиша выбирает кнопку |
   | Yes                    | y ^[b]          | «Yes» в диалогах с опциями  |
   |                        |                 | да/нет.                     |
   |------------------------------------------------------------------------|
   | ^[a] до тех пор, пока Aptitude::Display-Planned-Action ложно.          |
   |                                                                        |
   | ^[b] В разных локалях значение по-умолчанию может быть другим.         |
   +------------------------------------------------------------------------+

   В дополнение к буквенным, цифровым клавишам и клавишам пунктуации привязки
   могут быть сделаны к следующим «специальным» клавишам:

   +------------------------------------------------------------------------+
   |   Имя клавиши    |                      Описание                       |
   |------------------+-----------------------------------------------------|
   | a1               | Клавиша A1.                                         |
   |------------------+-----------------------------------------------------|
   | a3               | Клавиша A3.                                         |
   |------------------+-----------------------------------------------------|
   | b2               | Клавиша B2.                                         |
   |------------------+-----------------------------------------------------|
   | backspace        | Клавиша Backspace.                                  |
   |------------------+-----------------------------------------------------|
   | backtab          | Клавиша обратной табуляции                          |
   |------------------+-----------------------------------------------------|
   | begin            | Клавиша Begin (не Home)                             |
   |------------------+-----------------------------------------------------|
   | break            | Клавиша «break».                                    |
   |------------------+-----------------------------------------------------|
   | c1               | Клавиша C1.                                         |
   |------------------+-----------------------------------------------------|
   | c3               | Клавиша C3.                                         |
   |------------------+-----------------------------------------------------|
   | cancel           | Клавиша Cancel.                                     |
   |------------------+-----------------------------------------------------|
   | create           | Клавиша Create.                                     |
   |------------------+-----------------------------------------------------|
   |                  | Запятая (,) — заметьте, что поскольку запятые       |
   | comma            | используются в списках клавиш, это — единственный   |
   |                  | способ сделать привязку к запятой.                  |
   |------------------+-----------------------------------------------------|
   | command          | Клавиша Command.                                    |
   |------------------+-----------------------------------------------------|
   | copy             | Клавиша Copy.                                       |
   |------------------+-----------------------------------------------------|
   | delete           | Клавиша Delete.                                     |
   |------------------+-----------------------------------------------------|
   | delete_line      | Клавиша «delete line».                              |
   |------------------+-----------------------------------------------------|
   | down             | Клавиша «стрелка вниз».                             |
   |------------------+-----------------------------------------------------|
   | end              | Клавиша End.                                        |
   |------------------+-----------------------------------------------------|
   | entry            | Клавиша Enter.                                      |
   |------------------+-----------------------------------------------------|
   | exit             | Клавиша Exit.                                       |
   |------------------+-----------------------------------------------------|
   | f1, f2, ..., f10 | Клавиши с F1 до F10.                                |
   |------------------+-----------------------------------------------------|
   | find             | Клавиша Find.                                       |
   |------------------+-----------------------------------------------------|
   | home             | Клавиша Home.                                       |
   |------------------+-----------------------------------------------------|
   | insert           | Клавиша Insert.                                     |
   |------------------+-----------------------------------------------------|
   | insert_exit      | Клавиша «insert exit».                              |
   |------------------+-----------------------------------------------------|
   | clear            | Клавиша «clear».                                    |
   |------------------+-----------------------------------------------------|
   | clear_eol        | Клавиша «clear to end of line».                     |
   |------------------+-----------------------------------------------------|
   | clear_eos        | Клавиша «clear to end of screen».                   |
   |------------------+-----------------------------------------------------|
   | insert_line      | Клавиша «insert line».                              |
   |------------------+-----------------------------------------------------|
   | left             | Клавиша «стрелка влево».                            |
   |------------------+-----------------------------------------------------|
   | mark             | Клавиша Mark.                                       |
   |------------------+-----------------------------------------------------|
   | message          | Клавиша Message.                                    |
   |------------------+-----------------------------------------------------|
   | move             | Клавиша Move.                                       |
   |------------------+-----------------------------------------------------|
   | next             | Клавиша Next.                                       |
   |------------------+-----------------------------------------------------|
   | open             | Клавиша Open.                                       |
   |------------------+-----------------------------------------------------|
   | previous         | Клавиша Previous.                                   |
   |------------------+-----------------------------------------------------|
   | print            | Клавиша Print.                                      |
   |------------------+-----------------------------------------------------|
   | redo             | Клавиша Redo.                                       |
   |------------------+-----------------------------------------------------|
   | reference        | Клавиша Reference.                                  |
   |------------------+-----------------------------------------------------|
   | refresh          | Клавиша Refresh.                                    |
   |------------------+-----------------------------------------------------|
   | replace          | Клавиша Replace.                                    |
   |------------------+-----------------------------------------------------|
   | restart          | Клавиша Restart.                                    |
   |------------------+-----------------------------------------------------|
   | resume           | Клавиша Resume.                                     |
   |------------------+-----------------------------------------------------|
   | return           | Клавиша Return.                                     |
   |------------------+-----------------------------------------------------|
   | right            | Клавиша «стрелка вправо».                           |
   |------------------+-----------------------------------------------------|
   | save             | Клавиша Save.                                       |
   |------------------+-----------------------------------------------------|
   | scrollf          | Клавиша «scroll forward».                           |
   |------------------+-----------------------------------------------------|
   | scrollr          | Клавиша «scroll backwards».                         |
   |------------------+-----------------------------------------------------|
   | select           | Клавиша Select.                                     |
   |------------------+-----------------------------------------------------|
   | suspend          | Клавиша Suspend.                                    |
   |------------------+-----------------------------------------------------|
   | pagedown         | Клавиша «Page Down».                                |
   |------------------+-----------------------------------------------------|
   | pageup           | Клавиша «Page Up».                                  |
   |------------------+-----------------------------------------------------|
   | space            | Клавиша пробел.                                     |
   |------------------+-----------------------------------------------------|
   | tab              | Клавиша Tab.                                        |
   |------------------+-----------------------------------------------------|
   | undo             | Клавиша Undo.                                       |
   |------------------+-----------------------------------------------------|
   | up               | Клавиша «стрелка вверх».                            |
   +------------------------------------------------------------------------+

   В дополнение к глобальным привязкам клавиш можно изменять привязки клавиш
   для определенной части (или области) aptitude: например, чтобы сделать
   клавишу Tab эквивалентной стрелке вправо в строке меню, установите
   Aptitude::UI::Keybindings::Menubar::Right в значение «tab,right». Доступны
   следующие области:

   +------------------------------------------------------------------------+
   |    Область    |                        Описание                        |
   |---------------+--------------------------------------------------------|
   |               | Используется графическими элементами линейного         |
   | EditLine      | редактирования, такими как поле ввода в диалоге        |
   |               | «поиск».                                               |
   |---------------+--------------------------------------------------------|
   | Menu          | Используется выпадающими меню.                         |
   |---------------+--------------------------------------------------------|
   | Menubar       | Используется строкой меню в верхней части экрана.      |
   |---------------+--------------------------------------------------------|
   | Minesweeper   | Используется в режиме сапёр.                           |
   |---------------+--------------------------------------------------------|
   |               | Используется приглашениями с несколькими опциями,      |
   | MinibufChoice | появляющимися в том случае, если вы выбрали            |
   |               | возможность появления некоторых приглашений в строке   |
   |               | статуса.                                               |
   |---------------+--------------------------------------------------------|
   | Pager         | Используется когда отображается файл на диске          |
   |               | (например, текст справки).                             |
   |---------------+--------------------------------------------------------|
   |               | Используется пакетами, деревьями пакетов, версиями     |
   | PkgNode       | пакетов и зависимостями пакетов, когда они появляются  |
   |               | в списке пакетов.                                      |
   |---------------+--------------------------------------------------------|
   | PkgTree       | Используется списком пакетов.                          |
   |---------------+--------------------------------------------------------|
   | Table         | Используется таблицей графических элементов (например, |
   |               | диалогами).                                            |
   |---------------+--------------------------------------------------------|
   | TextLayout    | Используется форматированными текстовыми экранами,     |
   |               | такими как описание пакета.                            |
   |---------------+--------------------------------------------------------|
   |               | Используется всеми экранами деревьев (включая список   |
   | Tree          | пакетов, для которого эта опция может быть отменена    |
   |               | опцией PkgTree).                                       |
   +------------------------------------------------------------------------+

  Настройка цветов и стилей текста

   Цвета и визуальные стили, используемые aptitude для отображения текста,
   могут быть в значительной степени изменены. Каждый визуальный элемент
   имеет ассоциированный «стиль», который описывает определенные цвета и
   визуальные атрибуты, используемые для отображения этого элемента. Стили
   имеют вид списка, содержащего цвет и параметры атрибутов. Этот список не
   является с необходимостью полным; если некоторые цвета или атрибуты не
   определены явным образом, их значения будут взяты из окружающего
   визуального контекста. Фактически, большинство визуальных элементов имеют
   по-умолчанию «пустой» стиль.

   Вы можете изменить содержание стиля, создав группу настройки с тем же
   именем в файле настроек apt или aptitude. Например, стиль «MenuBorder»
   используется для отрисовки визуальной границы вокруг выпадающих меню.
   По-умолчанию эта граница рисуется толстой линией и белым цветом на синем.
   Помещение следующего текста в файл настроек изменит цвет на белый на
   голубом:

 Aptitude::UI::Styles {
   MenuBorder {fg white; bg cyan; set bold;};
 };

   Как вы можете видеть, группы настройки стилей состоят из
   последовательностей инструкций. Общими классами инструкций являются
   следующие:

   fg цвет

           Устанавливает тексту данный цвет. Список цветов, известных
           aptitude, см. ниже.

   bg цвет

           Устанавливает фону текста данный цвет. Список цветов, известных
           aptitude, см. ниже.

   set атрибут

           Включает данный текстовый атрибут. список текстовых атрибутов,
           известных aptitude, см. ниже.

   clear атрибут

           Отключает данный текстовый атрибут. Список текстовых атрибутов,
           известных aptitude, см. ниже.

   flip атрибут

           Переключает данный текстовый атрибут: если он включён в окружающем
           элементе, он будет отключён, и наоборот. Список текстовых
           атрибутов, известных aptitude, см. ниже.

   Цвета, распознаваемые aptitude: black (чёрный), blue (синий), cyan
   (голубой), green (зелёный), magenta (пурпурный), red (красный), white
   (белый), и yellow (жёлтый) ^[20]. Дополнительно вы можете установить
   значение default (по-умолчанию) вместо цвета фона, чтобы использовать фон
   терминала по-умолчанию (это может быть цвет по-умолчанию, файл изображения
   или даже «transparent» (прозрачность)). Стили, распознаваемые aptitude:

   blink

           Включает мигающий текст.

   bold

           Делает цвет текста (или цвет фон, если включено reverse video)
           ярче.

   dim

           Может привести к очень тусклому тексту на некоторых терминалах. В
           обычных Linux-терминалах эффект не наблюдался.

   reverse

           Меняет цвет текста и цвет фона местами. Многие визуальные элементы
           используют этот атрибут для выполнения обычных задач
           подсвечивания.

   standout

           Это включает «лучший способ выделения в данном терминале». В
           xterms это схоже, но не идентично с, обратным видео; поведение на
           других терминалах может отличаться.

   underline

           Включает подчёркнутый текст.

   Вы можете выбрать несколько атрибутов одновременно, разделяя их запятыми;
   например, set bold,standout;.

   [Primechanie] Примечание
                 Как указано выше, интерпретация и стилей, и текстовых
                 атрибутов сильно зависит от терминала. Может быть вам
                 потребуется поэкспериментировать немного, чтобы найти те
                 настройки, которые работают на вашем терминале.

   Следующие стили могут быть настроены в aptitude:

   Рисунок 2.14. Настраиваемые стили aptitude

 +-----------------------------------------------------------------------------+
 |          Стиль           | По-умолчанию  |             Описание             |
 |--------------------------+---------------+----------------------------------|
 |Bullet                    |fg yellow; set |Стиль маркеров в маркерных        |
 |                          |bold;          |списках.                          |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль более новых версий пакета   |
 |                          |               |при просмотре changelog. Заметьте,|
 |ChangelogNewerVersion     |set bold;      |что aptitude подсвечивает лишь    |
 |                          |               |более новые версии пакета, если у |
 |                          |               |вас установлен пакет              |
 |                          |               |libparse-debianchangelog-perl.    |
 |--------------------------+---------------+----------------------------------|
 |Default                   |fg white; bg   |Базовый стиль экрана.             |
 |                          |black;         |                                  |
 |--------------------------+---------------+----------------------------------|
 |DepBroken                 |fg black; bg   |Стиль неудовлетворённых           |
 |                          |red;           |зависимостей.                     |
 |--------------------------+---------------+----------------------------------|
 |                          |fg black; bg   |Стиль отключённых пунктов меню,   |
 |DisabledMenuEntry         |blue; set dim; |которые не могут быть             |
 |                          |               |использованы.                     |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль, используемый для           |
 |                          |fg black; bg   |обозначения того, что файл был    |
 |DownloadHit               |green;         |«взят из кэша»: то есть, он не был|
 |                          |               |изменён с последнего раза его     |
 |                          |               |загрузки.                         |
 |--------------------------+---------------+----------------------------------|
 |DownloadProgress          |fg blue; bg    |Стиль индикатора прогресса        |
 |                          |yellow;        |загрузки.                         |
 |--------------------------+---------------+----------------------------------|
 |                          |fg white; bg   |Стиль линейных редакторов         |
 |EditLine                  |black; clear   |(например, ввода в диалоге        |
 |                          |reverse;       |«Поиск»).                         |
 |--------------------------+---------------+----------------------------------|
 |Error                     |fg white; bg   |Стиль сообщений об ошибках.       |
 |                          |red; set bold; |                                  |
 |--------------------------+---------------+----------------------------------|
 |Header                    |fg white; bg   |Стиль заголовка экрана.           |
 |                          |blue; set bold;|                                  |
 |--------------------------+---------------+----------------------------------|
 |                          |fg white; bg   |Стиль выбранного в данный момент  |
 |HighlightedMenuBar        |blue; set      |имени меню в строке меню.         |
 |                          |bold,reverse;  |                                  |
 |--------------------------+---------------+----------------------------------|
 |                          |fg white; bg   |Стиль выбранного в данный момент  |
 |HighlightedMenuEntry      |blue; set      |пункта меню.                      |
 |                          |bold,reverse;  |                                  |
 |--------------------------+---------------+----------------------------------|
 |MediaChange               |fg yellow; bg  |Стиль диалога с запросом о вставке|
 |                          |red; set bold; |нового CD.                        |
 |--------------------------+---------------+----------------------------------|
 |MenuBar                   |fg white; bg   |Стиль строки меню.                |
 |                          |blue; set bold;|                                  |
 |--------------------------+---------------+----------------------------------|
 |MenuBorder                |fg white; bg   |Стиль границ, окружающих          |
 |                          |blue; set bold;|выпадающее меню.                  |
 |--------------------------+---------------+----------------------------------|
 |MenuEntry                 |fg white; bg   |Стиль каждого пункта в выпадающем |
 |                          |blue;          |меню.                             |
 |--------------------------+---------------+----------------------------------|
 |MineBomb                  |fg red; set    |Стиль бомб в сапёре.              |
 |                          |bold;          |                                  |
 |--------------------------+---------------+----------------------------------|
 |MineBorder                |set bold;      |Стиль границы, нарисованной вокруг|
 |                          |               |доски сапёра.                     |
 |--------------------------+---------------+----------------------------------|
 |MineFlag                  |fg red; set    |Стиль флагов в сапёре.            |
 |                          |bold;          |                                  |
 |--------------------------+---------------+----------------------------------|
 |MineNumberN               |Various        |Стиль числа N в сапёре; N может   |
 |                          |               |принимать значение от 0 до 8.     |
 |--------------------------+---------------+----------------------------------|
 |                          |fg white; bg   |Цвет, используемый для отображения|
 |MultiplexTab              |blue;          |«вкладок», отличных от выбранной в|
 |                          |               |настоящий момент вкладки.         |
 |--------------------------+---------------+----------------------------------|
 |                          |fg blue; bg    |Цвет, используемый для отображения|
 |MultiplexTabHighlighted   |white;         |выбранной в настоящий момент      |
 |                          |               |«вкладки».                        |
 |--------------------------+---------------+----------------------------------|
 |                          |fg red; flip   |Стиль пакетов, имеющих            |
 |PkgBroken                 |reverse;       |неудовлетворенные зависимости, в  |
 |                          |               |списке пакетов.                   |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль подсвеченных пакетов,       |
 |PkgBrokenHighlighted      |fg red;        |имеющих неудовлетворенные         |
 |                          |               |зависимости, в списке пакетов.    |
 |--------------------------+---------------+----------------------------------|
 |PkgNotInstalled           |               |Стиль неустановленных пакетов,    |
 |                          |               |которые не будут установлены.     |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль подсвеченных неустановленных|
 |PkgNotInstalledHighlighted|               |пакетов, которые не будут         |
 |                          |               |установлены.                      |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль установленных пакетов, для  |
 |PkgIsInstalled            |set bold;      |которых не запланировано          |
 |                          |               |выполнение каких-либо действий.   |
 |--------------------------+---------------+----------------------------------|
 |                          |set bold; flip |Стиль подсвеченных установленных  |
 |PkgIsInstalledHighlighted |reverse;       |пакетов, для которых не           |
 |                          |               |запланировано каких-либо действий.|
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль пакетов в списке пакетов,   |
 |PkgToDowngrade            |set bold;      |которым будут установлены более   |
 |                          |               |ранние версии.                    |
 |--------------------------+---------------+----------------------------------|
 |                          |set bold; flip |Стиль подсвеченных пакетов,       |
 |PkgToDowngradeHighlighted |reverse        |которым будут установлены более   |
 |                          |               |ранние версии.                    |
 |--------------------------+---------------+----------------------------------|
 |PkgToHold                 |fg white; flip |Стиль пакетов в списке пакетов,   |
 |                          |reverse;       |которые находятся на фиксации.    |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль подсвеченных пакетов в      |
 |PkgToHoldHighlighted      |fg white;      |списке пакетов, которые находятся |
 |                          |               |на фиксации.                      |
 |--------------------------+---------------+----------------------------------|
 |                          |fg green; flip |Стиль пакетов в списке пакетов,   |
 |PkgToInstall              |reverse;       |которые будут установлены (не     |
 |                          |               |обновлены) или переустановлены.   |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль подсвеченных пакетов в      |
 |PkgToInstallHighlighted   |fg green;      |списке пакетов, которые будут     |
 |                          |               |установлены (не обновлены) или    |
 |                          |               |переустановлены.                  |
 |--------------------------+---------------+----------------------------------|
 |                          |fg magenta;    |Стиль пакетов в списке пакетов,   |
 |PkgToRemove               |flip reverse;  |которые будут удалены или         |
 |                          |               |вычищены.                         |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль подсвеченных пакетов в      |
 |PkgToRemoveHighlighted    |fg magenta;    |списке пакетов, которые будут     |
 |                          |               |удалены или вычищены.             |
 |--------------------------+---------------+----------------------------------|
 |PkgToUpgrade              |fg cyan; flip  |Стиль пакетов в списке пакетов,   |
 |                          |reverse;       |которые будут обновлены.          |
 |--------------------------+---------------+----------------------------------|
 |                          |               |Стиль подсвеченных пакетов в      |
 |PkgToUpgradeHighlighted   |fg cyan;       |списке пакетов, которые будут     |
 |                          |               |обновлены.                        |
 |--------------------------+---------------+----------------------------------|
 |                          |fg blue; bg    |Стиль таких индикаторов прогресса,|
 |Progress                  |yellow;        |как тот, что появляется по время  |
 |                          |               |загрузки кэша пакетов.            |
 |--------------------------+---------------+----------------------------------|
 |SolutionActionApproved    |bg green;      |Стиль одобренных действий в       |
 |                          |               |решении.                          |
 |--------------------------+---------------+----------------------------------|
 |SolutionActionRejected    |bg red;        |Стиль отвергнутых действий в      |
 |                          |               |решении.                          |
 |--------------------------+---------------+----------------------------------|
 |Status                    |fg white; bg   |Стиль строки статуса внизу экрана.|
 |                          |blue; set bold;|                                  |
 |--------------------------+---------------+----------------------------------|
 |TreeBackground            |               |Базовый цвет всех визуальных      |
 |                          |               |списков и деревьев.               |
 |--------------------------+---------------+----------------------------------|
 |                          |fg red; bg     |Цвет, используемый для отображения|
 |TrustWarning              |black; set     |предупреждений о надежности       |
 |                          |bold;          |пакета.                           |
 +-----------------------------------------------------------------------------+

  Настройка разметки экрана

   Можно перегруппировать список пакетов aptitude, делая соответствующие
   изменения в файле настройки.

    Элементы экрана

   Разметка хранится в группе настроек Aptitude::UI::Default-Package-View, и
   состоит из списка элементов экрана:

 Name Type {
   Row строка;
   Column столбец;
   Width ширина;
   Height высота;

   дополнительные параметры...
 };

   Это создаёт элемент экрана, названный Name; тип создаваемого элемента
   определяется Type. Опции Row, Column, Width и Height должны
   присутствовать; они определяют то, где помещается элемент экрана. (См.
   ниже детальное объяснение того, как организуются элементы экрана.)

   Примеры того, как изменить разметку экрана см. в определениях темы в файле
   /usr/share/aptitude/aptitude-defaults.

   Доступны следующие типы элементов экрана:

   Description

           Этот элемент экрана будет содержать «информационную область»
           (обычно описание выбранного в настоящий момент пакета).

           Опция PopUpDownKey дает имя клавиатурной команды, которая приведёт
           к показу или скрытию элемента экрана. Например, установка значения
           ShowHideDescription придаст текущему элементу экрана то же
           поведение, что по-умолчанию имеет информационная область. Опция
           PopUpDownLinked дает имя другому элементу экрана; текущий элемент
           будет показан или скрыт, в зависимости от того, показан или скрыт
           другой элемент.

   MainWidget

           Это место для «основного» элемента экрана: обычно это список
           пакетов. Разметка экрана должна содержать только один элемент
           MainWidget: не больше, не меньше.

   Static

           Область экрана, отображающая некоторый текст, возможно содержащая
           коды форматирования, описанные в «Настройка того, как отображаются
           пакеты». Отображаемый текст может быть задан в опции Columns, или
           он может быть сохранен в другой переменной настройки, определенной
           опцией ColumnsCfg. Цвет текста определяется цветом, обозначенным
           опцией Color.

           Static объекты могут отображаться и скрываться так же как объекты
           Description, используя опции PopUpDownKey и PopUpDownLinked.

    Размещение элементов экрана

   Элементы экрана организованы в «таблицу». Левый верхний угол элемента
   находится в ячейке, заданной её опциями Row и Column (обычно начиная со
   строки 0 и столбца 0, но этого не требуется). Ширина элемента в ячейках
   определяется его опцией Width, а его высота задается опцией Height.

   Когда элементы экрана упорядочены и им выделено изначальное место на
   экране, скорее всего места на экране больше нет. Если же имеется
   дополнительное место по вертикали, каждая строка, содержащая элемент
   экрана, чья опция RowExpand имеет значение true, получит дополнительное
   место; сходным образом, если имеется дополнительное место по горизонтали,
   то каждый столбец, содержащий элемент экрана, чья опция ColExpand имеет
   значение true получит дополнительное место.

   В ситуации, когда недостаточно места, каждая строка и каждый столбец всех
   графических элементов, у которых опции RowShrink или ColShrink установлены
   в значение true, будут сокращены. Если этого не достаточно, все строки и
   столбцы будут сокращены так, чтобы подойти доступному пространству.

   Если элемент экрана не раскрыт, но его строка или столбец раскрыты, его
   выравнивание определяется опциями RowAlign и ColAlign. Установка их в
   значение Left, Right, Top, Bottom или Center сообщит aptitude то, куда
   поместить данный элемент в строке или столбце.

   Например, следующая группа настройки создает статичный элемент названный
   «Header», который имеет ширину три клетки и расширяется горизонтально, но
   не вертикально. Он имеет тот же цвет, что и другие заголовочные строки, и
   использует стандартный формат отображения для заголовочных строк:

 Header Static {
   Row 0;
   Column 0;
   Width 3;
   Height 1;

   ColExpand true;
   ColAlign Center;

   RowAlign Center;

   Color ScreenHeaderColor;
   ColumnsCfg HEADER;
 };

    Руководство по разметке экрана

   Доступны следующие настройки элементов экрана:

   ColAlign выравнивание;

           выравнивание должно быть либо Left, либо Right, либо Center. Если
           строка, содержащая текущий элемент экрана шире, чем сам этот
           элемент, и опция ColExpand установлена в значение false, элемент
           будет помещен в строку согласно значению выравнивания.

           Если эта опция отсутствует, по-умолчанию она имеет значение Left.

   ColExpand true|false;

           Если эта опция установлена в true, строке, содержащей этот элемент
           экрана, будет дополнительно выделено доступное дополнительное
           горизонтальное пространство.

           Если эта опция отсутствует, в качестве его значения по-умолчанию
           принимается false.

   Color имя-цвета;

           Опция применяется к Static элементам. имя-цвета является именем
           цвета (например, ScreenStatusColor), который должен использоваться
           как цвет «по-умолчанию» для элемента экрана.

           Если эта опция отсутствует, в качестве его значения по-умолчанию
           принимается DefaultWidgetBackground.

   ColShrink true|false;

           Если значением этой опции является true для каждого элемента в
           столбце, и не достает горизонтального пространства, столбец будет
           сокращен так, чтобы подходить доступному пространству. Заметьте,
           что столбец может быть сокращен, даже если значением ColShrink
           является false; это просто показывает, что aptitude попытается
           сократить конкретный столбец до того, как будут сокращены другие
           столбцы.

           Если эта опция отсутствует, в качестве его значения по-умолчанию
           принимается false.

   Column столбец;

           Определяет самый правый столбец, содержащий этот элемент экрана.

   Columns формат;

           Опция применяется к Static элементам экрана, для которых не
           установлена опция ColumnsCfg. Она устанавливает отображаемое
           содержание объекта статуса; она является форматной строкой,
           описанной в «Настройка того, как отображаются пакеты».

   ColumnsCfg HEADER|STATUS|имя;

           Опция применяется к Static элементам экрана. Она устанавливает
           формат отображения текущего элемента в значение другой переменной
           настройки: если она HEADER или STATUS, используется опция
           Aptitude::UI::Package-Header-Format и
           Aptitude::UI::Package-Status-Format, соответственно; в противном
           случае, используется опция имя .

           Если эта опция не задана, значение опции Columns используется для
           контроля содержания статичного объекта.

   Height высота;

           Определяет высоту текущего элемента экрана.

   PopUpDownKey команда;

           Опция применяется к Description и Static элементам экрана.

           команда является именем клавиатурной команды (например,
           ShowHideDescription). Когда эта клавиша нажата, элемент экрана
           скрывается, если он видим, и отображается, если он скрыт.

   PopUpDownLinked элемент;

           Опция применяется к Description и Static элементам экрана.

           элемент является именем элемента экрана. Когда элемент
           отображается, текущий элемент также будет отображаться; когда
           элемент скрыт, текущий элемент также будет скрыт.

   Row строка;

           Определяет самая верхняя строка, содержащая этот элемент экрана.

   RowAlign выравнивание;

           alignment должно быть либо Top, либо Bottom, либо Center. Если
           строка, содержащая текущий отображаемый элемент выше, чем сам
           элемент, и значением RowExpand является false, этот элемент будет
           помещён в строку согласно значению alignment.

           Если эта опция не задана, её значением по-умолчанию является Top.

   RowExpand true|false;

           Если значением этой опции является true, то строка, содержащая
           этот элемент экрана получит некоторое дополнительное место по
           вертикали, если оно доступно.

           Если эта опция отсутствует, в качестве его значения по-умолчанию
           принимается false.

   RowShrink true|false;

           Если значением этой опции является true для каждого элемента в
           строке, и места по вертикали не достаточно, строка будет обрезана
           до необходимого размера, чтобы войти в доступное место. Заметьте,
           что строка может быть обрезана даже если опция RowShrink имеет
           значение false; это лишь показывает, что aptitude попытается
           обрезать определенную строку до того, как обрежет остальные
           строки.

           Если эта опция отсутствует, в качестве его значения по-умолчанию
           принимается false.

   Visible true|false;

           Если значением этой опции является false, то этот элемент экрана
           изначально будет скрыт. Вероятно, это полезно только вместе с
           PopUpDownKey и/или PopUpDownLinked.

           Если эта опция не задана, её значением по-умолчанию является true.

   Width ширина;

           Определяет ширину текущего элемента экрана.

  Руководство по файлу настроек

    Формат файла настроек

   В своем базовом виде файл настроек aptitude представляет собой список
   опций и их значений. Каждая строка этого файла должна иметь вид «Опция
   Значение;»: например, следующая строка в файле настроек устанавливает
   опцию Aptitude::Theme в значение «Dselect».

 Aptitude::Theme "Dselect";

   Опция может «содержать» другие опции, если они записаны в фигурных скобках
   и разделены точкой с запятой, как тут:

 Aptitude::UI {
   Package-Status-Format "";
   Package-Display-Format "";
 };

   Опция, содержащая другие опции иногда называется группой. Фактически,
   двойные двоеточия, встречающиеся именах опций являются сокращённым
   вариантом для указания содержимости: опция Aptitude::UI::Default-Grouping
   содержится в группе Aptitude::UI, которая сама содержится в группе
   Aptitude. Таким образом, если вы хотите, мы можете установить эту опцию в
   значение "", как этой указано ниже:

 Aptitude {
   UI {
     Default-Grouping "";
   };
 };

   Дополнительную информацию о формате файла настроек см. на странице
   руководства apt.conf(5).

    Размещение файлов настройки

   Настройки aptitude считываются из следующих источников по порядку:

    1. Опции файла настройки, определяемые в командной строке.

    2. Пользовательский файл настройки, ~/.aptitude/config. Этот файл
       перезаписывается, когда пользователь изменяет настройки в меню
       Параметры.

    3. Файл настройки системы, /etc/apt/apt.conf.

    4. Системные фрагментарные файлы настройки, /etc/apt/apt.conf.d/*.

    5. Файл определяется переменной окружения APT_CONFIG (если таковая
       установлена).

    6. Значения по-умолчанию хранятся в
       /usr/share/aptitude/aptitude-defaults.

    7. Значения по-умолчанию, встроенные в aptitude.

   Когда проверяется какая-то опция, эти источники просматриваются по
   порядку, и используется первый источник, дающий этой опции значение.
   Например, установка опции в /etc/apt/apt.conf отменит значение aptitude
   для этой опции по-умолчанию, но не отменит пользовательские установки в
   ~/.aptitude/config.

    Доступные опции настройки

   Следующие опции настройки используются aptitude. Заметьте, что они не
   являются единственными доступными опциями настройки; опции, используемые
   подлежащей системой apt здесь не приводятся. См. руководство apt(8) и
   apt.conf(5) для дополнительной информации по опциям apt.

   Опция: Apt::AutoRemove::RecommendsImportant
   По-умолчанию: true
   Описание: Если значением этой опции является true, то aptitude не будет
   рассматривать пакеты как неиспользуемые (и потому не будет их
   автоматически удалять) пока хотя бы один установленный пакет рекомендует
   эти пакеты, даже если значением Apt::Install-Recommends является false.
   Дополнительную информацию см. в разделе «Управление пакетами,
   установленными автоматически».
   Опция: Apt::AutoRemove::SuggestsImportant
   По-умолчанию: true
   Описание: Если значением этой опции является true, то aptitude не будет
   рассматривать пакеты как неиспользуемые (и потому автоматически удалять
   их) пока хотя бы один пакет предлагает их. Дополнительную информацию см. в
   разделе «Управление пакетами, установленными автоматически».
   Опция: Apt::Get::List-Cleanup
   По-умолчанию: true
   Описание: Синоним для Apt::List-Cleanup. Если одна из этих опций
   установлена в значение false, aptitude не будет удалять старые файлы со
   списками пакетов после загрузки нового набора списков пакетов.
   Опция: Apt::List-Cleanup
   По-умолчанию: true
   Описание: Синоним для Apt::Get::List-Cleanup. Если одна из этих опций
   установлена в значение false, aptitude не будет удалять старые файлы со
   списками пакетов после загрузки нового набора списков пакетов.
   Опция: Apt::Install-Recommends
   По-умолчанию: true
   Описание: Если значением этой опции является true, а значением
   Aptitude::Auto-Install также является true, то когда вы отмечаете пакет
   для установки, aptitude также отмечает для установки пакеты, рекомендуемые
   этим пакетом. Более того, если значением этой опции является true,
   aptitude не будет рассматривать пакеты как неиспользуемые (и поэтому не
   будет автоматически удалять их) пока имеется хотя бы один установленный
   пакет, рекомендующий эти пакеты. Дополнительную информацию см. в разделе
   «Управление пакетами, установленными автоматически» и «Непосредственное
   разрешение зависимостей».
   Опция: Aptitude::Allow-Null-Upgrade
   По-умолчанию: false
   Описание: Обычно если вы пытаетесь начать установочный запуск, когда не
   выбраны выполняемые действия, aptitude выведет предупреждение и вернётся к
   списку пакетов. Если значением этой опции является true, и если имеются
   пакеты, которые можно обновить, aptitude вместо отображения напоминания о
   команде Действия → Пометить обновляемые (U) перейдёт к окну
   предварительного просмотра.
   Опция: Aptitude::Always-Use-Safe-Resolver
   По-умолчанию: false
   Описание: Если значением этой опции является true, действия aptitude,
   вызываемые из командной строки всегда будут использовать «безопасный»
   решатель зависимостей, как если бы в командной строке была передана опция
   --safe-resolver .
   Опция: Aptitude::Autoclean-After-Update
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет чистить
   устаревшие файлы (см. Действия → Очистить устаревшие файлы) всякий раз,
   когда вы обновляете список пакетов.
   Опция: Aptitude::Auto-Fix-Broken
   По-умолчанию: true
   Описание: Если значением этой опции является false, aptitude будет
   спрашивать разрешение до попытки исправить какой-либо сломанный пакет.
   Опция: Aptitude::Auto-Install
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude будет
   автоматически пытаться удовлетворить зависимости пакета, когда вы
   отмечаете его для установки или обновления.
   Опция: Aptitude::Auto-Install-Remove-Ok
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет
   автоматически удалять конфликтующие пакеты, когда вы отмечаете пакет к
   установке или обновлению. Обычно же об этих конфликтах сообщается, а вы
   должны вручную их разрешить.
   Опция: Aptitude::Auto-Upgrade
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет
   автоматически отмечать все пакеты, которые можно обновить, для обновления
   всякий раз, когда запускается программа, как если вы выполнили эту команду
   сами Действия → Пометить обновляемые (U).
   Опция: Aptitude::CmdLine::Always-Prompt
   По-умолчанию: false
   Описание: В режиме командной строки, если это установлено, aptitude будет
   всегда выводить приглашение до начала установки или удаления пакетов, даже
   если приглашение при обычном поведении было бы пропущено. Эквивалентно
   опции командной строки -P .
   Опция: Aptitude::CmdLine::Assume-Yes
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude будет действовать так, как если бы пользователь ответил
   «yes» на всякое приглашение, что приводит к тому, что большинство
   приглашений пропускается. Это эквивалентно опции командной строки -y.
   Опция: Aptitude::CmdLine::Disable-Columns
   По-умолчанию: false
   Описание: Если эта опция включена, результаты поиска в командной строке
   (выполняемые командой aptitude search) не будут форматированы в
   пределахстолбцов фиксированной ширины или обрезаны до ширины экрана. Это
   эквивалентно опции командной строки --disable-columns.
   Опция: Aptitude::CmdLine::Download-Only
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude будет загружать файлы пакета, но не будет устанавливать их.
   Эквивалентно опции командной строки -d.
   Опция: Aptitude::CmdLine::Fix-Broken
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude будет более агрессивен при попытке починить зависимости
   сломанных пакетов. Эквивалентно опции командной строки -f .
   Опция: Aptitude::CmdLine::Versions-Group-By
   По-умолчанию: Установить в значение auto, none, package или source-package
   для контролирования того, группируется ли вывод команды aptitude versions
   и как он группируется. Эквивалентно опции командной строки --group-by (см.
   документацию по ней для более полного описания того, что подразумевают
   указанные значения).
   Опция: Aptitude::CmdLine::Ignore-Trust-Violations
   По-умолчанию: false
   Описание: В режиме командной строки, приводит к тому, что aptitude
   игнорирует установку ненадежных пакетов. Это синоним опции
   Apt::Get::AllowUnauthenticated.
   Опция: Aptitude::CmdLine::Package-Display-Format
   По-умолчанию: %c%a%M %p# - %d#
   Описание: Это форматная строка, как она описана в «Настройка того, как
   отображаются пакеты», которая используется для отображения результатов
   поиска в командной строке. Это эквивалентно опции командной строки -F.
   Опция: Aptitude::CmdLine::Package-Display-Width
   По-умолчанию:
   Описание: Опция дает ширину в символах, до которой каждый результат поиска
   в командной строке должен быть форматирован. Если эта опция пуста
   (установлена в значение по-умолчанию; т. е., ""), поисковые результаты
   будут форматированы до размера текущего терминала или до экрана с 80
   столбцами, если размер терминала не может быть определен.
   Опция: Aptitude::CmdLine::Progress::Percent-On-Right
   По-умолчанию: false
   Описание: Опция контролирует то, отображают индикаторы прогресса в
   командной строке проценты на левой стороне окна, также как apt-get, или на
   правой стороне (по-умолчанию). Опция не оказывает влияния на индикаторы
   прогресса загрузки.
   Опция: Aptitude::CmdLine::Progress::Retain-Completed
   По-умолчанию: false
   Описание: Если значением этой опции является false, то индикаторы
   прогресса в командной строке будут удалены и переписаны, когда задача,
   которую они отображают завершена. Если её значением является true, то они
   останутся на терминале. Опция не оказывает влияния на индикаторы прогресса
   загрузки.
   Опция: Aptitude::CmdLine::Request-Strictness
   По-умолчанию: 10000
   Описание: Когда программа запущена в режиме командной строки, если
   встречаются проблемы с зависимостями, aptitude будет добавлять это
   значение к очкам каждого действия решателя проблем, которое вы явным
   образом запросили.
   Опция: Aptitude::CmdLine::Resolver-Debug
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude выведет очень подробную информацию при попытке разрешения
   сломанных зависимостей. Как предполагает имя этой опции, она в первую
   очередь предназначена для целей отладки решателя проблем.
   Опция: Aptitude::CmdLine::Resolver-Dump
   По-умолчанию:
   Описание: В режиме командной строки, если необходимо разрешить сломанные
   зависимости и значением этой опции является имя файла, в который разрешена
   запись, состояние решателя будет записано в этот файл до того момента, как
   будут произведены какие-либо вычисления.
   Опция: Aptitude::CmdLine::Resolver-Show-Steps
   По-умолчанию: false
   Описание: Если значением этой опции является true, то решение проблем
   будет отображаться в виде последовательности решений отдельных
   зависимостей; например, «wesnoth зависит от wesnoth-data (= 1.2.4-1) ->
   устанавливается wesnoth-data 1.2.4-1 (unstable)». Чтобы переключиться
   между двумя режимами отображения, нажмите o в приглашении «Принять это
   решение?».
   Опция: Aptitude::CmdLine::Show-Deps
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude отобразит краткое резюме зависимостей (если таковые
   имеются), относящихся к состоянию пакета. Эквивалентно опции командной
   строки -D.
   Опция: Aptitude::CmdLine::Show-Size-Changes
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude отобразит ожидаемое изменение в количестве места на диске,
   используемого каждым пакетом. Эквивалентно опции командной строки -Z.
   Опция: Aptitude::CmdLine::Why-Display-Mode
   По-умолчанию: no-summary
   Описание: Опция устанавливает значение по-умолчанию аргумента командной
   строки --show-summary. Список допустимых значений этой опции и их описание
   см. в документации --show-summary.
   Опция: Aptitude::CmdLine::Show-Versions
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude будет отображать версию пакета, которая будет установлена
   или удалена. Эквивалентно опции командной строки -V.
   Опция: Aptitude::CmdLine::Show-Why
   По-умолчанию: false
   Описание: В режиме командной строки, если значением этой опции является
   true, aptitude будет отображать пакеты, установленные вручную, требующие
   каждый автоматически установленный пакет, или пакеты, установленные
   вручную, которые вызывают конфликт с каждым автоматически удаленным
   пакетом. Эквивалентно опции командной строки -W и отображает ту же
   информацию, которую вы можете получить, выполнив aptitude why или нажав i,
   находясь в списке пакетов.
   Опция: Aptitude::CmdLine::Version-Display-Format
   По-умолчанию: %c%a%M %p# %t %i
   Описание: Это форматная строка как она описана в «Настройка того, как
   отображаются пакеты», которая используется для отображения вывода aptitude
   versions. Эквивалентно опции командной строки -F .
   Опция: Aptitude::CmdLine::Versions-Show-Package-Names
   По-умолчанию: Установите в значение always, auto или never для того, чтобы
   контролировать то, когда отображаются имена пакетов в выводе aptitude
   versions. Эквивалентно опции командной строки --show-package-names
   (подробное описание значений этой опции см. в её руководстве).
   Опция: Aptitude::Safe-Resolver::Show-Resolver-Actions
   По-умолчанию: false
   Описание: Если эта опция включена, то когда активирован «безопасный»
   решатель зависимостей путем --safe-resolver или если выполнено действие
   командной строки safe-upgrade, будет отображаться резюме действий,
   предпринятых решателем до показа предварительного просмотра установки.
   Эквивалентно опции командной строки --show-resolver-actions.
   Опция: Aptitude::Screenshot::IncrementalLoadLimit
   По-умолчанию: 16384
   Описание: Минимальный размер в байтах, при котором aptitude начнет
   постепенно отображать снимки экрана. Снимки экрана, меньше этого размера,
   не появятся до тех пор, пока они не будут полностью загружены.
   Опция: Aptitude::Screenshot::Cache-Max
   По-умолчанию: 4194304
   Описание: Максимальное число байт данных снимков экрана, которые aptitude
   будет хранить в памяти для снимков экрана, не отображаемых в настоящий
   момент. По-умолчанию равно четырем мегабайтам.
   Опция: Aptitude::CmdLine::Simulate
   По-умолчанию: false
   Описание: Опция устарела; используйте вместо нее Aptitude::Simulate. В
   режиме командной строки заставляет aptitude только отобразить действия,
   которые были бы выполнены (вместо их фактического выполнения); в
   визуальном интерфейсе, aptitude запускается в режиме только для чтения,
   независимо от того, являетесь вы root или нет. Эквивалентно опции
   командной строки -s.
   Опция: Aptitude::CmdLine::Verbose
   По-умолчанию: 0
   Описание: Это контролирует то, насколько подробным является вывод aptitude
   в режиме командной строки. Каждый случай опции командной строки -v
   добавляет 1 к этому значению.
   Опция: Aptitude::CmdLine::Visual-Preview
   По-умолчанию: false
   Описание: If this option is true, aptitude will enter its visual interface
   to display the preview of an installation run and to download packages.
   Опция: Aptitude::Delete-Unused
   По-умолчанию: true
   Описание: Если значением этой опции является true, то пакеты,
   установленные автоматически и более не требуемые для других пакетов, будут
   автоматически удалены. Более подробную информацию см. в разделе
   «Управление пакетами, установленными автоматически».
   Опция: Aptitude::Delete-Unused-Pattern
   По-умолчанию:
   Описание: Устаревший псевдоним для Aptitude::Keep-Unused-Pattern. Если
   Aptitude::Keep-Unused-Pattern не установлена или её значением является
   пустая строка, то будет использоваться значение данной опции настройки. В
   противном случае, Aptitude::Delete-Unused-Pattern игнорируется.
   Опция: Aptitude::Display-Planned-Action
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude будет
   отображать окно предварительного просмотра до фактического выполнения тех
   действий, которые вы запросили.
   Опция: Aptitude::Forget-New-On-Install
   По-умолчанию: false
   Описание: Это значением этой опции является true, aptitude будет очищать
   список новых пакетов при установке, обновлении или удалении пакетов так
   же, как если бы вы выполнили команду Действия → Забыть о новых пакетах
   (f).
   Опция: Aptitude::Forget-New-On-Update
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет очищать
   список новых пакетов при обновлении списка пакетов так же, как если бы вы
   выполнили команду Действия → Забыть о новых пакетах (f).
   Опция: Aptitude::Get-Root-Command
   По-умолчанию: su:/bin/su
   Описание: Опция устанавливает внешнюю команду, которая будет
   использоваться aptitude для переключения пользователя на пользователя root
   (см. «Становимся root»). Она имеет вид протокол:команда. протокол должен
   быть либо su, либо sudo; протокол определяет то, как aptitude вызывает
   программу, когда желает получить привилегии root. Если протокол установлен
   в значение su, то для того, чтобы стать root, используется «команда -c
   аргументы»; в противном случае aptitude использует «команда аргументы».
   Первое слово в команде является именем программы, которая должна быть
   вызвана; остальные слова рассматриваются как аргументы этой программы.
   Опция: Aptitude::Ignore-Old-Tmp
   По-умолчанию: false
   Описание: Старые версии aptitude создавали каталог ~/.aptitude/.tmp,
   который более не является необходимым. Если этот каталог существует и
   значением Aptitude::Ignore-Old-Tmp является true, aptitude спросит вас о
   том, нужно ли удалить этот каталог. Опция автоматически устанавливается в
   значение true после вашего ответа. С другой стороны, если этот каталог не
   существует, эта опция устанавливается в значение false, поэтому если этот
   каталог появится aptitude сообщит вам об этом.
   Опция: Aptitude::Ignore-Recommends-Important
   По-умолчанию: false
   Описание: В предыдущих версиях aptitude, установка
   Aptitude::Recommends-Important приводила к тому, что рекомендации
   устанавливались автоматически, также как опция Apt::Install-Recommends
   делает это сегодня. Если значением этой опции является false и
   Aptitude::Recommends-Important также установлена в значение false,
   aptitude установит опцию Apt::Install-Recommends в значение false и
   установит Aptitude::Ignore-Recommends-Important в значение true при
   запуске.
   Опция: Aptitude::Keep-Recommends
   По-умолчанию: false
   Описание: Это устаревшая опция; вместо нее используйте
   Apt::AutoRemove::RecommendsImportant. Установка этой опции в значение true
   дает тот же эффект, что установка Apt::AutoRemove::RecommendsImportant в
   значение true.
   Опция: Aptitude::Keep-Suggests
   По-умолчанию: false
   Описание: Это устаревшая опция; вместо нее используйте
   Apt::AutoRemove::SuggestsImportant. Установка этой опции в значение true
   дает тот же эффект, что установка Apt::AutoRemove::SuggestsImportant в
   значение true.
   Опция: Aptitude::Keep-Unused-Pattern
   По-умолчанию:
   Описание: Если значением Aptitude::Delete-Unused является true, то только
   неиспользуемые пакеты, не подпадающие под этот шаблон (см. «Поисковые
   шаблоны») будут удалены. Если в качестве значения этой опции установлена
   пустая строка (по-умолчанию), все неиспользуемые пакеты будут удалены.
   Опция: Aptitude::LockFile
   По-умолчанию: /var/lock/aptitude
   Описание: Файл, который будет заблокирован fcntl, чтобы за раз не более
   одного процесса aptitude могло изменять кэш. В нормальных обстоятельствах
   вы никогда не должны изменять эту опцию, но она оказаться полезной при
   отладке. Заметьте: если aptitude жалуется на то, что не может получить
   блокировку файла, то это происходит не потому, что lock-файл должен быть
   удален. Блокировки fcntl управляются ядром и не будут сняты, пока
   программа, держащая их не будет завершена; невозможность получить
   блокировку означает, что файл используется другой работающей программой!
   Опция: Aptitude::Log
   По-умолчанию: /var/log/aptitude
   Описание: Если в качестве значения установлена непустая строка, aptitude
   будет записывать выполняемые установки, удаления и обновления пакетов в
   журнал. Если значение Aptitude::Log начинается с символа вертикальной
   черты (то есть, «|»), оставшаяся часть значения используется в качестве
   имени команды, которой будет передан журнал: например, |mail -s 'Aptitude
   install run' root приведёт к тому, что журнал будет отправлен по
   электронной почте пользователю root. Чтобы записать журнал в несколько
   файлов или команд, вы можете установить в качестве значения этой опции
   список целей.
   Опция: Aptitude::Logging::File
   По-умолчанию:
   Описание: Если в качестве значения установлена непустая строка, aptitude
   будет записывать сообщения журнала в файл, который указан в качестве
   значения опции; установка в значение «-» приведёт к тому, что сообщения
   будут выводится на стандартный вывод. Эта опция отличается от установки
   опции Aptitude::Log: последний файл используется для записи журнала
   установок и удалений, тогда как первый файл используется для записи
   журнала событий программы, ошибок и сообщений отладки (если они включены).
   Опция эквивалентна аргументу командной строки --log-file. См. также
   Aptitude::Logging::Levels.
   Опция: Aptitude::Logging::Levels
   По-умолчанию: (empty)
   Описание: Опция является группой, чьи члены контролируют то, какие
   сообщения журнала записываются. Каждый элемент является либо «уровнем»,
   для установки глобального уровня журнала (уровень журнала корневой
   программы записи журнала) данному уровню, либо «категорией:уровнем», где
   категория является изменяемой категорией сообщений (таких как
   aptitude.resolver.hints.match), а уровень является наименьшим уровнем
   журнала сообщений в этой категории, которые должны отображаться. Верными
   уровнями журнала являются «fatal», «error», «warn», «info», «debug», и
   «trace». Опция командной строки --log-level может использоваться для
   установки или отмены любого уровня журнала.
   Опция: Aptitude::Parse-Description-Bullets
   По-умолчанию: true
   Описание: Если эта опция включена, aptitude попытается автоматически
   обнаружить маркированные списки в описаниях пакетов. Это улучшит общее
   отображение описаний, но не является полностью обратно совместимым;
   некоторые описания могут быть форматированы менее привлекательно, когда
   значением этой опции является true, чем когда её значением является false.
   Опция: Aptitude::Pkg-Display-Limit
   По-умолчанию:
   Описание: Фильтр, по-умолчанию применяемый к списку пакетов; см.
   «Поисковые шаблоны» для дополнительной информации о его формате.
   Опция: Aptitude::ProblemResolver::Allow-Break-Holds
   По-умолчанию: false
   Описание: Если значением этой опции является true, решатель проблем будет
   рассматривать ломку фиксаций пакетов или установку запрещённых версий для
   разрешения зависимости. Если значением этой опции является false, эти
   действия будут отклонены по-умолчанию, но вы всегда можете включить их
   вручную (см. «Интерактивное разрешение зависимостей»).
   Опция: Aptitude::ProblemResolver::BreakHoldScore
   По-умолчанию: -300
   Описание: Насколько наградить или оштрафовать решения, которые изменяют
   состояние зафиксированных пакетов или устанавливают запрещенные версии.
   Заметьте, что если Aptitude::ProblemResolver::Allow-Break-Holds не
   установлена в значение true, решатель никогда не сломает фиксацию или
   установит запрещенную версию, если только на это нет явного разрешения
   пользователя.
   Опция: Aptitude::ProblemResolver::Break-Hold-Level
   По-умолчанию: 50000
   Описание: Стоимость безопасности назначается действиям, которые ломают
   фиксации, установленные пользователем (обновляя зафиксированный пакет или
   устанавливая запрещённую версию пакета). Описание стоимости безопасности
   см. в разделе «Стоимости безопасности».
   Опция: Aptitude::ProblemResolver::BrokenScore
   По-умолчанию: -100
   Описание: Насколько наградить или оштрафовать предполагаемые решения,
   основываясь на числе ломаемых зависимостей. Для каждой сломанной возможным
   решением зависимости, это количество очков добавляется к счету решения;
   обычно это должно быть отрицательное значение.
   Опция: Aptitude::ProblemResolver::DefaultResolutionScore
   По-умолчанию: 400
   Описание: Насколько наградить или оштрафовать предполагаемые решения на
   основе того, сколько они устанавливают решений «по-умолчанию» для
   неразрешённых в настоящий момент зависимостей. Решение по-умолчанию
   является решением, которое выбирается «apt-get install» или
   «непосредственным решателем зависимостей». Счёт применяется только к
   зависимостям и рекомендациям, чьи цели не установлены в настоящий момент.
   Опция: Aptitude::ProblemResolver::Discard-Null-Solution
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude никогда не
   предложит отмену всех предложенных вами действий для решения проблемы
   зависимостей.
   Опция: Aptitude::ProblemResolver::EssentialRemoveScore
   По-умолчанию: -100000
   Описание: Насколько наградить или оштрафовать решения, которые удаляют
   пакеты первой необходимости.
   Опция: Aptitude::ProblemResolver::Remove-Essential-Level
   По-умолчанию: 60000
   Описание: Стоимость безопасности назначается действиям, которые удаляют
   необходимый пакет. См. описание «Стоимости безопасности» стоимости
   безопасности.
   Опция: Aptitude::ProblemResolver::ExtraScore
   По-умолчанию: -1
   Описание: Любая версия пакета с приоритетом «дополнительный» будет
   получать это количество очков, добавленных к счету пакета.
   Опция: Aptitude::ProblemResolver::FullReplacementScore
   По-умолчанию: 500
   Описание: Удалению пакета и установке другого пакета, полностью
   заменяющего его (то есть, конфликтует с, заменяет его, предоставляет его),
   назначается этот счёт.
   Опция: Aptitude::ProblemResolver::FutureHorizon
   По-умолчанию: 50
   Описание: Сколько «шагов» должен пройти решать после нахождения первого
   решения. Хотя aptitude пытается создать более хорошие решения перед
   худшими решениями, иногда ему это не удаётся; эта опция приводит к тому,
   что решатель продолжает поиск более хорошего решения после отображения
   результатов поиска, а не останавливается непосредственно после нахождения
   первого решения.
   Опция: Aptitude::ProblemResolver::Hints
   По-умолчанию: (empty)
   Описание: Опция является группой, чьи члены используются для настройки
   решателя проблем. Каждый элемент в этой группе является строкой,
   описывающей действие, которое должно быть применено к одному или
   нескольким пакетам. Синтаксис каждой подсказки, и результат подсказок,
   могут быть найдены в «Настройка подсказок решателя».
   Опция: Aptitude::ProblemResolver::ImportantScore
   По-умолчанию: 5
   Описание: Любая версия пакета с приоритетом «важный» будет получать это
   количество очков к счёту пакета.
   Опция: Aptitude::ProblemResolver::Infinity
   По-умолчанию: 1000000
   Описание: «Максимальный» счёт потенциальных решений. Если набор действий
   обладает счётом хуже -Бесконечность, он будет тут же отброшен.
   Опция: Aptitude::ProblemResolver::InstallScore
   По-умолчанию: -20
   Описание: Какой вес должен придать решатель проблем установке пакета, если
   пакет ещё не должен был быть установлен
   Опция: Aptitude::ProblemResolver::Keep-All-Level
   По-умолчанию: 20000
   Описание: Стоимость безопасности назначается единственному решению,
   которое отменяет все действия пользователя. См. «Стоимости безопасности»
   описание стоимости безопасности.
   Опция: Aptitude::ProblemResolver::KeepScore
   По-умолчанию: 0
   Описание: Какой вес должен придать решатель проблем сохранению пакета в
   его текущем состоянии, если пакет не должен был быть сохранен в его
   текущем состоянии.
   Опция: Aptitude::ProblemResolver::NonDefaultScore
   По-умолчанию: -40
   Описание: Какой вес должен придать решатель проблем установке версии
   пакета не по-умолчанию (то есть, той, которая не является текущей версией
   и не является «версией-кандидатом»).
   Опция: Aptitude::ProblemResolver::Non-Default-Level
   По-умолчанию: 50000
   Описание: Стоимость безопасности назначается действиям, которые
   устанавливают версии пакета, не являющиеся версиями по-умолчанию.
   Например, если установлена версия 5 пакета, а версии 6, 7 и 8 доступны, и
   версия 7 является версией по-умолчанию, то версиям 6 и 8 будут даны
   стоимости безопасности, которые, по крайней мере, так высоки. См.
   «Стоимости безопасности» описание стоимости безопасности.
   Опция: Aptitude::ProblemResolver::OptionalScore
   По-умолчанию: 1
   Описание: Любая версия пакета с приоритетом «необязательный» будет
   получать это количество очков, добавленных к счету пакета.
   Опция: Aptitude::ProblemResolver::PreserveAutoScore
   По-умолчанию: 0
   Описание: Какой вес должен придать решатель проблем сохранению
   автоматических установок или удалений.
   Опция: Aptitude::ProblemResolver::PreserveManualScore
   По-умолчанию: 60
   Описание: Какой вес должен придать решатель проблем сохранению явного
   пользовательского выбора.
   Опция: Aptitude::ProblemResolver::RemoveScore
   По-умолчанию: -300
   Описание: Какой вес должен придать решатель проблем удалению пакета (если
   он ещё не был отмечен для удаления).
   Опция: Aptitude::ProblemResolver::Remove-Level
   По-умолчанию: 10000
   Описание: Стоимость безопасности назначается действиям, которые удаляют
   пакет. См. описание «Стоимости безопасности» стоимости безопасности.
   Опция: Aptitude::ProblemResolver::RequiredScore
   По-умолчанию: 4
   Описание: Любая версия пакета с приоритетом «требуемый» будет получать это
   количество очков к счёту пакета.
   Опция: Aptitude::ProblemResolver::ResolutionScore
   По-умолчанию: 50
   Описание: В дополнение ко всем факторам счёта, предложенные решения,
   которые фактически разрешают все неудовлетворённые зависимости, получают
   это количество дополнительных очков.
   Опция: Aptitude::ProblemResolver::Safe-Level
   По-умолчанию: 10000
   Описание: Стоимость безопасности назначается действиям, которые
   устанавливают версию пакета, являющуюся версией по-умолчанию, обновляют
   пакет до версии по-умолчанию или отменяют установки или обновление пакета.
   Решения, которым назначена эта стоимость, могут быть созданы командой
   aptitude safe-upgrade. См. «Стоимости безопасности» описание стоимости
   безопасности.
   Опция: Aptitude::ProblemResolver::SolutionCost
   По-умолчанию: safety,priority
   Описание: Описывает то, как определить стоимость решения. См. описание
   «Стоимость в интерактивном решателе зависимостей» того, чем является
   стоимость решений, что они делают, а также синтаксиса, используемого для
   их определения. Если стоимость не может быть разобрана, возникает ошибка,
   и используется стоимость по-умолчанию.
   Опция: Aptitude::ProblemResolver::StandardScore
   По-умолчанию: 3
   Описание: Любая версия пакета с приоритетом «стандартный» будет получать
   это количество очков к счёту пакета.
   Опция: Aptitude::ProblemResolver::StepLimit
   По-умолчанию: 5000
   Описание: Максимальное число «шагов», которое должно быть выполнено
   решателем проблем при каждой попытке найти решение проблемы зависимости.
   Уменьшение этого числа приведёт к тому, что aptitude будет «сдаваться»
   раньше; увеличение его позволит поиску решения потреблять большее
   количество времени и памяти до момента прерывания поиска. Установка
   StepLimit в значение 0 полностью отключит решатель проблем. Значение
   по-умолчанию достаточно велико для наиболее часто встречающихся ситуаций,
   и в то же время предотвращает aptitude от «взрыва», если попадается
   чрезвычайно сложная проблема. (заметьте: это применяется только к поискам
   из из командной строки; в визуальном интерфейсе решатель будет продолжать
   работать до тех пор, пока он не найдёт решения)
   Опция: Aptitude::ProblemResolver::StepScore
   По-умолчанию: 70
   Описание: Насколько наградить или оштрафовать предполагаемые решения на
   основе их длинны. Для каждого действия, выполняемого решением, это
   количество очков добавляется к счёту решения. Чем больше это значение, тем
   более решатель склонен сохранить свой первый выбор, не рассматривая
   альтернативы; это приведёт к тому, что решения будут создаваться более
   быстро, но решение может быть в некотором смысле более низкого качества,
   чем оно могло бы быть.
   Опция: Aptitude::ProblemResolver::Trace-Directory
   По-умолчанию:
   Описание: Если установлена эта опция, то всякий раз, когда решатель
   проблем создаёт решение, урезанная версия состояния пакета, достаточная
   для воспроизведения этого решения, записывается в данный файл. Если также
   установлена опция Aptitude::ProblemResolver::Trace-File, та же информация
   будет записана так же и в файл трассировки. Каталоги трассировки более
   прозрачны, чем файлы трассировки, и они более пригодны для, например,
   включения в деревья исходных кодов в качестве тестов.
   Опция: Aptitude::ProblemResolver::Trace-File
   По-умолчанию:
   Описание: Если установлена эта опция, то всякий раз когда решатель проблем
   производит решение, урезанная версия состояния пакета, достаточная для
   воспроизведения этого решения, записывается в данный файл. Если так же
   установлена опция Aptitude::ProblemResolver::Trace-Directory, та же
   информация будет записана так же и в каталог трассировки. Файл трассировки
   просто является сжатым архивом каталога трассировки; он занимает меньше
   места, чем каталог трассировки и удобен для передачи по сети.
   Опция: Aptitude::ProblemResolver::UndoFullReplacementScore
   По-умолчанию: -500
   Описание: Установке пакета и удалению другого пакета, который полностью
   заменяет его (например, конфликтует с ним, заменяет его и предоставляет
   его), назначается этот счёту.
   Опция: Aptitude::ProblemResolver::UnfixedSoftScore
   По-умолчанию: -200
   Описание: Насколько наградить или оштрафовать решение, оставляющее
   неразрешённым отношение Рекомендует. Обычно значение этой опции должно
   быть меньше, чем RemoveScore, либо aptitude попытается удалить пакеты, а
   не оставить их рекомендации неисправленными. См. дополнительную информацию
   в «Интерактивное разрешение зависимостей».
   Опция: Aptitude::ProblemResolver::UpgradeScore
   По-умолчанию: 0
   Описание: Какой вес должен придать решатель проблем обновлению (или
   установке старой версии) пакета до его версии-кандидата, если этот пакет
   ещё не должен был быть обновлён.
   Опция: Aptitude::Purge-Unused
   По-умолчанию: false
   Описание: Если значением этой опции является true и значением опции
   Aptitude::Delete-Unused также является true, то пакеты, которые более не
   используются, будут вычищены из системы путём удаления их файлов настроек
   и, возможно, других важных данных. Дополнительную информацию о том, какие
   пакеты рассматриваются в качестве «неиспользуемых», см. в разделе
   «Управление пакетами, установленными автоматически». ЭТА ОПЦИЯ МОЖЕТ
   ПРИВЕСТИ К ПОТЕРИ ДАННЫХ! НЕ ВКЛЮЧАЙТЕ ЕЁ, ЕСЛИ ВЫ НЕ ЗНАЕТЕ, ЧТО ДЕЛАЕТЕ!
   Опция: Aptitude::Recommends-Important
   По-умолчанию: true
   Описание: Это устаревшая опция настройки, которая была заменена на
   Apt::Install-Recommends. При запуске, aptitude копирует
   Aptitude::Recommends-Important (если такой список существует) в
   Apt::Install-Recommends и затем очищает Aptitude::Recommends-Important в
   вашем файле пользовательской настройки.
   Опция: Aptitude::Safe-Resolver::No-New-Installs
   По-умолчанию: false
   Описание: Если значением этой опции является true, то при включении
   «безопасного» решателя зависимостей через опцию --safe-resolver или если
   используется действие командной строки safe-upgrade, решателю нельзя будет
   устанавливать пакеты, неустановленные в настоящий момент.
   Опция: Aptitude::Safe-Resolver::No-New-Upgrades
   По-умолчанию: false
   Описание: Если эта опция включена, то при включении «безопасного» решателя
   зависимостей через опцию --safe-resolver или если используется действие
   командной строки safe-upgrade, решателю нельзя будет разрешать зависимости
   путём обновления пакетов.
   Опция: Aptitude::Sections::Descriptions
   По-умолчанию: См. $prefix/share/aptitude/section-descriptions
   Описание: Опция является группой, чьи члены определяют описания,
   отображаемые для каждого раздела, когда используется иерархичная политика
   группировки пакетов на основании поля «раздел» . Описания назначаются
   деревьям раздела на основе последнего компонента имени: например, член
   этой группы, названной «games», будет использоваться для описания Раздела
   «games», «non-free/games» и «non-free/desktop/games». Внутри текста
   описания раздела, строка «\n» будет заменена обрывом строки, а строка «''»
   будет заменена символом двойной кавычки.
   Опция: Aptitude::Sections::Top-Sections
   По-умолчанию: "main"; "contrib"; "non-free"; "non-US";
   Описание: Группа настройки, чьи элементы являются именами разделов архива
   верхнего уровня. Политики группировки «topdir», «subdir» и «subdirs»
   используют этот список для интерпретации полей Раздел: если первый элемент
   поля Раздел какого-то пакета не содержится в этом списке, или если его
   поле Раздел имеет только один элемент, то этот пакет будет группирован,
   используя первый член этого списка в качестве его первого элемента.
   Например, если первый член Top-Sections является «main», то пакет, чей
   Раздел «games/arcade» будет распознан как если бы его Разделом было
   «main/games/arcade».
   Опция: Aptitude::Simulate
   По-умолчанию: false
   Описание: При работе в режиме командной строки, приводит к тому, что
   aptitude просто отображает действия, которые были бы выполнены (вместо их
   действительного выполнения); в визуальном интерфейсе, приводит к тому, что
   aptitude запускается в режиме только для чтения, не зависимо от того,
   являетесь вы root или нет. Эквивалентно опции командной строки -s.
   Опция: Aptitude::Spin-Interval
   По-умолчанию: 500
   Описание: Задержка в миллисекундах между обновлениями «вертушки», который
   появляется во время работы решателя проблем.
   Опция: Aptitude::Suggests-Important
   По-умолчанию: false
   Описание: Это устаревшая опция; вместо нее используйте
   Apt::AutoRemove::SuggestsImportant. Установка этой опции в значение true
   дает тот же эффект, что установка Apt::AutoRemove::SuggestsImportant в
   значение true.
   Опция: Aptitude::Suppress-Read-Only-Warning
   По-умолчанию: false
   Описание: Если значением этой опции является false, aptitude отобразит
   предупреждение в первый раз, когда Вы попытаетесь изменить состояние
   пакета, когда aptitude находится в режиме только для чтения.
   Опция: Aptitude::Theme
   По-умолчанию:
   Описание: Тема, которую должен использовать aptitude; более подробную
   информацию см. в разделе «Темы».
   Опция: Aptitude::Track-Dselect-State
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude попытается
   определить, когда изменение состояния пакета сделано dselect или dpkg:
   например, если вы удалите пакет, используя dpkg, aptitude не будет
   пытаться переустановить его. Заметьте, что это может вызывать ошибки.
   Опция: Aptitude::UI::Advance-On-Action
   По-умолчанию: false
   Описание: Если значением этой опции является true, изменение состояния
   пакета (например, отметка его для установки) приведёт к тому, что aptitude
   переведет подсветку к следующему пакету в текущей группе.
   Опция: Aptitude::UI::Auto-Show-Reasons
   По-умолчанию: true
   Описание: Если значением этой опции является true, выбор сломанного пакета
   или пакета, который ломает другие пакеты, приведёт к тому, что в
   информационной области отобразятся некоторые причины того, почему,
   возможно, возникает эта поломка.
   Опция: Aptitude::UI::Default-Grouping
   По-умолчанию:
   filter(missing),status,section(subdirs,passthrough),section(topdir)
   Описание: Устанавливает используемые правила группировки по-умолчанию.
   Дополнительную информацию о правилах группировки см. в разделе «Настройка
   иерархии пакетов».
   Опция: Aptitude::UI::Default-Package-View
   По-умолчанию:
   Описание: Опция является группой, члены определяют разметку по-умолчанию
   экрана aptitude. Дополнительную информацию см. в разделе «Настройка
   разметки экрана».
   Опция: Aptitude::UI::Default-Preview-Grouping
   По-умолчанию: действие
   Описание: Устанавливает правила группировки по-умолчанию для окон
   предварительного просмотра. Дополнительную информацию о правилах
   группировки см. в разделе «Настройка иерархии пакетов».
   Опция: Aptitude::UI::Default-Sorting
   По-умолчанию: name
   Описание: Политика сортировки окон пакетов по-умолчанию. Более подробную
   информацию см. в разделе «Настройка того, как сортируются пакеты».
   Опция: Aptitude::UI::Description-Visible-By-Default
   По-умолчанию: true
   Описание: Когда список пакетов отображается первый раз, информационная
   область (которая обычно содержит длинное описание текущего пакета) будет
   видима, если значением этой опции является true, и скрыта, если false.
   Опция: Aptitude::UI::Exit-On-Last-Close
   По-умолчанию: true
   Описание: Если значением этой опции является true, закрытие всех активных
   окон приведёт к выходу из aptitude; в противном случае, вы не выйдите из
   aptitude, пока не выполните команду Действия → Выйти (Q). Более подробную
   информацию см. в разделе «Работа с несколькими окнами».
   Опция: Aptitude::UI::Fill-Text
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет
   форматировать описания так, что каждая строка в точности будет
   соответствовать ширине экрана.
   Опция: Aptitude::UI::Flat-View-As-First-View
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет
   отображать при запуске окно без иерархии вместо окна по-умолчанию.
   Опция: Aptitude::UI::HelpBar
   По-умолчанию: true
   Описание: Если значением этой опции является true, в верхней части экрана
   будет отображаться строка информации о важных сочетаниях клавиш.
   Опция: Aptitude::UI::Incremental-Search
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude будет
   выполнять «постепенный» поиск: если вы введете поисковый шаблон, он будет
   искать следующий пакет, соответствующий тому, что вы ввели.
   Опция: Aptitude::UI::InfoAreaTabs
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет
   отображать вкладки в верхней части информационной области (сторона в
   нижней части экрана), описывающие различные режимы этой области.
   Опция: Aptitude::UI::Keybindings
   По-умолчанию:
   Описание: Это группа, члены которой определяют связи между сочетаниями
   клавиш и командами aptitude. Более подробную информацию см. в разделе
   «Настройка привязки клавиш».
   Опция: Aptitude::UI::Menubar-Autohide
   По-умолчанию: false
   Описание: Если значением этой опции является true, строка меню будет
   скрыта, когда она не используется.
   Опция: Aptitude::UI::Minibuf-Download-Bar
   По-умолчанию: false
   Описание: Если значением этой опции является true, aptitude будет
   использовать менее навязчивый механизм отображения прогресса загрузки:
   появится строка в нижней части экрана, отображающая текущий статус
   загрузки. Нажатие клавиши q прервет загрузку, если она активна.
   Опция: Aptitude::UI::Minibuf-Prompts
   По-умолчанию: false
   Описание: Если значением этой опции является true, некоторые приглашения
   (такие как да/нет и приглашения с множественным выбором) будут
   отображаться в нижней части экрана, а не в диалоговых окнах.
   Опция: Aptitude::UI::New-Package-Commands
   По-умолчанию: true
   Описание: Если значением этой опции является false, такие команды как
   Пакет → Установить (+) будут иметь то же устаревшее поведение, какое они
   имели в ранних версиях aptitude.
   Опция: Aptitude::UI::Package-Display-Format
   По-умолчанию: %c%a%M %p %Z %v %V
   Описание: Опция настраивает форматную строку, используемую для отображения
   пакетов в списке пакетов. Более подробную информацию о форматных строках
   см. в разделе «Настройка того, как отображаются пакеты».
   Опция: Aptitude::UI::Package-Header-Format
   По-умолчанию: %N %n #%B %u %o
   Описание: Опция настраивает форматную строку, используемую для отображения
   строки заголовка списка пакетов (то есть, строки, которая появляется между
   списком пакетов и строкой меню). Более подробную информацию о форматных
   строках см. в разделе «Настройка того, как отображаются пакеты».
   Опция: Aptitude::UI::Package-Status-Format
   По-умолчанию: %d
   Описание: Опция настраивает форматную строку, используемую для отображения
   строки статуса списка пакетов (то есть, строки, которая появляется между
   списком пакетов и информационной областью). Более подробную информацию о
   форматных строках см. в разделе «Настройка того, как отображаются пакеты».
   Опция: Aptitude::UI::Pause-After-Download
   По-умолчанию: OnlyIfError
   Описание: Если значением этой опции является true, aptitude будет
   отображать сообщение после завершения загрузки пакетов, спрашивающее вас о
   том, хотите ли вы продолжить установку. Если значением этой опции является
   OnlyIfError, сообщение будет отображаться только в том случае, если
   загрузка провалилась. В противном случае, если значением этой опции
   является false, aptitude будет сразу же переходить к следующему экрану
   после завершения загрузки.
   Опция: Aptitude::UI::Preview-Limit
   По-умолчанию:
   Описание: Фильтр по-умолчанию, применяемый к окну предварительного
   просмотра; см. «Поисковые шаблоны» для более подробной информации о его
   формате.
   Опция: Aptitude::UI::Prompt-On-Exit
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude будет
   отображать приглашение подтверждения до выхода из программы.
   Опция: Aptitude::UI::Styles
   По-умолчанию:
   Описание: Эта группа настроек, содержания которых определяют то, какие
   текстовые стили используются aptitude для отображения информации. Более
   подробную информацию см. в разделе «Настройка цветов и стилей текста».
   Опция: Aptitude::UI::ViewTabs
   По-умолчанию: true
   Описание: Если значением этой опции является false, aptitude не будет
   отображать «вкладки», в верхней части экрана, описывающие текущие активные
   окна.
   Опция: Aptitude::Warn-Not-Root
   По-умолчанию: true
   Описание: Если значением этой опции является true, aptitude будет
   определять, когда вам необходимы привилегии root для того, чтобы что-то
   сделать, и спрашивать вас о том, хотите ли вы переключиться на учётную
   запись root, если вы ещё не являетесь root. См. «Становимся root» для
   более подробной информации.
   Опция: DebTags::Vocabulary
   По-умолчанию: /usr/share/debtags/vocabulary
   Описание: Местонахождение файла-словаря debtags; используется для загрузки
   метаданных тегов пакетов.
   Опция: Dir::Aptitude::state
   По-умолчанию: /var/lib/aptitude
   Описание: Каталог, в котором сохраняется постоянное состояние aptitude.
   Опция: Quiet
   По-умолчанию: 0
   Описание: Опция контролирует молчаливость режима командной строки.
   Установка этой опции в более высокое значение отключит больше индикаторов
   прогресса.

  Темы

   Темой в aptitude является простое собрание настроек, «объединенных друг с
   дружкой». Темы работают путем отмены значений опций по-умолчанию: если
   опция не установлена в системном файле настроек или в вашем персональном
   файле настроек, aptitude будет использовать установку из текущей темы,
   если она имеется, до использования стандартного значения по-умолчанию.

   Тема является просто именованной группой под опцией Aptitude::Themes;
   каждая опция настройки, содержащаяся в группе, будет отменять
   соответствующую опцию в глобальной настройке. Например, если выбрана тема
   Dselect, опция
   Aptitude::Themes::Dselect::Aptitude::UI::Package-Display-Format будет
   отменять значение по-умолчанию опции Aptitude::UI::Package-Display-Format.

   Чтобы выбрать тему, установите опции настройки Aptitude::Theme имя темы;
   например,

 Aptitude::Theme Vertical-Split;

   Следующие темы поставляются с aptitude в
   /usr/share/aptitude/aptitude-defaults:

   Dselect

           Эта тема делает aptitude похожим на устаревший менеджер пакетов
           dselect:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетовPkgs
 --\ Установленные пакеты
   --\ Приоритет
     --\ base - Базовая система Debian
 c   base  base-file 3.0.16      3.0.16      различные базовые системные файлы Debian
 c   base  base-pass 3.5.7       3.5.7       эталонные файлы паролей и групп для базовой системы Debian
 c   base  bash      2.05b-15    2.05b-15    GNU Bourne Again SHell: оболочка командной строки
 c   base  bsdutils  1:2.12-7    1:2.12-7    основные утилиты из 4.4BSD-Lite
 c   base  coreutils 5.0.91-2    5.0.91-2    основные служебные программы системы GNU
 c   base  debianuti 2.8.3       2.8.3       различные утилиты Debain
 c   base  diff      2.8.1-6     2.8.1-6     утилиты сравнения файлов
 base-files                      установлен; ничего не                       требуется
 Этот пакет содержит основную файловую иерархию системы Debian и несколько
 важных файлов, таких как /etc/debian_version,
 /etc/host.conf, /etc/issue, /etc/motd, /etc/profile, /etc/nsswitch.conf, и других, а также
 тексты нескольких лицензионных соглашений, часто используемых в системах Debian.







   Vertical-Split

           Эта тема перегруппировывает экран: текущее описание пакета, обычно
           появляющееся под списком пакетов, отображается с правой стороны от
           списка пакетов. Эта тема полезна для тех, у кого очень широкие
           терминалы, и возможно также при редактировании встроенной иерархии
           пакетов.

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновить  g: Загр/Удал/Устан пакетов
 aptitude 0.2.14.1
 --\ Установленные пакеты                  Современные компьютеры поддерживают Advanced  #
   --\ admin - Утилиты администрирования  Configuration and Power Interface
     --\ main - Главный архив Debian  (ACPI) для управления питанием
 i   acpid         1.0.3-19   1.0.3-19   вашей системы и запрашивать
 i   alien         8.44       8.44       и параметры батарей.
 i   anacron       2.3-9      2.3-9
 i   apt-show-vers 0.07       0.07       ACPID - это гибкая, расширяемая системная служба
 i A apt-utils     0.5.25     0.5.25     для доставки событий ACPI
 i   apt-watch     0.3.2-2    0.3.2-2    Она следит за файлом
 i   aptitude      0.2.14.1-2 0.2.14.1-2 (/proc/acpi/event) и когда возникает событие,
 i   at            3.1.8-11   3.1.8-11   запускает программу для обработки
 i   auto-apt      0.3.20     0.3.20     последнего. Набор запускаемых программ
 i   cron          3.0pl1-83  3.0pl1-83  определяется конфигурационными
 i   debconf       1.4.29     1.4.29     файлами, которые
 i   debconf-i18n  1.4.29     1.4.29     могут устанавливаться пакетами
 i A debootstrap   0.2.39     0.2.39     или администратором.
 i A deborphan     1.7.3      1.7.3
 i   debtags       0.16       0.16       Для того, чтобы использовать этот пакет, вам необходимо
 i A defoma        0.11.8     0.11.8     современное ядро (=>2.4.7). Оно может
 i   discover      2.0.4-5    2.0.4-5    содержать заплаты
 Утилиты для использования управления питанием ACPI

Играем в Сапёра

   Если вы устали от установки и удаления пакетов, aptitude включает в себя
   версию классической игры «Сапёр». Чтобы запустить её, выберите Действия →
   Играть в сапёра; появится исходная доска Сапёра:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 Сапёр                                              10/10 мин  13 секунд





                                    +--------+
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    |        |
                                    +--------+






   Внутри прямоугольника, который появляется на экране, спрятаны мины. Ваша
   задача состоит в том, чтобы определить, используя интуицию, логику и
   удачу, где эти мины находятся, не наступив ни на одну из них! Для этого
   вам нужно открыть все квадраты, которые не содержат мины; делая это, вы
   узнаете важную информацию относительно квадратов, содержащих мины. Тем не
   менее, берегитесь: открытие квадрата, содержащего мину, тот час же
   закончит вашу игру!

   Чтобы открыть квадрат (и узнать, спрятана ли здесь мина), выберите квадрат
   при помощи клавиш со стрелками и нажмите Enter:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 Сапёр                                             10/10 мин  387 секунд





                                    +--------+
                                    | 2......|
                                    | 2111...|
                                    |    1...|
                                    | 1111...|
                                    |11...111|
                                    |...113  |
                                    |1122    |
                                    |        |
                                    +--------+






   Как вы можете видеть, некоторые скрытые (пустые) части доски открыты на
   этом снимке экрана. Квадраты, содержащие ., являются квадратами,
   непосредственно рядом с которыми мин нет; числа в остальных квадратах
   показывают количество мин по соседству.

   Если вы считаете, что вам известно то, где находится мина, вы можете
   поместить на это место «флаг». Чтобы сделать это, выберете предполагаемый
   квадрат и нажмите f. Например, на снимке экрана ниже, я решил, что квадрат
   в левой стороне доски выглядит подозрительно...

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 Сапёр                                              9/10 мин  961 секунд





                                    +--------+
                                    | 2......|
                                    | 2111...|
                                    |    1...|
                                    |F1111...|
                                    |11...111|
                                    |...113  |
                                    |1122    |
                                    |        |
                                    +--------+






   Как вы можете видеть, в выбранном квадрате появился символ F. Больше
   нельзя открыть этот квадрат, даже случайно, пока флаг не будет удалён
   (нажатием клавиши f ещё раз). Когда вы поместите все флаги на все мины по
   соседству с некоторым квадратом (например, квадраты, обозначенные 1 по
   соседству с флагом на снимке экрана выше), вы можете «очистить» поле
   вокруг квадрата. Это просто удобное сокращение для открытия всех квадратов
   по соседству с данным (кроме содержащих флаг, конечно). Например, вот
   очистка вокруг 1 выше:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 Сапёр                                              9/10 мин  2290 секунд





                                    +--------+
                                    | 2......|
                                    | 2111...|
                                    |221 1...|
                                    |F1111...|
                                    |11...111|
                                    |...113  |
                                    |1122    |
                                    |        |
                                    +--------+






   По счастливой случайности (была ли это удача?), моя догадка о
   местонахождении этой мины была верна. Если бы я ошибся, я незамедлительно
   проиграл бы:

  Действия  Откат  Пакет  Поиск  Параметры  Окна  Справка
 f10: Меню  ?: Справка  q: Выход  u: Обновление  g: Загр/Устан/Удал пакетов
 Сапёр                                   Сапёр    Проиграл в 2388 секунд





                                    +--------+
                                    |^2......|
                                    |^2111...|
                                    |221^1...|
                                    |^1111...|
                                    |11...111|
                                    |...113^ |
                                    |1122* ^ |
                                    | ^ ^   ^|
                                    +--------+






   Когда вы проигрываете, положения всех мин открываются: неразорвавшиеся
   мины обозначены символом вставки (^), а те, на которые вы «наступили»
   обозначены звездочкой (*).

   --------------------------------------------------------------------------

   ^[7] Я рад сообщить, что количество запросов такого вида стремительно
   уменьшилось после первой публикации настоящего руководства. Если бы между
   этими двумя событиями существовала связь, то это было бы счастливым
   случаем.

   ^[8] Иногда это обозначается как «установочный запуск», даже несмотря на
   то, что вы, может быть, обновляете или удаляете какие-то пакеты в
   дополнение к установке пакетов.

   ^[9] Как было отмечено выше, это не означает, что пакеты в архиве являются
   безопасными или даже незлонамеренными; это лишь означает, что они являются
   неподдельными.

   ^[10] Более точно: они будут удалены в том случае, когда к ним нет пути
   через Зависит, Предзависит или Рекомендует от какого-либо установленного
   вручную пакета. Если Apt::AutoRemove::SuggestsImportant установлено в
   значение true, отношения Предлагает также будет достаточно для сохранения
   пакета в установленном состоянии.

   ^[11] Или когда непосредственное разрешение отключено.

   ^[12] Пакет с наивысшим dpkg приоритетом, не является пакетом с наивысшим
   apt приоритетом.

   ^[13] Был установлен этот предел, так как более комплексные стоимостные
   структуры могли бы затруднить оптимизацию решателя. В будущих версиях
   программы некоторые ограничения, если они окажутся излишними, могут быть
   удалены.

   ^[14] aptitude расценивает запятую как специальный символ только в том
   случае, если имеется второй аргумент, так (например) «?name(apt,itude)»
   осуществляет поиск строки «apt,itude» в полях Имя пакетов.

   Несмотря на то, что это поведение строго определено, оно может удивлять; я
   рекомендую использовать закавыченные строки для любого шаблона,
   содержащего символы, которые могут иметь специальное значение.

   ^[15] Символы со специальным значением: «+», «-», «.», «(», «)», «|», «[»,
   «]», «^», «$» и «?». Заметьте, что некоторые из них также являются
   метасимволами aptitude, поэтому если вы хотите ввести (например) символ
   «|», он должен быть экранирован: «?description(\~|)», этот запрос будет
   соответствовать тем пакетам, чье описание содержит символ вертикальной
   черты («|»).

   ^[16] Экранирование обратной косой чертой доступно также и для символов
   \\, \n и \t.

   ^[17] Проницательные читатели заметят, что очень важно явно называть
   переменную в λ-терминах, соответствующих данному термину. Типичный термин
   имел бы форму «λ x . name-equals(x, шаблон)»; явная цель делает x видимым
   в языке поиска.

   ^[18] Этот термин в значительной степени симметричен с ?true.

   ^[19] В настоящий момент отметки тегами не поддерживаются; для будущего
   использования.

   ^[20] На некоторых терминалах фон «yellow» фактически оказывается
   коричневым.

                   Глава 3. Часто задаваемые вопросы aptitude

           «Как ... тебя зовут?»                                        

           «Я Артур, Король бритов.»

           «В чем ... твое задание?»

           «Я ищу Священный Грааль!»

           «Какова ... скорость ласточки без груза?»

           «Ты имеешь в виду африканскую или о европейскую ласточку?»

           «А? Я ... Я не зна---АААААААААА!»
                                           -- Монти Пайтон и Священный Грааль

   3.1. Как мне найти один строго определённый пакет по имени?

   3.2. Как я могу найти сломанные пакеты?

   3.3. Я хочу выделить текст, почему aptitude не дает мне отключить мышь?

   3.1. Как мне найти один строго определённый пакет по имени?
        Как указано в «Поисковые шаблоны», когда вы ищете пакет по имени,
        текст, вводимый вами, в действительности является регулярным
        выражением. Поэтому, поисковый шаблон «^имя$» будет соответствовать
        только пакету с именем имя.

        Например, вы можете найти пакет apt (но не aptitude или synaptic),
        введя ^apt$; вы можете найти g++ (но не g++-2.95 или g++-3.0), введя
        ^g\+\+$.
   3.2. Как я могу найти сломанные пакеты?
        Используйте команду Поиск → Найти неработоспособные (b).
   3.3. Я хочу выделить текст, почему aptitude не дает мне отключить мышь?
        Обычно вы не можете выбрать текст в xterm в то время, когда в
        терминале работает программа (такая, например, как aptitude),
        использующая мышь. Тем не менее, вы можете отменить это поведение и
        выполнить выбор, держа клавишу Shift нажатой во время нажатия клавиши
        мыши в терминале.

                         Глава 4. Список разработчиков

           Никто не помнит певца. А песня остается.                    
                                             -- Терри Прачет, Последний герой

   В этом разделе указаны некоторые люди, внесшие вклад в aptitude на
   протяжении его жизни.

   [Primechanie] Примечание
                 Этот раздел в настоящее время довольно неполон, но,
                 вероятно, со временем он будет обновляться и расширяться (в
                 частности, в связи с огромным количеством источников
                 переводов, информация о многих переводчиках отсутствует
                 ^[21]). Если вы хотите войти в этот список, пожалуйста
                 вышлите мне на email <dburrows@debian.org> письмо с
                 объяснением того, почему вы думаете, что должны быть в этом
                 списке.

   Переводы и интернационализация

   Перевод на бразильский

           Andre Luis Lopes, Gustavo Silva

   Перевод на китайский

           Carlos Z.F. Liu

   Перевод на чешский

           Miroslav Kure

   Перевод на датский

           Morten Brix Pedersen, Morten Bo Johansen

   Перевод на голландский

           Luk Claes

   Перевод на финский

           Jaakko Kangasharju

   Перевод на французский

           Martin Quinson, Jean-Luc Coulon

   Перевод на немецкий

           Sebastian Schaffert, Erich Schubert, Sebastian Kapfer, Jens Seidel

   Перевод на итальянский

           Danilo Piazzalunga

   Перевод на японский

           Yasuo Eto, Noritada Kobayashi

   Перевод на литовский

           Darius ?itkevicius

   Перевод на польский

           Michal Politowski

   Перевод на португальский

           Nuno Sénica, Miguel Figueiredo

   Перевод на норвежский

           Håvard Korsvoll

   Перевод на испанский

           Jordi Malloch, Ruben Porras

   Перевод на шведский

           Daniel Nylander

   Исходная заплата i18n

           Masato Taruishi

   Сортировка и сопровождение i18n

           Christian Perrier

   Документация

   Руководство пользователя

           Daniel Burrows

   Программирование

   Разработка программы и её реализация

           Daniel Burrows

   Поддержка dpkg поля Breaks

           Ian Jackson, Michael Vogt

   --------------------------------------------------------------------------

   ^[21] На основе ChangeLog, ссылок на систему отслеживания ошибок Debian, и
   историю исправлений aptitude, должно быть возможно составить достаточно
   полный список тех, кто участвовал в i18n, но это потребует таких больших
   временных затрат, что в настоящее время это просто не доступно.

                        Руководство по командной строке

   --------------------------------------------------------------------------

   Содержание

   aptitude — высокоуровневый интерфейс для менеджера пакетов

   aptitude-create-state-bundle — связать текущее состояние aptitude

   aptitude-run-state-bundle — распаковать пакет состояния aptitude и
   передать его aptitude

Название

   aptitude — высокоуровневый интерфейс для менеджера пакетов

Синтаксис

   aptitude [опции...] { autoclean | clean | forget-new | keep-all | update }

   aptitude [опции...] { full-upgrade | safe-upgrade } [пакеты...]

   aptitude [опции...] { build-dep | build-depends | changelog | download |
   forbid-version | hold | install | markauto | purge | reinstall | remove |
   show | unhold | unmarkauto | versions } пакеты...

   aptitude extract-cache-subset output-directory пакеты...

   aptitude [опции...] search шаблоны...

   aptitude [опции...] { add-user-tag | remove-user-tag } tag пакеты...

   aptitude [опции...] { why | why-not } [шаблоны...] пакет

   aptitude [-S fname] [ --autoclean-on-startup | --clean-on-startup | -i |
   -u ]

   aptitude help

Описание

   aptitude является текстовым интерфейсом для пакетной системы Debian
   GNU/Linux.

   Он позволяет пользователю просматривать список пакетов и выполнять такие
   задачи по управлению пакетами как установка, обновление и удаление
   пакетов. Действия могут быть выполнены из визуального интерфейса или из
   командной строки.

Действия командной строки

   Первый аргумент, не начинающийся с дефиса («-») рассматривается как
   действие, которое программа должна выполнить. Если действие не определено
   в командной строке, aptitude будет запущен в визуальном режиме.

   Доступны следующие действия:

   install

           Установить один или несколько пакетов. Пакеты должны быть
           приведены в виде списка после команды «install»; если имя пакета
           содержит символ тильды («~») или вопросительный знак («?»), то это
           имя будет рассматриваться как поисковый шаблон, и всякий пакет,
           подпадающий под этот шаблон, будет установлен (см. раздел
           «Поисковые шаблоны» в руководстве aptitude).

           Чтобы выбрать определенную версию пакета, добавьте «=версия» к
           имени пакета: например, «aptitude install apt=0.3.1». Сходным
           образом, чтобы выбрать пакет из определенного архива, добавьте
           «/архив» к имени пакета: например, «aptitude install
           apt/experimental». Вы не можете указать и архив, и версию пакета.

           Не всякий пакет, включенный в список в командной строке, должен
           быть установлен; вы можете сообщить aptitude, чтобы она сделала
           что-то другое с пакетом, добавив «отменяющий спецификатор» к имени
           пакета. Например, aptitude remove wesnoth+ установит wesnoth, а не
           удалит его. Доступны следующие отменяющие спецификаторы:

                пакет+

                        Установить пакет.

                пакет+M

                        Установить пакет и сразу же отметить его как
                        установленный автоматически (заметьте, что если ни
                        один пакет не зависит от пакета, это приведёт к его
                        немедленному удалению).

                пакет-

                        Удалить пакет.

                пакет_

                        Вычистить пакет: удалить его и все ассоциированные
                        файлы данных и настройки.

                пакет=

                        Зафиксировать пакет: отменить любую активную
                        установку, обновление или удаление и предотвратить
                        этот пакет от автоматического обновления в будущем.

                пакет:

                        Оставить пакет в его текущей версии: отменить любую
                        установку, удаление или обновление. В отличии от
                        «фиксации» (выше) это действие не предотвращает
                        автоматические обновления в будущем.

                пакет&M

                        Отметить пакет как установленный автоматически.

                пакет&m

                        Отметить пакет как установленный вручную.

           Как специальный случай, «install» без аргументов выполнит любые
           сохранённые/ожидающие действия.

           [Primechanie] Примечание
                         Когда вы вводите Y в окончательном запросе
                         подтверждения, команда «install» изменит сохранённую
                         aptitude информацию о том, какие действия следует
                         выполнить. Поэтому, если вы используете (например)
                         команду «aptitude install foo bar» и затем отменяете
                         установку, когда aptitude начала загрузку и
                         установку пакетов, вам необходимо будет запустить
                         «aptitude remove foo bar» для отмены данного
                         приказа.

   remove, purge, hold, unhold, keep, reinstall

           Эти команды такие же, как команда «install», но они применяют
           обозначенное действие ко всем пакетам, данным в командной строке,
           которые не отменены. Различие между hold и keep состоит в том, что
           hold приведёт к тому, что пакет будет игнорироваться в будущих
           запусках команд safe-upgrade или full-upgrade, а keep просто
           отменяет любые запланированные действия по отношению к пакету.
           unhold разрешает пакету обновление в будущем вызове команд
           safe-upgrade или full-upgrade, без изменения состояния пакета.

           Например, «aptitude remove '~ndeity'» удалит все пакеты, чье имя
           содержит «deity».

   markauto, unmarkauto

           Отметить пакеты как установленные автоматически или установленные
           вручную, соответственно. Пакеты определяются в точности так же как
           команда «install». Например, «aptitude markauto '~slibs'» отметит
           все пакеты в разделе «libs» как установленные автоматически.

           Для дополнительной информации о пакетах установленных
           автоматически см. «Управление автоматически установленными
           пакетами» в справочном руководстве aptitude.

   build-depends, build-dep

           Удовлетворить зависимости для сборки пакета. Каждое имя пакета
           может быть пакетом с исходным кодом, в этом случае устанавливаются
           зависимости для сборки этого пакета; в противном случае, двоичные
           пакеты находятся тем же путём как и для команды «install», а
           зависимости для сборки пакетов с исходным кодом, которые собирают
           эти двоичные пакеты, удовлетворяются.

           Если имеет место параметр командной строки --arch-only, будет
           выполнена только архитектурно-зависимая сборка пакетов (то есть,
           не Build-Depends-Indep или Build-Conflicts-Indep ).

   forbid-version

           Запретить обновлять пакет до определённой версии. Это помешает
           aptitude автоматически обновлять пакет до этой версии, но будет
           позволять автоматическое обновление до будущих версий.
           По-умолчанию aptitude будет выбирать версию, до которой пакет был
           бы обновлён при обычных условиях; вы можете отменить этот выбор,
           добавляя «=version» к имени пакета: например, «aptitude
           forbid-version vim=1.2.3.broken-4».

           Эта команда полезна для того, чтобы избежать сломанных версий
           пакетов без установки и очистки фиксаций вручную. Если вы все же
           решите, что вам действительно нужна запрещённая версия пакета,
           команда «aptitude install пакет» удалит запрет.

   update

           Обновляет список доступных пакетов из источников apt (это
           эквивалентно «apt-get update»)

   safe-upgrade

           Обновляет установленные пакеты до их наиболее свежих версий.
           Установленные пакеты не будут удалены до тех пор, пока они не
           станут неиспользуемыми (см. раздел «Управление автоматически
           установленными пакетами» в руководстве aptitude). Пакеты, которые
           не установлены в текущий момент, могут быть установлены для
           разрешения зависимостей, если не включена опция командной строки
           --no-new-installs.

           Если ни один пакет не указан в командной строке, aptitude
           попытается обновить каждый пакет, который может быть обновлен. В
           противном случае, aptitude попытается обновить только те пакеты,
           которые указаны для обновления. К пакетам могут быть добавлены
           суффиксы тем же способом как и аргументы к aptitude install,
           поэтому вы так же можете давать aptitude дополнительные
           инструкции; например, aptitude safe-upgrade bash dash- попытается
           обновить пакет bash и удалить пакет dash.

           Иногда необходимо удалить один пакет для того, чтобы обновить
           другой; эта команда не может обновить пакеты в таких ситуациях.
           Используйте команду full-upgrade для того, чтобы обновить столько
           пакетов, сколько возможно.

   full-upgrade

           Обновляет установленные пакеты до их наиболее свежих версий,
           удаляя или устанавливая пакеты, если это необходимо. Эта команда
           менее консервативна, чем safe-upgrade, и потому более вероятно,
           что она произведет нежелательные действия. Тем не менее, она
           способна обновить пакеты, которые не могут быть обновлены
           командной safe-upgrade.

           Если ни один пакет не указан в командной строке, aptitude
           попытается обновить каждый пакет, который может быть обновлен. В
           противном случае, aptitude попытается обновить только те пакеты,
           которые указаны для обновления. К пакетам могут быть добавлены
           суффиксы тем же способом как и аргументы к aptitude install,
           поэтому вы так же можете давать aptitude дополнительные
           инструкции; например, aptitude full-upgrade bash dash- попытается
           обновить пакет bash и удалить пакет dash.

           [Primechanie] Примечание
                         Эта команда изначально названа dist-upgrade по
                         историческим причинам, и aptitude все ещё распознает
                         dist-upgrade как синоним full-upgrade.

   keep-all

           Отменяет все запланированные действия на всех пакетах; статус
           любого пакета, означающий установку, удаление или обновление,
           будет очищен.

   forget-new

           Забывает всю внутреннюю информацию о том, какие пакеты являются
           «новыми» (эквивалентно нажатию клавиши «f» в визуальном режиме).

   search

           Ищет пакеты, соответствующие одному из указанных в командной
           строке шаблонов. Все пакеты, соответствующие какому-либо из данных
           шаблонов будут отображены; например, «aptitude search '~N' edit»
           перечислит все «новые» пакеты и все пакеты, чьи имена содержат
           «edit». Дополнительную информация о поисковых шаблонах см. в
           разделе «Поисковые шаблоны» справочного руководства aptitude.

           [Primechanie] Примечание
                         В примере выше, «aptitude search '~N' edit» имеет
                         два аргумента после search и, поэтому, производится
                         поиск по двум шаблонам: «~N» и «edit». Как это
                         описано в руководстве по поисковым шаблонам, один
                         шаблон, составленный из двух подшаблонов,
                         разделённых пробелом (такой как «~N edit»),
                         соответствует какому-то пакету только в том случае,
                         если оба эти шаблона соответствуют пакету. Таким
                         образом, команда «aptitude search '~N edit'» покажет
                         только «новые» пакеты, чьи имена содержат «edit».

           Пока вы не передадите опцию -F, вывод команды aptitude search
           будет выглядеть как-то так:

 i   apt                             - Продвинутый интерфейс для dpkg
 pi  apt-build                       - интерфейс apt для сборки, оптимизации и ус
 cp  apt-file                        - утилита APT для поиска в пакетах — командный
 ihA raptor-utils                    - утилиты для анализа и преобразования RDF

           Каждый результат поиска отображается на отдельной строке. Первый
           символ каждой строки обозначает текущее состояние пакета: наиболее
           частыми состояниями являются p, что означает, что в системе нет
           следов пакета, c, что означает, что пакет был удален, но его файлы
           настройки остаются в системе, i, что означает, что пакет
           установлен, и v, что означает, что пакет является виртуальным.
           Второй символ обозначает сохраненное действие (если оно есть; в
           противном случае отображается пробел) для выполнения над пакетом,
           наиболее частыми действиями являются i, что означает, что пакет
           будет установлен, d, что означает, что пакет будет удален, и p,
           что означает, что пакет и его файлы настроек будут удалены. Если
           третьим символом является A, то пакет был автоматически
           установлен.

           Полный список возможных состояний и флагов действий см. в разделе
           «Доступ к информации о пакете» справочного руководства aptitude.
           Чтобы настроить вывод search, см. опции командной строки -F и
           --sort.

   show

           Displays detailed information about one or more packages. If a
           package name contains a tilde character («~») or a question mark
           («?»), it will be treated as a search pattern and all matching
           packages will be displayed (see the section «Search Patterns» in
           the aptitude reference manual).

           Если уровень детализации вывода равен 1 или выше (то есть, по
           меньшей мере один -v имеет место в командной строке), отображается
           информация обо всех версиях пакета. В противном случае,
           отображается информация о «версии кандидате» (версии, которая была
           бы загружена при выполнении команды « aptitude install»).

           Вы можете отобразить информацию об отдельной версии пакета,
           добавив =версия к имени пакета; вы можете отобразить версию из
           определённого архива или выпуска, добавив /архив или /выпуск к
           имени пакета: например, /unstable или /sid. Если программе
           передано одно из этих дополнений, то, независимо от уровня
           детализации вывода, будет отображена только та версия пакета,
           которую вы запросили.

           Если уровень детализации вывода равен 1 или выше, будут отображены
           поля архитектуры пакета, размера в сжатом виде, имени файла и
           md5sum. Если детализация вывода равна 2 или выше, будут отображены
           отобранная версия или версии по одному разу для каждого архива, в
           котором они найдены.

   versions

           Отображает версии пакетов, приведенных в командной строке.

 $ aptitude versions wesnoth
 p   1:1.4.5-1                                                             100
 p   1:1.6.5-1                                    unstable                 500
 p   1:1.7.14-1                                   experimental             1

           Каждая версия отображается на отдельной строке. Первые три символа
           слева обозначают текущее состояние пакета, планируемое состояние
           (если таковой имеется) и то, был ли пакет установлен
           автоматически; дополнительную информацию о значениях этих символов
           см. в документации по aptitude search. Справа от номера версии вы
           можете найти выпуски, из которых эта версия доступна, и
           pin-приоритет этой версии.

           Если имя пакета содержит символ тильды («~») или знак вопроса
           («?»), то оно будет считаться поисковым шаблоном, и будут
           отображены все подпадающие под него версии (см. раздел «Поисковые
           шаблоны» справочного руководства aptitude). Это означает, что,
           например, aptitude versions '~i' отобразит только все те версии
           пакетов, которые установлены в данный момент в системе, другие
           версии тех же пакетов не будут отображены.

 $ aptitude versions '~nexim4-daemon-light'
 Пакет exim4-daemon-light:
 i   4.71-3                                                                100
 p   4.71-4                                       unstable                 500

 Пакет exim4-daemon-light-dbg:
 p   4.71-4                                       unstable                 500

           Если введён поисковый шаблон, или должно быть отображено более
           одной версии пакета, aptitude автоматически сгруппируется вывод по
           пакетам как это показано выше. Вы можете отключить это через
           --group-by=none, в этом случае aptitude отобразить единый список
           всех версий, которые были найдены, и автоматически добавит имя
           пакета в каждую строку вывода:

 $ aptitude versions --group-by=none '~nexim4-daemon-light'
 i   exim4-daemon-light 4.71-3                                             100
 p   exim4-daemon-light 4.71-4                    unstable                 500
 p   exim4-daemon-light-dbg 4.71-4                unstable                 500

           Чтобы отключить имя пакета, передайте опции
           --show-package-names=never:

 $ aptitude versions --show-package-names=never --group-by=none '~nexim4-daemon-light'
 i   4.71-3                                                                100
 p   4.71-4                                       unstable                 500
 p   4.71-4                                       unstable                 500

           В дополнение к опциям, описанным выше, информация, выводимая для
           каждой версии, может регулироваться при помощи опции командной
           строки -F. Порядок, в котором отображаются версии, регулируется
           опцией командной строки --sort. Чтобы запретить aptitude
           форматировать вывод в виде столбцов, используйте
           --disable-columns.

   add-user-tag, remove-user-tag

           Добавляет или удаляет пользовательский тег у выбранной группы
           пакетов. Если имя пакета содержит тильду («~») или знак вопроса
           («?»), то оно считается поисковым шаблоном, и тег добавляется или
           удаляется у всех пакетов, которые подпадают под этот шаблон (см.
           раздел «Поисковые шаблоны» справочного руководства aptitude).

           Пользовательские теги являются произвольными строками,
           ассоциированными с пакетом. Они могут использоваться с поисковым
           термином ?user-tag(тег), который выберет все пакеты, обладающие
           пользовательским тегом соответствующим тегу.

   why, why-not

           Объясняет причину, почему определенный пакет должен или не может
           быть установлен в системе.

           Эта команда ищет пакеты, которые требуют данный пакет или
           конфликтуют с ним. Она отображает последовательность зависимостей,
           ведущих к целевому пакету, а также комментарий, обозначающий
           установленное состояние каждого пакета в цепочке зависимостей:

 $ aptitude why kdepim
 i   nautilus-data Зависит nautilus
 i A nautilus      Рекомендует desktop-base (>= 0.2)
 i A desktop-base  Предлагает   gnome | kde | xfce4 | wmaker
 p   kde           Зависит    kdepim (>= 4:3.4.3)

           Команда why находит цепочку зависимостей, которая приводит к
           установке пакета, указанного в командной строке (как выше).
           Заметьте, что зависимость, выведенная aptitude в этом случае
           является лишь предположением. Это так, поскольку ни один пакет из
           установленных в настоящий момент на этом компьютере не не зависит
           и не рекомендует пакет kdepim; если доступна более сильная
           зависимость, aptitude отобразит её.

           А why-not находит цепочку зависимостей, ведущую к конфликту с
           целевым пакетом:

 $ aptitude why-not textopo
 i   ocaml-core          Зависит   ocamlweb
 i A ocamlweb            Зависит   tetex-extra | texlive-latex-extra
 i A texlive-latex-extra Конфликтует textopo

           Если имеет место один или несколько шаблонов, то aptitude начнёт
           поиск с этих шаблонов; то есть, первый выведенный пакет в цепочке
           будет пакетом, подходящим под данный шаблон. Эти шаблоны считаются
           именами пакетов, если они не содержат знак тильды («~») или знак
           вопроса («?»), если же они содержат эти символы, то они считаются
           поисковыми шаблонами (см. раздел «Поисковые шаблоны» справочного
           руководства aptitude).

           Если шаблоны отсутствуют, aptitude будет искать цепочки
           зависимостей, начиная с пакетов, установленных вручную. Последнее
           покажет пакеты, которые привели или могли бы привести к установке
           данного пакета.

           [Primechanie] Примечание
                         aptitude why не выполняет полное разрешение
                         зависимостей; эта команда лишь отображает прямые
                         взаимосвязи между пакетами. Например, если A требует
                         B, C требует D, а B и C конфликтуют, «aptitude
                         why-not D» не выдаст ответ «A зависит от B, B
                         конфликтует с C, а D зависит от C».

           По-умолчанию aptitude выводит только ту цепочку зависимостей,
           которая является «наиболее сильной, короткой и содержит больше
           установленных пакетов». То есть, программа ищет цепочку, которая
           содержит уже установленные пакеты или пакеты, которые будут
           установлены; она ищет самые сильные зависимости; она ищет цепочки,
           в которых меньше ORed зависимостей и зависимостей вида
           Предоставляет; и она ищет самую короткую цепочку зависимостей,
           соответствующую этим критериям. Эти правила последовательно
           ослабляются до тех пор, пока не будет найдена подходящая цепочка.

           Если уровень детализации вывода равен 1 или больше, то все
           объяснения, которые aptitude может найти, будут отображены в
           обратном порядке релевантности. Если уровень многословия равен 2
           или больше, на стандартный вывод будет выводится огромное
           количество отладочной информации.

           Эта команда возвращает 0 при успешном выполнении, 1, если
           объяснение не может быть составлено, и -1, если возникла ошибка.

   clean

           Удаляет все ранее загруженные .deb файлы из каталога с кэшем
           пакетов (обычно /var/cache/apt/archives).

   autoclean

           Удаляет кэшированные пакеты, которые более не могут быть
           загружены. Это позволяет вам предотвратить неконтролируемое
           разрастание кэша без его полной очистки.

   changelog

           Загружает и отображает список изменений Debian для каждого пакета,
           содержащего исходный код или двоичные файлы.

           По-умолчанию загружается список изменений для той версии, которая
           была бы установлена путём выполнения команды «aptitude install».
           Вы можете выбрать конкретную версию пакет, добавив =версия к имени
           пакета; вы можете выбрать версию из конкретного архива или
           выпуска, добавив /архив или /выпуск к имени пакета (например,
           /unstable или /sid).

   download

           Загружает .deb файл для данного пакета в текущий каталог. Если имя
           пакета содержит символ тильды («~») или знак вопроса («?»), то оно
           будет считаться поисковым шаблоном, и все подходящие под него
           пакеты будут загружены (см. раздел «Поисковые шаблоны» справочного
           руководства aptitude).

           По-умолчанию загружается та версия, которая была бы установлена
           путём выполнения команды «aptitude install». Вы можете выбрать
           конкретную версию пакета, добавив =версия к имени пакета; вы
           можете выбрать версию из конкретного архива или выпуска, добавив
           /архив или /выпуск к имени пакета (например, /unstable или /sid).

   extract-cache-subset

           Копировать каталог настройки apt (/etc/apt) и подмножество базы
           данных пакетов в выбранный каталог. Если ни один пакет не указан,
           копируется вся база данных пакетов целиком; в противном случае
           копируются только те записи, которые соответствуют именованному
           пакету. Каждое имя пакета может быть поисковым шаблоном, и будут
           выбраны все пакеты, подпадающие под этот шаблон (см. раздел
           «Поисковые шаблоны» справочного руководства aptitude). Любые
           существующие файлы базы данных пакетов в указанном каталоге будут
           перезаписаны.

           Зависимости в двоичных пакетных стансах будут перезаписаны для
           удаления ссылок на пакеты, не входящие в выбранное множество.

   help

           Отображает краткое резюме доступных команд и опций.

Опции

   Следующие опции могут использоваться для изменения поведения описанных
   выше действий. Заметьте, что несмотря на то, что все опции будут приняты
   для всех команд, некоторые опции не применяются к отдельным командам и
   будут игнорироваться этими командами.

   --add-user-tag тег

           Для full-upgrade, safe-upgrade, forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold и
           unmarkauto: добавить тег пользователя тег ко всем устанавливаемым,
           удаляемым или обновляемым пакетам, как если бы была выполнена
           команда add-user-tag .

   --add-user-tag-to тег,шаблон

           Для full-upgrade, safe-upgrade forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold и
           unmarkauto: добавить тег пользователя тег ко всем пакетам,
           подпадающим под шаблон, как если бы была выполнена команда
           add-user-tag . Шаблон является поисковым шаблоном, которые
           описываются в разделе «Поисковые шаблоны» справочного руководства
           aptitude.

           Например, aptitude safe-upgrade --add-user-tag-to
           "new-installs,?action(install)" добавит тег new-installs ко всем
           пакетам, устанавливаемым при помощи команды safe-upgrade.

   --allow-new-upgrades

           Когда используется безопасный решатель (то есть, была передана
           опция командной строки --safe-resolver, выполнено действие
           safe-upgrade, или опция Aptitude::Always-Use-Safe-Resolver
           установлен в значение true), решателю зависимостей разрешено
           устанавливать обновления пакетов, какое бы значение ни имел
           параметр Aptitude::Safe-Resolver::No-New-Upgrades.

   --allow-new-installs

           Позволяет команде safe-upgrade устанавливать новые пакеты; когда
           используется безопасный решатель зависимостей (то есть, была
           передана опция командной строки --safe-resolver, выполнено
           действие safe-upgrade, или опция
           Aptitude::Always-Use-Safe-Resolver установлена в значение true),
           разрешить решателю зависимостей устанавливать новые пакеты. Опция
           оказывает действие независимо от значения опции
           Aptitude::Safe-Resolver::No-New-Installs.

   --allow-untrusted

           Установить пакеты из ненадёжных источников без запроса
           подтверждения. Вы должны использовать эту опцию только в том
           случае, если вы знаете, что делаете, поскольку это легко может
           компрометировать безопасность вашей системы.

   --disable-columns

           Опция приводит к тому, что aptitude search и aptitude versions
           выводят результаты без какого-либо специального форматирования. В
           частности: обычно aptitude добавляет пробелы или обрезает
           результаты поиска в попытке вместить его в вертикальные «столбцы».
           С этим флагом каждая стока будет сформирована путем удаления
           любого форматного экранирования в форматной строке с
           соответствующим текстом; ширина строк будет игнорироваться.

           Например, первые несколько строк вывода команды «aptitude search
           -F '%p %V' --disable-columns libedataserver» могут быть
           следующими:

 disksearch 1.2.1-3
 hp-search-mac 0.1.3
 libbsearch-ruby 1.5-5
 libbsearch-ruby1.8 1.5-5
 libclass-dbi-abstractsearch-perl 0.07-2
 libdbix-fulltextsearch-perl 0.73-10

           Как в примере выше, --disable-columns часто полезна в соединении с
           индивидуальными настройками формата экрана, используя опцию
           командной строки -F.

           Соответствует опции настройки Aptitude::CmdLine::Disable-Columns.

   -D, --show-deps

           Показывает краткие объяснения автоматических установок и удалений
           для команд, которые устанавливают или удаляют пакеты (install,
           full-upgrade и т. д.).

           Соответствует опции настройки Aptitude::CmdLine::Show-Deps.

   -d, --download-only

           Загрузить пакеты в кэш пакетов, но не выполнять установку или
           удаление каких-либо пакетов. По-умолчанию кэш пакетов хранится в
           /var/cache/apt/archives.

           Соответствует опции настройки Aptitude::CmdLine::Download-Only.

   -F формат, --display-format формат

           Определить формат, используемый для отображения вывода команд
           search и versions. Например, передача формату «%p %V %v» отобразит
           имя пакета, за которым следует его текущая установленная версия и
           его доступные версии (см. раздел «Настройка того, как отображаются
           пакеты» справочного руководства aptitude для более подробной
           информации).

           Опция командной строки --disable-columns часто полезна при её
           совместном использовании с опцией -F.

           Для команды search, это соответствует опции настройки
           Aptitude::CmdLine::Package-Display-Format; для versions, это
           соответствует опции настройки
           Aptitude::CmdLine::Version-Display-Format.

   -f

           Попытаться починить зависимости сломанных пакетов, даже если это
           предполагает игнорирование действий, запрошенных в командной
           строке.

           Соответствует опции настройки Aptitude::CmdLine::Fix-Broken.

   --full-resolver

           Когда обнаружены проблемы с зависимостями пакетов, использовать
           по-умолчанию «полный» решатель для их разрешения. В отличии от
           «безопасного» решателя, активируемого командой --safe-resolver,
           полный решатель может удалять пакеты для удовлетворения
           зависимостей. Он может разрешить больше ситуаций, чем безопасный
           алгоритм, но его решения менее желательны.

           Опция может быть использована для того, чтобы использовать только
           полный решатель даже когда опция
           Aptitude::Always-Use-Safe-Resolver имеет значение true. Команда
           safe-upgrade никогда не использует полный решатель и не принимает
           опцию --full-resolver.

   --group-by способ-группировки

           Контролирует то, как команда versions группирует свой вывод.
           Распознаются следующие значения:

              * archive для группировки пакетов по архиву, в котором они
                находятся («stable», «unstable» и т. д.). Если пакет
                находится в нескольких архивах, он будет отображен в каждом
                из них.

              * auto для группировки версиям по их пакетам, если имеется
                только один аргумент, и он не является поисковым шаблоном.

              * none для отображения всех версий в одном списке без
                какой-либо группировки.

              * package для группировки версий по их пакетам.

              * source-package для группировки версий по их пакетам с
                исходным кодом.

              * source-version для группировки версий по их пакетам с
                исходным кодом и версиям исходного кода.

           Соответствует опции настройки
           Aptitude::CmdLine::Versions-Group-By.

   -h, --help

           Отображает краткое справочное сообщение. Идентично с действием
           help .

   --log-file=файл

           Если файл является непустой строкой, сообщения лога будут записаны
           в него, исключением является если файл имеет значение «-», тогда
           сообщения будут записаны в стандартный вывод. Если эта опция
           вызвана несколько раз, учитывается только её последний вызов.

           Это не оказывает действия на журнал установок, которые выполняются
           aptitude (/var/log/aptitude); запись журнала сообщений ведущаяся с
           использование этой настройки, включает внутренние события
           программы, ошибки и отладочные сообщения. См. опцию командной
           строки --log-level, чтобы получить больший контроль над тем, что
           записывается в журнал.

           Соответствует опции настройки Aptitude::Logging::File.

   --log-level=уровень, --log-level=категория:уровень

           --log-level=уровень приводит к тому, что aptitude записывает в
           журнал только те сообщения, чей уровень равен уровню или выше.
           Например, установка уровня записи в журнал в значение error
           приведёт к тому, что в журнале будут отображаться только сообщения
           с уровнем error и fatal; все остальные сообщения будут скрыты.
           Уровнями записи в журнал (в убывающем порядке) являются off,
           fatal, error, warn, info, debug, и trace. По-умолчанию уровень
           записи в журнал имеет значение warn.

           --log-level=категория:уровень приводит к тому, что сообщения в
           данной категории записываются в журнал только в том случае, если
           их уровень равен уровню или выше его.

           --log-level может встречаться несколько раз в командной строке;
           эффект оказывает наиболее конкретная установка, поэтому если вы
           передадите --log-level=aptitude.resolver:fatal и
           --log-level=aptitude.resolver.hints.match:trace, то сообщения в
           aptitude.resolver.hints.parse будут выведены только в том случае,
           если их уровень равен fatal, но все сообщения в
           aptitude.resolver.hints.match также будут выведены. Если вы
           установите уровень одной и той же категории два или несколько раз,
           эффект окажет последняя установка.

           Это не оказывает влияния на журнал установок, выполняемых aptitude
           (/var/log/aptitude); журнал сообщений, записываемый используя эту
           настройку, включает внутренние события программы, ошибки и
           отладочные сообщения. См. опцию командной строки --log-file, чтобы
           изменить то, куда отправляются сообщения журнала.

           Соответствует группе настроек Aptitude::Logging::Levels.

   --log-resolver

           Устанавливает некоторые стандартные уровни записи в журнал,
           связанные с решателем, чтобы вывод журнала подходил для его
           обработки автоматическими инструментами. Эквивалентно опции
           командной строки --log-level=aptitude.resolver.search:trace
           --log-level=aptitude.resolver.search.tiers:info.

   --no-new-installs

           Запретить safe-upgrade устанавливать какие-либо новые пакеты;
           когда используется безопасный решатель (то есть, была передана
           опция --safe-resolver или опция Aptitude::Always-Use-Safe-Resolver
           установлена в значение true), запрещает решателю зависимостей
           устанавливать новые пакеты. Эта опция оказывает действие
           независимо от значения Aptitude::Safe-Resolver::No-New-Installs.

           Это симулирует историческое поведение команды apt-get upgrade.

   --no-new-upgrades

           Когда используется безопасный решатель (то есть, была передана
           опция --safe-resolver или опция Aptitude::Always-Use-Safe-Resolver
           установлена в значение true), запретить решателю зависимостей
           устанавливать обновления пакетов, независимо от значения
           Aptitude::Safe-Resolver::No-New-Upgrades.

   --no-show-resolver-actions

           Не отображать действия, выполняемые «безопасным» решателем,
           игнорируя любую опцию настройки или переданную ранее опцию
           --show-resolver-actions.

   -O порядок, --sort порядок

           Определяет порядок, в котором должен отображаться вывод команд
           search и versions. Например, передача «installsize» в качестве
           порядка выведет список пакетов в порядке, соответствующем их
           размеру в установленном состоянии (дополнительную информацию см. в
           разделе «Настройка того, как сортируются пакеты» справочного
           руководства aptitude).

           Порядок сортировки по-умолчанию: имя,версия.

   -o ключ=значение

           Устанавливает опцию файла настроек напрямую; например, используйте
           -o Aptitude::Log=/tmp/my-log, чтобы записать журнал действий
           aptitude в /tmp/my-log. Более подробную информацию об опциях файла
           настройки см. в разделе «Руководство по файлу настроек»
           справочного руководства aptitude.

   -P, --prompt

           Всегда отображать приглашение до загрузки, установки или удаления
           пакетов, даже когда не выполняются какие-либо действия, отличные
           от тех, что были явным образом затребованы.

           Соответствует опции настройки Aptitude::CmdLine::Always-Prompt.

   --purge-unused

           Если опция Aptitude::Delete-Unused установлена в значение «true»
           (по-умолчанию), то в дополнение к удалению каждого пакета, который
           более не требуется ни одному установленному пакету, aptitude также
           вычистит их, удалив их файлы настроек и, возможно, важные данные.
           Дополнительную информацию о том, какие пакеты рассматриваются в
           качестве «неиспользуемых», см. в разделе «Управление пакетами,
           установленными автоматически» справочного руководства aptitude.
           ЭТА ОПЦИЯ МОЖЕТ ПРИВЕСТИ К ПОТЕРЕ ДАННЫХ! НЕ ИСПОЛЬЗУЙТЕ ЕЁ, ЕСЛИ
           ВЫ НЕ ЗНАЕТЕ, ЧТО ДЕЛАЕТЕ!

           Соответствует опции настройки Aptitude::Purge-Unused.

   -q[=n], --quiet[=n]

           Запрещает все инкрементные индикаторы прогресса, что делает вывод
           подходящим для записи в журнал. Опция может быть передана
           несколько раз, что сделает вывод программы менее подробным, но в
           отличии от apt-get, aptitude не включает опцию -y, когда опция -q
           передана более одного раза.

           Опциональный аргумент =n может использоваться для того, чтобы
           напрямую установить степень подробности вывода (например, чтобы
           отменить установку в /etc/apt/apt.conf); это приведёт к тому, что
           программа будет вести себя так, будто бы была передана опция -q в
           количестве n раз.

   -R, --without-recommends

           Не считать рекомендации зависимостями при установке новых пакетов
           (отменяет параметры в /etc/apt/apt.conf и ~/.aptitude/config).
           Ранее установленные по рекомендациям пакеты удалены не будут.

           This corresponds to the pair of configuration options
           Apt::Install-Recommends and Apt::AutoRemove::RecommendsImportant.

   -r, --with-recommends

           Трактовать рекомендации как зависимости при установке новых
           пакетов (игнорирует настройки в /etc/apt/apt.conf и
           ~/.aptitude/config).

           Соответствует опции настройки Apt::Install-Recommends

   --remove-user-tag тег

           Для full-upgrade, safe-upgrade forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold и
           unmarkauto: удалить пользовательский тег тег у всех
           устанавливаемых, удаляемых или обновляемых пакетов, как если бы
           была выполнена команда add-user-tag .

   --remove-user-tag-from тег,шаблон

           Для full-upgrade, safe-upgrade forbid-version, hold, install,
           keep-all, markauto, unmarkauto, purge, reinstall, remove, unhold и
           unmarkauto: удалить пользовательский тег тег у всех пакетов,
           подпадающих под шаблон, как если бы была выполнена команда
           remove-user-tag. Шаблон является поисковым шаблоном, описанным в
           разделе «Поисковые шаблоны» справочного руководства aptitude.

           Например, aptitude safe-upgrade --remove-user-tag-from
           "not-upgraded,?action(upgrade)" удалит тег not-upgraded у всех
           пакетов, которые могут быть обновлены выполнением команды
           safe-upgrade .

   -s, --simulate

           В режиме командной строки выводит действия, которые были бы
           выполнены в обычном режиме, но не выполняет их. Это не требует
           привилегий root. В визуальном интерфейсе всегда открывает кэш в
           режиме только для чтения, независимо от того являетесь вы root или
           нет.

           Соответствует опции настройки Aptitude::Simulate.

   --safe-resolver

           Когда встречаются проблемы с зависимостями, используется
           «безопасный» алгоритм для их разрешения. Этот решатель пытается
           сохранить как можно большее количество ваших выборов; он никогда
           не удалит пакет или не установит версию пакета, которая не
           является версией-кандидатом по-умолчанию. Этот же алгоритм
           используется в safe-upgrade; в самом деле, aptitude
           --safe-resolver full-upgrade эквивалентна aptitude safe-upgrade.
           Поскольку команда safe-upgrade всегда использует безопасный
           решатель, она не принимает флаг --safe-resolver.

           Опция эквивалентна установке переменной настройки
           Aptitude::Always-Use-Safe-Resolver в значение true.

   --schedule-only

           Для команд, изменяющих состояния пакетов, планирует операции на
           будущее, но не выполняет их. Вы можете выполнить запланированные
           действия, запустив aptitude install без аргументов. Это
           эквивалентно выбору действий в визуальном режиме, и выходу из
           программы.

           Например, aptitude --schedule-only install evolution запланирует
           пакет evolution для позднейшей установки.

   --show-package-names когда

           Контролирует то, когда команда versions показывает имена пакетов.
           Доступны следующие настройки:

              * always: отображать имена пакетов всякий раз, когда
                выполняется команда aptitude versions.

              * auto: отображать имена пакетов, когда выполняется aptitude
                versions, если вывод не группируется по пакету, и если нет
                подходящего под шаблон аргумента, или если имеется более
                одного аргумента.

              * never: никогда не отображать имена пакетов в выводе команды
                aptitude versions.

           Опция соответствует пункту настройки
           Aptitude::CmdLine::Versions-Show-Package-Names.

   --show-resolver-actions

           Отобразить действия, выполняемые «безопасным» решателем и командой
           safe-upgrade.

           Когда выполнена команда safe-upgrade или передана опция
           --safe-resolver, aptitude отобразит резюме действий, выполненных
           решателем, до вывода предварительного просмотра установки.
           Эквивалентно опции настройки
           Aptitude::Safe-Resolver::Show-Resolver-Actions.

   --show-summary[=РЕЖИМ]

           Изменяет поведение «aptitude why» так, чтобы кратко выводилась
           каждая цепочка зависимостей, а не отображалась в полном виде. Если
           эта опция имеет место, а РЕЖИМ не «no-summary», цепочки,
           содержащие зависимости типа Предлагает не будут отображаться:
           объедините --show-summary с -v, чтобы увидеть резюме всех причин
           установки целевого пакета.

           РЕЖИМ может быть одним из следующих:

             1. no-summary: не показывать сводку (поведение по-умолчанию,
                если отсутствует опция --show-summary).

             2. first-package: отобразить первый пакет в каждой цепочке. Если
                РЕЖИМ не указан, по-умолчанию берется это значение.

             3. first-package-and-type: отобразить первый пакет в каждой
                цепочке, а также силу самой слабой зависимости в цепочке.

             4. all-packages: кратко отобразить каждую цепочку зависимостей,
                ведущих к целевому пакету.

             5. all-packages-with-dep-versions: кратко отобразить каждую
                цепочку зависимостей, ведущую к целевому пакету, включая
                целевую версию каждой зависимости.

           Опция соответствует опции настройки
           Aptitude::CmdLine::Show-Summary; если в командной строке
           присутствует опция --show-summary, она будет отменять
           Aptitude::CmdLine::Show-Summary.

           Пример 10. Использование --show-summary

           --show-summary используется с -v для отображения всех причин
           установки пакета:

 $ aptitude -v --show-summary why foomatic-db
 Пакеты, требующие foomatic-db:
   cupsys-driver-gutenprint
   foomatic-db-engine
   foomatic-db-gutenprint
   foomatic-db-hpijs
   foomatic-filters-ppds
   foomatic-gui
   kde
   printconf
   wine

 $ aptitude -v --show-summary=first-package-and-type why foomatic-db
 Пакеты, требующие foomatic-db:
   [Зависит] cupsys-driver-gutenprint
   [Зависит] foomatic-db-engine
   [Зависит] foomatic-db-gutenprint
   [Зависит] foomatic-db-hpijs
   [Зависит] foomatic-filters-ppds
   [Зависит] foomatic-gui
   [Зависит] kde
   [Зависит] printconf
   [Зависит] wine

 $ aptitude -v --show-summary=all-packages why foomatic-db
 Пакеты, требующие foomatic-db:
   cupsys-driver-gutenprint D: cups-driver-gutenprint D: cups R: foomatic-filters R: foomatic-db-engine D: foomatic-db
   foomatic-filters-ppds D: foomatic-filters R: foomatic-db-engine D: foomatic-db
   kde D: kdeadmin R: system-config-printer-kde D: system-config-printer R: hal-cups-utils D: cups R: foomatic-filters R: foomatic-db-engine D: foomatic-db
   wine D: libwine-print D: cups-bsd R: cups R: foomatic-filters R: foomatic-db-engine D: foomatic-db
   foomatic-db-engine D: foomatic-db
   foomatic-db-gutenprint D: foomatic-db
   foomatic-db-hpijs D: foomatic-db
   foomatic-gui D: python-foomatic D: foomatic-db-engine D: foomatic-db
   printconf D: foomatic-db

 $ aptitude -v --show-summary=all-packages-with-dep-versions why foomatic-db
 Пакеты, требующие foomatic-db:
   cupsys-driver-gutenprint D: cups-driver-gutenprint (>= 5.0.2-4) D: cups (>= 1.3.0) R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   foomatic-filters-ppds D: foomatic-filters R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   kde D: kdeadmin (>= 4:3.5.5) R: system-config-printer-kde (>= 4:4.2.2-1) D: system-config-printer (>= 1.0.0) R: hal-cups-utils D: cups R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   wine D: libwine-print (= 1.1.15-1) D: cups-bsd R: cups R: foomatic-filters (>= 4.0) R: foomatic-db-engine (>= 4.0) D: foomatic-db (>= 20090301)
   foomatic-db-engine D: foomatic-db
   foomatic-db-gutenprint D: foomatic-db
   foomatic-db-hpijs D: foomatic-db
   foomatic-gui D: python-foomatic (>= 0.7.9.2) D: foomatic-db-engine D: foomatic-db (>= 20090301)
   printconf D: foomatic-db


           --show-summary используется для вывода цепочки на одну строку:

 $ aptitude --show-summary=all-packages why aptitude-gtk libglib2.0-data
 Пакеты, требующие libglib2.0-data:
   aptitude-gtk D: libglib2.0-0 R: libglib2.0-data

   -t выпуск, --target-release выпуск

           Выбирает выпуск, из которого должны быть установлены пакеты.
           Например, «aptitude -t experimental ...» установит пакеты из
           экспериментальной ветки, если вы не выберите обратное. Для
           действий командной строки «changelog», «download» и «show»,
           эквивалентно добавлению названия /выпуска к каждому пакету,
           указанному в командной строке; для других команд это повлияет на
           версию-кандидата по-умолчанию в соответствии с правилами,
           описанными в apt_preferences(5).

           Соответствует пункту настройки APT::Default-Release.

   -V, --show-versions

           Показать, какие версии пакетов будут установлены.

           Соответствует опции настройки Aptitude::CmdLine::Show-Versions.

   -v, --verbose

           Приводит к тому, что некоторые команды (например, show) отображают
           дополнительную информацию. Опция может быть введена несколько раз
           для получения большего количества информации.

           Соответствует опции настройки Aptitude::CmdLine::Verbose.

   --version

           Отобразить версию aptitude и некоторую информацию о том, как он
           был скомпилирован.

   --visual-preview

           При установке или удалении пакетов из командной строки, вместо
           отображения обычного приветствия, запускает визуальный интерфейс и
           отображает его окно предварительного просмотра.

   -W, --show-why

           В предварительном просмотре, отображаемом до установки или
           удаления пакетов, показывает, какие установленные вручную пакеты
           требуют каждый автоматически установленный пакет. Например:

 $ aptitude --show-why install mediawiki
 ...
 Следующие НОВЫЕ пакеты будут установлены:
   libapache2-mod-php5{a} (for mediawiki)  mediawiki  php5{a} (for mediawiki)
   php5-cli{a} (for mediawiki)  php5-common{a} (for mediawiki)
   php5-mysql{a} (for mediawiki)

           Когда объединено с опцией -v или ненулевым значением опции
           Aptitude::CmdLine::Verbose, отображает всю цепочку зависимостей,
           которая приводит к установке каждого пакета. Например:

 $ aptitude -v --show-why install libdb4.2-dev
 Следующие НОВЫЕ пакеты будут установлены:
   libdb4.2{a} (libdb4.2-dev D: libdb4.2)  libdb4.2-dev
 Следующие пакеты будут УДАЛЕНЫ:
   libdb4.4-dev{a} (libdb4.2-dev C: libdb-dev P<- libdb-dev)

           Опция также описывает то, почему удаляются пакеты, как это
           показано выше. В этом примере, libdb4.2-dev конфликтует с
           libdb-dev, который предоставляет libdb-dev.

           Аргумент соответствует опции настройки Aptitude::CmdLine::Show-Why
           и отображает ту же информацию, которая вычисляется aptitude why и
           aptitude why-not.

   -w ширина, --width ширина

           Определяет ширину экрана, которая должна использоваться для вывода
           команды search (по-умолчанию используется ширина терминала).

           Соответствует опции настройки
           Aptitude::CmdLine::Package-Display-Width

   -y, --assume-yes

           Когда представлено приглашение да/нет, допустить, что пользователь
           ввёл «да». В частности, скрывается приглашение, появляющееся при
           установке, обновлении или удалении пакетов. Приглашения для
           «опасных» действий, такие как удаления пакетов первой
           необходимости, все равно будут отображены. Опция отменяет -P.

           Соответствует опции настройки Aptitude::CmdLine::Assume-Yes.

   -Z

           Показать, сколько места на диске будет использовано или
           освобождено установкой, обновлением или удалением каждого
           отдельного пакета.

           Соответствует опции настройки
           Aptitude::CmdLine::Show-Size-Changes.

   Следующие опции применяются к визуальному виду программы, но главным
   образом для внутреннего использования; как правило, вам не понадобится их
   использовать.

   --autoclean-on-startup

           Удаляет старые загруженные файлы при запуске программы
           (эквивалентно запуску программы и выбору Действия → Очистить
           устаревшие файлы). Вы не можете одновременно использовать эту
           опцию и «--autoclean-on-startup», «-i», or «-u».

   --clean-on-startup

           Очищает кэш пакетов при запуске программы (эквивалентно запуску
           программы и выбору Действия → Очистить кэш пакетов). Вы не можете
           одновременно использовать эту опцию и «--autoclean-on-startup»,
           «-i», или «-u».

   -i

           Отображает предварительный просмотр загрузки при запуске программы
           (эквивалентно запуску программы и нажатию клавиши «g»). Вы не
           можете одновременно использовать эту опцию и
           «--autoclean-on-startup», «--clean-on-startup», или «-u».

   -S имя-файла

           Загружает подробную информацию о состоянии из имя-файла, а не из
           стандартного файла состояния.

   -u

           Начинает обновление списка пакетов сразу же при запуске программы.
           Вы не можете одновременно использовать эту опцию и
           «--autoclean-on-startup», «--clean-on-startup», или «-i».

Окружение

   HOME

           Если существует $HOME/.aptitude, aptitude будет хранить файл
           настройки в $HOME/.aptitude/config. В противном случае, каталог
           home текущего пользователя будет найден программой getpwuid(2), и
           файл настройки будет помещён туда.

   PAGER

           Если эта переменная окружения задана, aptitude будет использовать
           её для отображения changelog'ов, когда выполнена команда «aptitude
           changelog » . Если она не задана, её значением по-умолчанию будет
           more.

   TMP

           Если переменная TMPDIR не задана, aptitude сохранит свои временные
           файлы в TMP, если эта переменная задана. В противном случае, она
           сохранит их в /tmp.

   TMPDIR

           aptitude сохранит свои временные файлы в каталог, обозначенный
           этой переменной окружения. Если переменная TMPDIR не задана, то
           будет использована переменная TMP; если переменная TMP также не
           задана, то aptitude будет использовать /tmp.

Файлы

   /var/lib/aptitude/pkgstates

           Файл, в котором сохраняются состояния пакетов и некоторые пакетные
           флаги.

   /etc/apt/apt.conf, /etc/apt/apt.conf.d/*, ~/.aptitude/config

           Файлы настройки aptitude. ~/.aptitude/config отменяет
           /etc/apt/apt.conf. Документацию по формату и содержанию этих
           файлов см. в apt.conf (5)

См. также

   apt-get(8), apt(8), /usr/share/doc/aptitude/html/язык/index.html из пакета
   aptitude-doc-язык

   --------------------------------------------------------------------------

Название

   aptitude-create-state-bundle — связать текущее состояние aptitude

Синтаксис

   aptitude-create-state-bundle [опции...] файл-вывода

Описание

   aptitude-create-state-bundle создаёт сжатый архив с файлами, необходимыми
   для репликации текущего состояния архива пакетов. Следующие файлы и
   каталоги включаются в пакет:

     * $HOME/.aptitude

     * /var/lib/aptitude

     * /var/lib/apt

     * /var/cache/apt/*.bin

     * /etc/apt

     * /var/lib/dpkg/status

   Вывод этой программы может использоваться в качестве аргумента для
   aptitude-run-state-bundle(1).

Опции

   --force-bzip2

           Отменить автоматическое определение того, какой использовать
           алгоритм сжатия. По-умолчанию, aptitude-create-state-bundle
           использует bzip2(1) если он доступен, и gzip(1) в противном
           случае. Указание данной опции приводит к использованию bzip2, даже
           если он кажется недоступным.

   --force-gzip

           Отменить автоматическое определение того, какой использовать
           алгоритм сжатия. По-умолчанию, aptitude-create-state-bundle
           использует bzip2(1) если он доступен, и gzip(1) в противном
           случае. Указание данной опции приводит к использованию gzip, даже
           если доступен bzip2.

   --help

           Вывести краткое сообщение об использовании, затем выйти.

   --print-inputs

           Вместо создания пакета, отображает список файлов и каталогов,
           которые были бы включены в пакет, если бы он был создан.

Формат файла

   Файл-пакет является обычным tar(1) файлом, сжатым bzip2(1) или gzip(1),
   каждое дерево указанного в вводе каталога начинается с «.».

См. также

   aptitude-run-state-bundle(1), aptitude(8), apt(8)

   --------------------------------------------------------------------------

Название

   aptitude-run-state-bundle — распаковать пакет состояния aptitude и
   передать его aptitude

Синтаксис

   aptitude-run-state-bundle [опции...] файл-ввода [ программа
   [аргументы...]]

Описание

   aptitude-run-state-bundle распаковывает данный пакет состояния aptitude,
   созданный командой aptitude-create-state-bundle(1), во временный каталог,
   вызывает программу относительно него, добавляет аргументы, и впоследствии
   удаляет временный каталог. Если программа не указана, по-умолчанию она
   принимается за aptitude(8).

Опции

   Следующие опции могут появится в командной строке до файла вывода. Опции,
   следующие за файлом вывода, предполагается использовать в качестве
   аргументов aptitude.

   --append-args

           При вызове программы поместите опции, указывающие нахождение
           пакета состояния, в конце командной строки, а не в её начале
           (по-умолчанию опции помещаются в начале).

   --help

           Отобразить краткий отчёт об использовании.

   --prepend-args

           Поместить опции, дающие нахождение пакета состояния в начале
           командной строки при вызове программы, отменяя любые предыдущие
           --append-args (по-умолчанию опции должны быть помещены в начале).

   --no-clean

           Не удаляйте распакованный каталог состояния после запуска
           aptitude. Вероятно, вы захотите использовать его, если, например,
           вы занимаетесь отладкой проблемы, возникающей при модификации
           файла состояния aptitude. Когда aptitude закончит работу, имя
           каталога состояния будет напечатано, в будущем вы сможете получить
           к нему доступ.

           Опция включается автоматически при помощи --statedir.

   --really-clean

           Удалить каталог состояния после запуска aptitude, даже если
           имеются опции --no-clean или --statedir.

   --statedir

           Вместо того, чтобы рассматривать файл как пакет состояния,
           рассматривать его как распакованный пакет состояния. Например, вы
           можете использовать это для того, чтобы получить доступ к каталогу
           состояния, который был создан предыдущим запуском команды с опцией
           --no-clean.

   --unpack

           Распаковать файл ввода во временный каталог, но не запускать
           aptitude.

См. также

   aptitude-create-state-bundle(1), aptitude(8), apt(8)
